/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.jakarta9.instrument.jms;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import io.micrometer.jakarta9.instrument.jms.JmsObservationDocumentation;
import io.micrometer.jakarta9.instrument.jms.JmsProcessObservationContext;
import io.micrometer.jakarta9.instrument.jms.JmsProcessObservationConvention;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.Topic;

public class DefaultJmsProcessObservationConvention
implements JmsProcessObservationConvention {
    private static final KeyValue DESTINATION_TEMPORARY = KeyValue.of((KeyName)JmsObservationDocumentation.LowCardinalityKeyNames.DESTINATION_TEMPORARY, (String)"true");
    private static final KeyValue DESTINATION_DURABLE = KeyValue.of((KeyName)JmsObservationDocumentation.LowCardinalityKeyNames.DESTINATION_TEMPORARY, (String)"false");
    private static final KeyValue EXCEPTION_NONE = KeyValue.of((KeyName)JmsObservationDocumentation.LowCardinalityKeyNames.EXCEPTION, (String)"none");
    private static final KeyValue OPERATION_PROCESS = KeyValue.of((KeyName)JmsObservationDocumentation.LowCardinalityKeyNames.OPERATION, (String)"process");
    private static final KeyValue DESTINATION_NAME_UNKNOWN = KeyValue.of((KeyName)JmsObservationDocumentation.HighCardinalityKeyNames.DESTINATION_NAME, (String)"unknown");
    private static final KeyValue MESSAGE_CONVERSATION_ID_UNKNOWN = KeyValue.of((KeyName)JmsObservationDocumentation.HighCardinalityKeyNames.CONVERSATION_ID, (String)"unknown");
    private static final KeyValue MESSAGE_ID_UNKNOWN = KeyValue.of((KeyName)JmsObservationDocumentation.HighCardinalityKeyNames.MESSAGE_ID, (String)"unknown");

    public String getName() {
        return "jms.message.process";
    }

    public String getContextualName(JmsProcessObservationContext context) {
        return this.destinationName(context).getValue() + " process";
    }

    public KeyValues getLowCardinalityKeyValues(JmsProcessObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.exception(context), OPERATION_PROCESS, this.temporaryDestination(context)});
    }

    private KeyValue exception(JmsProcessObservationContext context) {
        Throwable error = context.getError();
        if (error != null) {
            String simpleName = error.getClass().getSimpleName();
            return KeyValue.of((KeyName)JmsObservationDocumentation.LowCardinalityKeyNames.EXCEPTION, (String)(!simpleName.isEmpty() ? simpleName : error.getClass().getName()));
        }
        return EXCEPTION_NONE;
    }

    protected KeyValue temporaryDestination(JmsProcessObservationContext context) {
        try {
            Message message = (Message)context.getCarrier();
            Destination destination = message.getJMSDestination();
            if (destination instanceof TemporaryQueue || destination instanceof TemporaryTopic) {
                return DESTINATION_TEMPORARY;
            }
            return DESTINATION_DURABLE;
        }
        catch (JMSException exc) {
            return DESTINATION_DURABLE;
        }
    }

    public KeyValues getHighCardinalityKeyValues(JmsProcessObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.correlationId(context), this.destinationName(context), this.messageId(context)});
    }

    protected KeyValue correlationId(JmsProcessObservationContext context) {
        try {
            Message message = (Message)context.getCarrier();
            if (message.getJMSCorrelationID() == null) {
                return MESSAGE_CONVERSATION_ID_UNKNOWN;
            }
            return KeyValue.of((KeyName)JmsObservationDocumentation.HighCardinalityKeyNames.CONVERSATION_ID, (String)message.getJMSCorrelationID());
        }
        catch (JMSException exc) {
            return MESSAGE_CONVERSATION_ID_UNKNOWN;
        }
    }

    protected KeyValue destinationName(JmsProcessObservationContext context) {
        try {
            Destination jmsDestination = ((Message)context.getCarrier()).getJMSDestination();
            if (jmsDestination instanceof Queue) {
                Queue queue = (Queue)jmsDestination;
                return KeyValue.of((KeyName)JmsObservationDocumentation.HighCardinalityKeyNames.DESTINATION_NAME, (String)queue.getQueueName());
            }
            if (jmsDestination instanceof Topic) {
                Topic topic = (Topic)jmsDestination;
                return KeyValue.of((KeyName)JmsObservationDocumentation.HighCardinalityKeyNames.DESTINATION_NAME, (String)topic.getTopicName());
            }
            return DESTINATION_NAME_UNKNOWN;
        }
        catch (JMSException e) {
            return DESTINATION_NAME_UNKNOWN;
        }
    }

    protected KeyValue messageId(JmsProcessObservationContext context) {
        try {
            Message message = (Message)context.getCarrier();
            if (message.getJMSMessageID() == null) {
                return MESSAGE_ID_UNKNOWN;
            }
            return KeyValue.of((KeyName)JmsObservationDocumentation.HighCardinalityKeyNames.MESSAGE_ID, (String)message.getJMSMessageID());
        }
        catch (JMSException exc) {
            return MESSAGE_ID_UNKNOWN;
        }
    }
}

