/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.cache;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.cache.CacheMeterBinder;
import io.micrometer.core.instrument.config.InvalidConfigurationException;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.NonNullFields;
import java.util.ArrayList;
import javax.cache.Cache;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

@NonNullApi
@NonNullFields
public class JCacheMetrics
extends CacheMeterBinder {
    private ObjectName objectName;

    public static <K, V, C extends Cache<K, V>> C monitor(MeterRegistry registry, C cache, String ... tags) {
        return JCacheMetrics.monitor(registry, cache, Tags.of(tags));
    }

    public static <K, V, C extends Cache<K, V>> C monitor(MeterRegistry registry, C cache, Iterable<Tag> tags) {
        new JCacheMetrics(cache, tags).bindTo(registry);
        return cache;
    }

    public JCacheMetrics(Cache<?, ?> cache, Iterable<Tag> tags) {
        super(cache, cache.getName(), tags);
        try {
            String cacheManagerUri = cache.getCacheManager().getURI().toString().replace(':', '.');
            this.objectName = new ObjectName("javax.cache:type=CacheStatistics,CacheManager=" + cacheManagerUri + ",Cache=" + cache.getName());
        }
        catch (MalformedObjectNameException ignored) {
            throw new InvalidConfigurationException("Cache name '" + cache.getName() + "' results in an invalid JMX name");
        }
    }

    @Override
    protected Long size() {
        return null;
    }

    @Override
    protected long hitCount() {
        return this.lookupStatistic("CacheHits");
    }

    @Override
    protected Long missCount() {
        return this.lookupStatistic("CacheMisses");
    }

    @Override
    protected Long evictionCount() {
        return this.lookupStatistic("CacheEvictions");
    }

    @Override
    protected long putCount() {
        return this.lookupStatistic("CachePuts");
    }

    @Override
    protected void bindImplementationSpecificMetrics(MeterRegistry registry) {
        Gauge.builder("cache.removals", this.objectName, objectName -> this.lookupStatistic("CacheRemovals")).tags(this.getTagsWithCacheName()).description("Cache removals").register(registry);
    }

    private long lookupStatistic(String name) {
        try {
            ArrayList<MBeanServer> mBeanServers = MBeanServerFactory.findMBeanServer(null);
            for (MBeanServer mBeanServer : mBeanServers) {
                try {
                    Object attribute = mBeanServer.getAttribute(this.objectName, name);
                    return (Long)attribute;
                }
                catch (AttributeNotFoundException | InstanceNotFoundException operationsException) {
                }
            }
        }
        catch (MBeanException | ReflectionException ex) {
            throw new IllegalStateException(ex);
        }
        return 0L;
    }
}

