/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.cache;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.binder.cache.CacheMeterBinder;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.NonNullFields;
import java.util.concurrent.TimeUnit;

@NonNullApi
@NonNullFields
public class CaffeineCacheMetrics
extends CacheMeterBinder {
    private final Cache<?, ?> cache;

    public CaffeineCacheMetrics(Cache<?, ?> cache, String cacheName, Iterable<Tag> tags) {
        super(cache, cacheName, tags);
        this.cache = cache;
    }

    public static <C extends Cache> C monitor(MeterRegistry registry, C cache, String cacheName, String ... tags) {
        return CaffeineCacheMetrics.monitor(registry, cache, cacheName, Tags.of(tags));
    }

    public static <C extends Cache> C monitor(MeterRegistry registry, C cache, String cacheName, Iterable<Tag> tags) {
        new CaffeineCacheMetrics(cache, cacheName, tags).bindTo(registry);
        return cache;
    }

    public static <C extends AsyncLoadingCache> C monitor(MeterRegistry registry, C cache, String cacheName, String ... tags) {
        return CaffeineCacheMetrics.monitor(registry, cache, cacheName, Tags.of(tags));
    }

    public static <C extends AsyncLoadingCache> C monitor(MeterRegistry registry, C cache, String cacheName, Iterable<Tag> tags) {
        CaffeineCacheMetrics.monitor(registry, cache.synchronous(), cacheName, tags);
        return cache;
    }

    @Override
    protected Long size() {
        return this.cache.estimatedSize();
    }

    @Override
    protected long hitCount() {
        return this.cache.stats().hitCount();
    }

    @Override
    protected Long missCount() {
        return this.cache.stats().missCount();
    }

    @Override
    protected Long evictionCount() {
        return this.cache.stats().evictionCount();
    }

    @Override
    protected long putCount() {
        this.cache.stats().requestCount();
        return this.cache.stats().loadCount();
    }

    @Override
    protected void bindImplementationSpecificMetrics(MeterRegistry registry) {
        Gauge.builder("cache.eviction.weight", this.cache, c -> c.stats().evictionWeight()).tags(this.getTagsWithCacheName()).description("The sum of weights of evicted entries. This total does not include manual invalidations.").register(registry);
        if (this.cache instanceof LoadingCache) {
            TimeGauge.builder("cache.load.duration", this.cache, TimeUnit.NANOSECONDS, c -> c.stats().totalLoadTime()).tags(this.getTagsWithCacheName()).description("The time the cache has spent loading new values").register(registry);
            FunctionCounter.builder("cache.load", this.cache, c -> c.stats().loadSuccessCount()).tags(this.getTagsWithCacheName()).tags("result", "success").description("The number of times cache lookup methods have successfully loaded a new value").register(registry);
            FunctionCounter.builder("cache.load", this.cache, c -> c.stats().loadFailureCount()).tags(this.getTagsWithCacheName()).tags("result", "failure").description("The number of times {@link Cache} lookup methods failed to load a new value, either because no value was found or an exception was thrown while loading").register(registry);
        }
    }
}

