/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.simple;

import io.micrometer.core.instrument.AbstractDistributionSummary;
import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.cumulative.CumulativeCounter;
import io.micrometer.core.instrument.cumulative.CumulativeDistributionSummary;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionCounter;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionTimer;
import io.micrometer.core.instrument.cumulative.CumulativeTimer;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.histogram.pause.PauseDetector;
import io.micrometer.core.instrument.internal.DefaultGauge;
import io.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import io.micrometer.core.instrument.internal.DefaultMeter;
import io.micrometer.core.instrument.simple.SimpleConfig;
import io.micrometer.core.instrument.step.StepCounter;
import io.micrometer.core.instrument.step.StepDistributionSummary;
import io.micrometer.core.instrument.step.StepTimer;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.core.lang.Nullable;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;

public class SimpleMeterRegistry
extends MeterRegistry {
    private final DecimalFormat percentileFormat = new DecimalFormat("#.####");
    private final SimpleConfig config;

    public SimpleMeterRegistry() {
        this(SimpleConfig.DEFAULT, Clock.SYSTEM);
    }

    public SimpleMeterRegistry(SimpleConfig config, Clock clock) {
        super(clock);
        this.config = config;
    }

    @Override
    protected DistributionSummary newDistributionSummary(Meter.Id id, HistogramConfig histogramConfig) {
        AbstractDistributionSummary summary;
        HistogramConfig merged = histogramConfig.merge(HistogramConfig.builder().histogramExpiry(this.config.step()).build());
        switch (this.config.mode()) {
            case CUMULATIVE: {
                summary = new CumulativeDistributionSummary(id, this.clock, merged);
                break;
            }
            default: {
                summary = new StepDistributionSummary(id, this.clock, merged);
            }
        }
        if (histogramConfig.getPercentiles() != null) {
            for (double percentile : histogramConfig.getPercentiles()) {
                this.gauge(id.getName(), Tags.concat(this.getConventionTags(id), "percentile", this.percentileFormat.format(percentile)), summary, s -> summary.percentile(percentile));
            }
        }
        if (histogramConfig.isPublishingHistogram()) {
            Object object = histogramConfig.getHistogramBuckets(false).iterator();
            while (object.hasNext()) {
                Long bucket = (Long)object.next();
                this.more().counter(this.getConventionName(id), Tags.concat(this.getConventionTags(id), "bucket", Long.toString(bucket)), summary, (T s) -> s.histogramCountAtValue(bucket));
            }
        }
        return summary;
    }

    @Override
    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        return new DefaultMeter(id, type, measurements);
    }

    @Override
    protected Timer newTimer(Meter.Id id, HistogramConfig histogramConfig, PauseDetector pauseDetector) {
        AbstractTimer timer;
        HistogramConfig merged = histogramConfig.merge(HistogramConfig.builder().histogramExpiry(this.config.step()).build());
        switch (this.config.mode()) {
            case CUMULATIVE: {
                timer = new CumulativeTimer(id, this.clock, merged, pauseDetector, this.getBaseTimeUnit());
                break;
            }
            default: {
                timer = new StepTimer(id, this.clock, merged, pauseDetector, this.getBaseTimeUnit());
            }
        }
        if (histogramConfig.getPercentiles() != null) {
            for (double percentile : histogramConfig.getPercentiles()) {
                this.gauge(id.getName(), Tags.concat(this.getConventionTags(id), "percentile", this.percentileFormat.format(percentile)), timer, t -> t.percentile(percentile, this.getBaseTimeUnit()));
            }
        }
        if (histogramConfig.isPublishingHistogram()) {
            Object object = histogramConfig.getHistogramBuckets(false).iterator();
            while (object.hasNext()) {
                Long bucket = (Long)object.next();
                this.more().counter(this.getConventionName(id), Tags.concat(this.getConventionTags(id), "bucket", this.percentileFormat.format(TimeUtils.nanosToUnit(bucket.longValue(), this.getBaseTimeUnit()))), timer, (T t) -> t.histogramCountAtValue(bucket));
            }
        }
        return timer;
    }

    @Override
    protected <T> Gauge newGauge(Meter.Id id, @Nullable T obj, ToDoubleFunction<T> valueFunction) {
        return new DefaultGauge<T>(id, obj, valueFunction);
    }

    @Override
    protected Counter newCounter(Meter.Id id) {
        switch (this.config.mode()) {
            case CUMULATIVE: {
                return new CumulativeCounter(id);
            }
        }
        return new StepCounter(id, this.clock, this.config.step().toMillis());
    }

    @Override
    protected LongTaskTimer newLongTaskTimer(Meter.Id id) {
        return new DefaultLongTaskTimer(id, this.clock);
    }

    @Override
    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnits) {
        return new CumulativeFunctionTimer<T>(id, obj, countFunction, totalTimeFunction, totalTimeFunctionUnits, this.getBaseTimeUnit());
    }

    @Override
    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> valueFunction) {
        return new CumulativeFunctionCounter<T>(id, obj, valueFunction);
    }

    @Override
    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.SECONDS;
    }

    @Override
    protected HistogramConfig defaultHistogramConfig() {
        return HistogramConfig.builder().histogramExpiry(this.config.step()).build().merge(HistogramConfig.DEFAULT);
    }
}

