/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.dropwizard;

import com.codahale.metrics.Timer;
import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.histogram.pause.PauseDetector;
import io.micrometer.core.instrument.util.TimeDecayingMax;
import io.micrometer.core.instrument.util.TimeUtils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class DropwizardTimer
extends AbstractTimer {
    private final Timer impl;
    private final AtomicLong totalTime = new AtomicLong(0L);
    private final TimeDecayingMax max;

    DropwizardTimer(Meter.Id id, Timer impl, Clock clock, HistogramConfig histogramConfig, PauseDetector pauseDetector) {
        super(id, clock, histogramConfig, pauseDetector, TimeUnit.MILLISECONDS);
        this.impl = impl;
        this.max = new TimeDecayingMax(clock, histogramConfig);
    }

    @Override
    protected void recordNonNegative(long amount, TimeUnit unit) {
        if (amount >= 0L) {
            this.impl.update(amount, unit);
            long nanoAmount = TimeUnit.NANOSECONDS.convert(amount, unit);
            this.max.record(nanoAmount, TimeUnit.NANOSECONDS);
            this.totalTime.addAndGet(nanoAmount);
        }
    }

    @Override
    public long count() {
        return this.impl.getCount();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return TimeUtils.nanosToUnit(this.totalTime.get(), unit);
    }

    @Override
    public double max(TimeUnit unit) {
        return this.max.poll(unit);
    }
}

