/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.cumulative;

import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.util.TimeUtils;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;

public class CumulativeFunctionTimer<T>
implements FunctionTimer {
    private final Meter.Id id;
    private final WeakReference<T> ref;
    private final ToLongFunction<T> countFunction;
    private final ToDoubleFunction<T> totalTimeFunction;
    private final TimeUnit totalTimeFunctionUnits;
    private final TimeUnit baseTimeUnit;
    private volatile long lastCount = 0L;
    private volatile double lastTime = 0.0;

    public CumulativeFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnits, TimeUnit baseTimeUnit) {
        this.id = id;
        this.ref = new WeakReference<T>(obj);
        this.countFunction = countFunction;
        this.totalTimeFunction = totalTimeFunction;
        this.totalTimeFunctionUnits = totalTimeFunctionUnits;
        this.baseTimeUnit = baseTimeUnit;
    }

    @Override
    public double count() {
        double d;
        Object obj2 = this.ref.get();
        if (obj2 != null) {
            this.lastCount = this.countFunction.applyAsLong(obj2);
            d = this.lastCount;
        } else {
            d = this.lastCount;
        }
        return d;
    }

    @Override
    public double totalTime(TimeUnit unit) {
        Object obj2 = this.ref.get();
        if (obj2 == null) {
            return this.lastTime;
        }
        this.lastTime = TimeUtils.convert(this.totalTimeFunction.applyAsDouble(obj2), this.totalTimeFunctionUnits, unit);
        return this.lastTime;
    }

    @Override
    public Meter.Id getId() {
        return this.id;
    }

    @Override
    public TimeUnit baseTimeUnit() {
        return this.baseTimeUnit;
    }

    @Override
    public Meter.Type type() {
        return Meter.Type.Timer;
    }
}

