/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.config;

import io.micrometer.core.annotation.Incubating;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.config.MeterFilterReply;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.lang.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@Incubating(since="1.0.0-rc.3")
public interface MeterFilter {
    public static MeterFilter commonTags(final Iterable<Tag> tags) {
        return new MeterFilter(){

            @Override
            public Meter.Id map(Meter.Id id) {
                ArrayList<Tag> allTags = new ArrayList<Tag>();
                id.getTags().forEach(allTags::add);
                tags.forEach(allTags::add);
                return new Meter.Id(id.getName(), allTags, id.getBaseUnit(), id.getDescription(), id.getType());
            }
        };
    }

    public static MeterFilter renameTag(final String meterNamePrefix, final String fromTagKey, final String toTagKey) {
        return new MeterFilter(){

            @Override
            public Meter.Id map(Meter.Id id) {
                if (!id.getName().startsWith(meterNamePrefix)) {
                    return id;
                }
                ArrayList<Tag> tags = new ArrayList<Tag>();
                for (Tag tag : id.getTags()) {
                    if (tag.getKey().equals(fromTagKey)) {
                        tags.add(Tag.of(toTagKey, tag.getValue()));
                        continue;
                    }
                    tags.add(tag);
                }
                return new Meter.Id(id.getName(), tags, id.getBaseUnit(), id.getDescription(), id.getType());
            }
        };
    }

    public static MeterFilter ignoreTags(final String ... tagKeys) {
        return new MeterFilter(){

            @Override
            public Meter.Id map(Meter.Id id) {
                List<Tag> tags = StreamSupport.stream(id.getTags().spliterator(), false).filter(t -> {
                    for (String tagKey : tagKeys) {
                        if (!t.getKey().equals(tagKey)) continue;
                        return false;
                    }
                    return true;
                }).collect(Collectors.toList());
                return new Meter.Id(id.getName(), tags, id.getBaseUnit(), id.getDescription(), id.getType());
            }
        };
    }

    public static MeterFilter replaceTagValues(final String tagKey, final Function<String, String> replacement, final String ... exceptions) {
        return new MeterFilter(){

            @Override
            public Meter.Id map(Meter.Id id) {
                List<Tag> tags = StreamSupport.stream(id.getTags().spliterator(), false).map((? super T t) -> {
                    if (!t.getKey().equals(tagKey)) {
                        return t;
                    }
                    for (String exception : exceptions) {
                        if (!t.getValue().equals(exception)) continue;
                        return t;
                    }
                    return Tag.of(tagKey, (String)replacement.apply(t.getValue()));
                }).collect(Collectors.toList());
                return new Meter.Id(id.getName(), tags, id.getBaseUnit(), id.getDescription(), id.getType());
            }
        };
    }

    public static MeterFilter accept(final Predicate<Meter.Id> iff) {
        return new MeterFilter(){

            @Override
            public MeterFilterReply accept(Meter.Id id) {
                return iff.test(id) ? MeterFilterReply.ACCEPT : MeterFilterReply.NEUTRAL;
            }
        };
    }

    public static MeterFilter deny(final Predicate<Meter.Id> iff) {
        return new MeterFilter(){

            @Override
            public MeterFilterReply accept(Meter.Id id) {
                return iff.test(id) ? MeterFilterReply.DENY : MeterFilterReply.NEUTRAL;
            }
        };
    }

    public static MeterFilter accept() {
        return MeterFilter.accept(id -> true);
    }

    public static MeterFilter deny() {
        return MeterFilter.deny(id -> true);
    }

    public static MeterFilter maximumAllowableMetrics(final int maximumTimeSeries) {
        return new MeterFilter(){
            private final Set<Meter.Id> ids = ConcurrentHashMap.newKeySet();

            @Override
            public MeterFilterReply accept(Meter.Id id) {
                if (this.ids.size() > maximumTimeSeries) {
                    return MeterFilterReply.DENY;
                }
                this.ids.add(id);
                return this.ids.size() > maximumTimeSeries ? MeterFilterReply.DENY : MeterFilterReply.NEUTRAL;
            }
        };
    }

    public static MeterFilter maximumAllowableTags(final String meterNamePrefix, final String tagKey, final int maximumTagValues, final MeterFilter onMaxReached) {
        return new MeterFilter(){
            private final Set<String> observedTagValues = new ConcurrentSkipListSet<String>();

            @Override
            public MeterFilterReply accept(Meter.Id id) {
                String value;
                if (id.getName().equals(meterNamePrefix) && (value = id.getTag(tagKey)) != null) {
                    this.observedTagValues.add(value);
                }
                if (this.observedTagValues.size() > maximumTagValues) {
                    return onMaxReached.accept(id);
                }
                return MeterFilterReply.NEUTRAL;
            }

            @Override
            public HistogramConfig configure(Meter.Id id, HistogramConfig config) {
                if (this.observedTagValues.size() > maximumTagValues) {
                    return onMaxReached.configure(id, config);
                }
                return config;
            }
        };
    }

    public static MeterFilter denyNameStartsWith(String prefix) {
        return MeterFilter.deny(id -> id.getName().startsWith(prefix));
    }

    default public MeterFilterReply accept(Meter.Id id) {
        return MeterFilterReply.NEUTRAL;
    }

    default public Meter.Id map(Meter.Id id) {
        return id;
    }

    @Nullable
    default public HistogramConfig configure(Meter.Id id, HistogramConfig config) {
        return config;
    }
}

