/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.system;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.NonNullFields;
import io.micrometer.core.lang.Nullable;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;

@NonNullApi
@NonNullFields
public class FileDescriptorMetrics
implements MeterBinder {
    private final OperatingSystemMXBean osBean;
    private final Iterable<Tag> tags;
    @Nullable
    private final Method openFdsMethod;
    @Nullable
    private final Method maxFdsMethod;

    public FileDescriptorMetrics() {
        this(Collections.emptyList());
    }

    public FileDescriptorMetrics(Iterable<Tag> tags) {
        this(ManagementFactory.getOperatingSystemMXBean(), tags);
    }

    FileDescriptorMetrics(OperatingSystemMXBean osBean, Iterable<Tag> tags) {
        this.osBean = osBean;
        this.tags = tags;
        this.openFdsMethod = this.detectMethod("getOpenFileDescriptorCount");
        this.maxFdsMethod = this.detectMethod("getMaxFileDescriptorCount");
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        if (this.openFdsMethod != null) {
            Gauge.builder("process.open.fds", this.osBean, x -> this.invoke(this.openFdsMethod)).tags(this.tags).description("The open file descriptor count").register(registry);
        }
        if (this.maxFdsMethod != null) {
            Gauge.builder("process.max.fds", this.osBean, x -> this.invoke(this.maxFdsMethod)).tags(this.tags).description("The maximum file descriptor count").register(registry);
        }
    }

    private double invoke(@Nullable Method method) {
        try {
            return method != null ? (double)((Long)method.invoke((Object)this.osBean, new Object[0])).longValue() : Double.NaN;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return Double.NaN;
        }
    }

    @Nullable
    private Method detectMethod(String name) {
        try {
            Method method = this.osBean.getClass().getDeclaredMethod(name, new Class[0]);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return null;
        }
    }
}

