/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.cache;

import com.hazelcast.core.IMap;
import com.hazelcast.monitor.LocalMapStats;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.NonNullFields;
import java.util.concurrent.TimeUnit;

@NonNullApi
@NonNullFields
public class HazelcastCacheMetrics
implements MeterBinder {
    private final IMap<?, ?> cache;
    private final String name;
    private final Iterable<Tag> tags;

    public HazelcastCacheMetrics(IMap<?, ?> cache, String name, Iterable<Tag> tags) {
        this.cache = cache;
        this.name = name;
        this.tags = tags;
    }

    public static <K, V, C extends IMap<K, V>> C monitor(MeterRegistry registry, C cache, String name, String ... tags) {
        return HazelcastCacheMetrics.monitor(registry, cache, name, Tags.of(tags));
    }

    public static <K, V, C extends IMap<K, V>> C monitor(MeterRegistry registry, C cache, String name, Iterable<Tag> tags) {
        new HazelcastCacheMetrics(cache, name, tags).bindTo(registry);
        return cache;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        Gauge.builder(this.name + ".requests", this.cache, cache -> cache.getLocalMapStats().getHits()).tags(this.tags).tags("result", "hit").description("The number of times cache lookup methods have returned a cached value").register(registry);
        Gauge.builder(this.name + ".requests", this.cache, cache -> {
            LocalMapStats stats = cache.getLocalMapStats();
            return stats.getGetOperationCount() - stats.getHits();
        }).tags(this.tags).tags("result", "miss").description("The number of times cache lookup methods have not returned a value").register(registry);
        Gauge.builder(this.name + ".entries", this.cache, cache -> cache.getLocalMapStats().getBackupEntryCount()).tags(this.tags).tags("ownership", "backup").description("The number of backup entries held by this member").register(registry);
        Gauge.builder(this.name + ".entries", this.cache, cache -> cache.getLocalMapStats().getOwnedEntryCount()).tags(this.tags).tags("ownership", "owned").description("The number of owned entries held by this member").register(registry);
        Gauge.builder(this.name + ".entry.memory", this.cache, cache -> cache.getLocalMapStats().getBackupEntryMemoryCost()).tags(this.tags).tags("ownership", "backup").description("Memory cost of backup entries held by this member").baseUnit("bytes").register(registry);
        Gauge.builder(this.name + ".entry.memory", this.cache, cache -> cache.getLocalMapStats().getOwnedEntryMemoryCost()).tags(this.tags).tags("ownership", "owned").description("Memory cost of owned entries held by this member").baseUnit("bytes").register(registry);
        this.timings(registry);
        this.nearCacheMetrics(registry);
    }

    private void nearCacheMetrics(MeterRegistry registry) {
        if (this.cache.getLocalMapStats().getNearCacheStats() != null) {
            Gauge.builder(this.name + ".near.requests", this.cache, cache -> cache.getLocalMapStats().getNearCacheStats().getHits()).tags(this.tags).tags("result", "hit").description("The number of hits (reads) of near cache entries owned by this member").register(registry);
            Gauge.builder(this.name + ".near.requests", this.cache, cache -> cache.getLocalMapStats().getNearCacheStats().getMisses()).tags(this.tags).tags("result", "miss").description("The number of hits (reads) of near cache entries owned by this member").register(registry);
            Gauge.builder(this.name + ".near.evictions", this.cache, cache -> cache.getLocalMapStats().getNearCacheStats().getEvictions()).tags(this.tags).description("The number of evictions of near cache entries owned by this member").register(registry);
            Gauge.builder(this.name + ".near.persistences", this.cache, cache -> cache.getLocalMapStats().getNearCacheStats().getPersistenceCount()).tags(this.tags).description("The number of Near Cache key persistences (when the pre-load feature is enabled)").register(registry);
        }
    }

    private void timings(MeterRegistry registry) {
        FunctionTimer.builder(this.name + ".gets", this.cache, cache -> cache.getLocalMapStats().getGetOperationCount(), cache -> cache.getLocalMapStats().getTotalGetLatency(), TimeUnit.NANOSECONDS).tags(this.tags).description("Cache gets").register(registry);
        FunctionTimer.builder(this.name + ".puts", this.cache, cache -> cache.getLocalMapStats().getPutOperationCount(), cache -> cache.getLocalMapStats().getTotalPutLatency(), TimeUnit.NANOSECONDS).tags(this.tags).description("Cache puts").register(registry);
        FunctionTimer.builder(this.name + ".removals", this.cache, cache -> cache.getLocalMapStats().getRemoveOperationCount(), cache -> cache.getLocalMapStats().getTotalRemoveLatency(), TimeUnit.NANOSECONDS).tags(this.tags).description("Cache removals").register(registry);
    }
}

