/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.lang.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public interface Meter {
    public static Builder builder(String name, Type type, Iterable<Measurement> measurements) {
        return new Builder(name, type, measurements);
    }

    public Id getId();

    public Iterable<Measurement> measure();

    default public Type type() {
        return Type.Other;
    }

    public static class Builder {
        private final String name;
        private final Type type;
        private final Iterable<Measurement> measurements;
        private final List<Tag> tags = new ArrayList<Tag>();
        @Nullable
        private String description;
        @Nullable
        private String baseUnit;

        private Builder(String name, Type type, Iterable<Measurement> measurements) {
            this.name = name;
            this.type = type;
            this.measurements = measurements;
        }

        public Builder tags(String ... tags) {
            return this.tags(Tags.of(tags));
        }

        public Builder tags(Iterable<Tag> tags) {
            tags.forEach(this.tags::add);
            return this;
        }

        public Builder tag(String key, String value) {
            this.tags.add(Tag.of(key, value));
            return this;
        }

        public Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public Builder baseUnit(@Nullable String unit) {
            this.baseUnit = unit;
            return this;
        }

        public Meter register(MeterRegistry registry) {
            return registry.register(new Id(this.name, this.tags, this.baseUnit, this.description, this.type), this.type, this.measurements);
        }
    }

    public static class Id {
        private final String name;
        private final List<Tag> tags;
        private Type type;
        @Nullable
        private final String description;
        @Nullable
        private String baseUnit;

        public Id(String name, Iterable<Tag> tags, @Nullable String baseUnit, @Nullable String description, Type type) {
            this.name = name;
            this.tags = Collections.unmodifiableList(StreamSupport.stream(tags.spliterator(), false).sorted(Comparator.comparing(Tag::getKey)).distinct().collect(Collectors.toList()));
            this.baseUnit = baseUnit;
            this.description = description;
            this.type = type;
        }

        public Id withTag(Tag tag) {
            return new Id(this.name, Tags.concat(this.tags, Collections.singletonList(tag)), this.baseUnit, this.description, this.type);
        }

        public Id withTag(Statistic statistic) {
            return this.withTag(Tag.of("statistic", statistic.getTagValueRepresentation()));
        }

        public Id withBaseUnit(@Nullable String newBaseUnit) {
            return new Id(this.name, this.tags, newBaseUnit, this.description, this.type);
        }

        public String getName() {
            return this.name;
        }

        public Iterable<Tag> getTags() {
            return this.tags;
        }

        @Nullable
        public String getTag(String key) {
            for (Tag tag : this.tags) {
                if (!tag.getKey().equals(key)) continue;
                return tag.getValue();
            }
            return null;
        }

        @Nullable
        public String getBaseUnit() {
            return this.baseUnit;
        }

        public String getConventionName(NamingConvention namingConvention) {
            return namingConvention.name(this.name, this.type, this.baseUnit);
        }

        public List<Tag> getConventionTags(NamingConvention namingConvention) {
            return this.tags.stream().map(t -> Tag.of(namingConvention.tagKey(t.getKey()), namingConvention.tagValue(t.getValue()))).collect(Collectors.toList());
        }

        @Nullable
        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return "MeterId{name='" + this.name + '\'' + ", tags=" + this.tags + '}';
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Id meterId = (Id)o;
            return Objects.equals(this.name, meterId.name) && Objects.equals(this.tags, meterId.tags);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.tags);
        }

        public Type getType() {
            return this.type;
        }
    }

    public static enum Type {
        Counter,
        Gauge,
        LongTaskTimer,
        Timer,
        DistributionSummary,
        Other;

    }
}

