/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx;

import io.mantisrx.shaded.org.jboss.netty.buffer.ChannelBuffer;
import io.mantisrx.shaded.org.jboss.netty.buffer.ChannelBuffers;
import io.mantisrx.shaded.org.jboss.netty.channel.Channel;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelFuture;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelFutureListener;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelHandler;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelPipeline;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpRequest;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpVersion;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocket08FrameDecoder;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocket08FrameEncoder;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketUtil;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.mantisrx.shaded.org.jboss.netty.logging.InternalLogger;
import io.mantisrx.shaded.org.jboss.netty.logging.InternalLoggerFactory;
import io.mantisrx.shaded.org.jboss.netty.util.CharsetUtil;

public class WebSocketServerHandshaker08
extends WebSocketServerHandshaker {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketServerHandshaker08.class);
    public static final String WEBSOCKET_08_ACCEPT_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private final boolean allowExtensions;

    public WebSocketServerHandshaker08(String webSocketURL, String subprotocols, boolean allowExtensions) {
        this(webSocketURL, subprotocols, allowExtensions, Long.MAX_VALUE);
    }

    public WebSocketServerHandshaker08(String webSocketURL, String subprotocols, boolean allowExtensions, long maxFramePayloadLength) {
        super(WebSocketVersion.V08, webSocketURL, subprotocols, maxFramePayloadLength);
        this.allowExtensions = allowExtensions;
    }

    public ChannelFuture handshake(Channel channel, HttpRequest req) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Channel %s WS Version 8 server handshake", channel.getId()));
        }
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS);
        String key = req.getHeader("Sec-WebSocket-Key");
        if (key == null) {
            throw new WebSocketHandshakeException("not a WebSocket request: missing key");
        }
        String acceptSeed = key + WEBSOCKET_08_ACCEPT_GUID;
        ChannelBuffer sha1 = WebSocketUtil.sha1(ChannelBuffers.copiedBuffer((CharSequence)acceptSeed, CharsetUtil.US_ASCII));
        String accept = WebSocketUtil.base64(sha1);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("WS Version 8 Server Handshake key: %s. Response: %s.", key, accept));
        }
        res.setStatus(HttpResponseStatus.SWITCHING_PROTOCOLS);
        res.addHeader("Upgrade", "WebSocket".toLowerCase());
        res.addHeader("Connection", "Upgrade");
        res.addHeader("Sec-WebSocket-Accept", accept);
        String subprotocols = req.getHeader("Sec-WebSocket-Protocol");
        if (subprotocols != null) {
            String selectedSubprotocol = this.selectSubprotocol(subprotocols);
            if (selectedSubprotocol == null) {
                throw new WebSocketHandshakeException("Requested subprotocol(s) not supported: " + subprotocols);
            }
            res.addHeader("Sec-WebSocket-Protocol", selectedSubprotocol);
            this.setSelectedSubprotocol(selectedSubprotocol);
        }
        ChannelFuture future = channel.write(res);
        future.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                ChannelPipeline p = future.getChannel().getPipeline();
                if (p.get(HttpChunkAggregator.class) != null) {
                    p.remove(HttpChunkAggregator.class);
                }
                p.get(HttpRequestDecoder.class).replace("wsdecoder", new WebSocket08FrameDecoder(true, WebSocketServerHandshaker08.this.allowExtensions, WebSocketServerHandshaker08.this.getMaxFramePayloadLength()));
                p.replace(HttpResponseEncoder.class, "wsencoder", (ChannelHandler)new WebSocket08FrameEncoder(false));
            }
        });
        return future;
    }

    public ChannelFuture close(Channel channel, CloseWebSocketFrame frame) {
        ChannelFuture f = channel.write(frame);
        f.addListener(ChannelFutureListener.CLOSE);
        return f;
    }
}

