/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.framework.recipes.shared;

import io.mantisrx.shaded.org.apache.curator.framework.CuratorFramework;
import io.mantisrx.shaded.org.apache.curator.framework.listen.Listenable;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.shared.SharedCountListener;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.shared.SharedCountReader;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.shared.SharedValue;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.shared.SharedValueListener;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.shared.SharedValueReader;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.shared.VersionedValue;
import io.mantisrx.shaded.org.apache.curator.framework.state.ConnectionState;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.Maps;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.Executor;

public class SharedCount
implements Closeable,
SharedCountReader,
Listenable<SharedCountListener> {
    private final Map<SharedCountListener, SharedValueListener> listeners = Maps.newConcurrentMap();
    private final SharedValue sharedValue;

    public SharedCount(CuratorFramework client, String path, int seedValue) {
        this.sharedValue = new SharedValue(client, path, SharedCount.toBytes(seedValue));
    }

    @Override
    public int getCount() {
        return SharedCount.fromBytes(this.sharedValue.getValue());
    }

    @Override
    public VersionedValue<Integer> getVersionedValue() {
        VersionedValue<byte[]> localValue = this.sharedValue.getVersionedValue();
        return new VersionedValue<Integer>(localValue.getVersion(), SharedCount.fromBytes(localValue.getValue()));
    }

    public void setCount(int newCount) throws Exception {
        this.sharedValue.setValue(SharedCount.toBytes(newCount));
    }

    @Deprecated
    public boolean trySetCount(int newCount) throws Exception {
        return this.sharedValue.trySetValue(SharedCount.toBytes(newCount));
    }

    public boolean trySetCount(VersionedValue<Integer> previous, int newCount) throws Exception {
        VersionedValue<byte[]> previousCopy = new VersionedValue<byte[]>(previous.getVersion(), SharedCount.toBytes(previous.getValue()));
        return this.sharedValue.trySetValue(previousCopy, SharedCount.toBytes(newCount));
    }

    @Override
    public void addListener(SharedCountListener listener) {
        this.addListener(listener, (Executor)MoreExecutors.sameThreadExecutor());
    }

    @Override
    public void addListener(final SharedCountListener listener, Executor executor) {
        SharedValueListener valueListener = new SharedValueListener(){

            @Override
            public void valueHasChanged(SharedValueReader sharedValue, byte[] newValue) throws Exception {
                listener.countHasChanged(SharedCount.this, SharedCount.fromBytes(newValue));
            }

            @Override
            public void stateChanged(CuratorFramework client, ConnectionState newState) {
                listener.stateChanged(client, newState);
            }
        };
        this.sharedValue.getListenable().addListener(valueListener, executor);
        this.listeners.put(listener, valueListener);
    }

    @Override
    public void removeListener(SharedCountListener listener) {
        this.listeners.remove(listener);
    }

    public void start() throws Exception {
        this.sharedValue.start();
    }

    @Override
    public void close() throws IOException {
        this.sharedValue.close();
    }

    @VisibleForTesting
    static byte[] toBytes(int value) {
        byte[] bytes = new byte[4];
        ByteBuffer.wrap(bytes).putInt(value);
        return bytes;
    }

    private static int fromBytes(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getInt();
    }
}

