/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.framework.imps;

import io.mantisrx.shaded.org.apache.curator.RetryLoop;
import io.mantisrx.shaded.org.apache.curator.drivers.OperationTrace;
import io.mantisrx.shaded.org.apache.curator.framework.api.Pathable;
import io.mantisrx.shaded.org.apache.curator.framework.api.StatPathable;
import io.mantisrx.shaded.org.apache.curator.framework.api.TempGetDataBuilder;
import io.mantisrx.shaded.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import io.mantisrx.shaded.org.apache.zookeeper.data.Stat;
import java.util.concurrent.Callable;

class TempGetDataBuilderImpl
implements TempGetDataBuilder {
    private final CuratorFrameworkImpl client;
    private Stat responseStat;
    private boolean decompress;

    TempGetDataBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.responseStat = null;
        this.decompress = false;
    }

    @Override
    public StatPathable<byte[]> decompressed() {
        this.decompress = true;
        return this;
    }

    @Override
    public Pathable<byte[]> storingStatIn(Stat stat) {
        this.responseStat = stat;
        return this;
    }

    @Override
    public byte[] forPath(String path) throws Exception {
        final String localPath = this.client.fixForNamespace(path);
        OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("GetDataBuilderImpl-Foreground");
        byte[] responseData = RetryLoop.callWithRetry(this.client.getZookeeperClient(), new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                return TempGetDataBuilderImpl.this.client.getZooKeeper().getData(localPath, false, TempGetDataBuilderImpl.this.responseStat);
            }
        });
        trace.setResponseBytesLength(responseData).setPath(path).setStat(this.responseStat).commit();
        return this.decompress ? this.client.getCompressionProvider().decompress(path, responseData) : responseData;
    }
}

