/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.vavr.jackson.datatype.serialize;

import io.mantisrx.shaded.com.fasterxml.jackson.databind.BeanDescription;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JavaType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.SerializationConfig;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ser.Serializers;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.type.CollectionLikeType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.type.MapLikeType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.type.ReferenceType;
import io.mantisrx.shaded.io.vavr.jackson.datatype.VavrModule;
import io.mantisrx.shaded.io.vavr.jackson.datatype.serialize.ArraySerializer;
import io.mantisrx.shaded.io.vavr.jackson.datatype.serialize.CharSeqSerializer;
import io.mantisrx.shaded.io.vavr.jackson.datatype.serialize.EitherSerializer;
import io.mantisrx.shaded.io.vavr.jackson.datatype.serialize.LazySerializer;
import io.mantisrx.shaded.io.vavr.jackson.datatype.serialize.MapSerializer;
import io.mantisrx.shaded.io.vavr.jackson.datatype.serialize.MultimapSerializer;
import io.mantisrx.shaded.io.vavr.jackson.datatype.serialize.OptionSerializer;
import io.mantisrx.shaded.io.vavr.jackson.datatype.serialize.SerializableSerializer;
import io.mantisrx.shaded.io.vavr.jackson.datatype.serialize.TupleSerializer;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.CheckedFunction2;
import io.vavr.CheckedFunction3;
import io.vavr.CheckedFunction4;
import io.vavr.CheckedFunction5;
import io.vavr.CheckedFunction6;
import io.vavr.CheckedFunction7;
import io.vavr.CheckedFunction8;
import io.vavr.Function0;
import io.vavr.Function1;
import io.vavr.Function2;
import io.vavr.Function3;
import io.vavr.Function4;
import io.vavr.Function5;
import io.vavr.Function6;
import io.vavr.Function7;
import io.vavr.Function8;
import io.vavr.Lazy;
import io.vavr.Tuple;
import io.vavr.collection.CharSeq;
import io.vavr.collection.Map;
import io.vavr.collection.Multimap;
import io.vavr.collection.PriorityQueue;
import io.vavr.collection.Seq;
import io.vavr.collection.Set;
import io.vavr.control.Either;
import io.vavr.control.Option;

public class VavrSerializers
extends Serializers.Base {
    private final VavrModule.Settings settings;

    public VavrSerializers(VavrModule.Settings settings) {
        this.settings = settings;
    }

    @Override
    public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
        Class<?> raw = type.getRawClass();
        if (Either.class.isAssignableFrom(raw)) {
            return new EitherSerializer(type);
        }
        if (Tuple.class.isAssignableFrom(raw)) {
            return new TupleSerializer(type);
        }
        if (Function0.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (Function1.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (Function2.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (Function3.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (Function4.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (Function5.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (Function6.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (Function7.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (Function8.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (CheckedFunction0.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (CheckedFunction1.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (CheckedFunction2.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (CheckedFunction3.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (CheckedFunction4.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (CheckedFunction5.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (CheckedFunction6.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (CheckedFunction7.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (CheckedFunction8.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        return super.findSerializer(config, type, beanDesc);
    }

    @Override
    public JsonSerializer<?> findReferenceSerializer(SerializationConfig config, ReferenceType type, BeanDescription beanDesc, TypeSerializer contentTypeSerializer, JsonSerializer<Object> contentValueSerializer) {
        Class<?> raw = type.getRawClass();
        if (Lazy.class.isAssignableFrom(raw)) {
            return new LazySerializer(type);
        }
        if (Option.class.isAssignableFrom(raw)) {
            return new OptionSerializer(type, this.settings.useOptionInPlainFormat());
        }
        return super.findReferenceSerializer(config, type, beanDesc, contentTypeSerializer, contentValueSerializer);
    }

    @Override
    public JsonSerializer<?> findCollectionLikeSerializer(SerializationConfig config, CollectionLikeType type, BeanDescription beanDesc, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        Class<?> raw = type.getRawClass();
        if (raw == CharSeq.class) {
            return new CharSeqSerializer(type);
        }
        if (Seq.class.isAssignableFrom(raw)) {
            return new ArraySerializer(type);
        }
        if (Set.class.isAssignableFrom(raw)) {
            return new ArraySerializer(type);
        }
        if (PriorityQueue.class.isAssignableFrom(raw)) {
            return new ArraySerializer(type);
        }
        return super.findCollectionLikeSerializer(config, type, beanDesc, elementTypeSerializer, elementValueSerializer);
    }

    @Override
    public JsonSerializer<?> findMapLikeSerializer(SerializationConfig config, MapLikeType type, BeanDescription beanDesc, JsonSerializer<Object> keySerializer, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        Class<?> raw = type.getRawClass();
        if (Map.class.isAssignableFrom(raw)) {
            return new MapSerializer(type);
        }
        if (Multimap.class.isAssignableFrom(raw)) {
            return new MultimapSerializer(type);
        }
        return super.findMapLikeSerializer(config, type, beanDesc, keySerializer, elementTypeSerializer, elementValueSerializer);
    }
}

