/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.parameter;

import io.mantisrx.runtime.parameter.SinkParameter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SinkParameters {
    final List<SinkParameter> params;

    public SinkParameters(List<SinkParameter> params) {
        this.params = params;
    }

    public List<SinkParameter> getSinkParams() {
        return Collections.unmodifiableList(this.params);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SinkParameters other = (SinkParameters)obj;
        return !(this.params == null ? other.params != null : !this.params.equals(other.params));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.params != null && this.params.size() > 0) {
            int size = this.params.size();
            int count = 0;
            sb.append("?");
            for (SinkParameter param : this.params) {
                sb.append(param.getName());
                sb.append("=");
                if (param.getValue() != null && param.getEncodedValue() != null) {
                    sb.append(param.getEncodedValue());
                }
                if (count < size - 1) {
                    sb.append("&");
                }
                ++count;
            }
        }
        return sb.toString();
    }

    public static class Builder {
        List<SinkParameter> parameters = new ArrayList<SinkParameter>();

        public Builder parameters(SinkParameter ... params) {
            for (SinkParameter p : params) {
                this.parameters.add(p);
            }
            return this;
        }

        public Builder withParameter(SinkParameter param) {
            this.parameters.add(param);
            return this;
        }

        public Builder withParameter(String name, String value) throws UnsupportedEncodingException {
            this.parameters(new SinkParameter(name, value));
            return this;
        }

        public SinkParameters build() {
            return new SinkParameters(this.parameters);
        }
    }
}

