/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime;

import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;

public class WorkerMigrationConfig {
    public static final WorkerMigrationConfig DEFAULT = new WorkerMigrationConfig(MigrationStrategyEnum.PERCENTAGE, "{\"percentToMove\":25,\"intervalMs\":60000}");
    private MigrationStrategyEnum strategy;
    private String configString;

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public WorkerMigrationConfig(@JsonProperty(value="strategy") MigrationStrategyEnum strategy, @JsonProperty(value="configString") String configString) {
        this.strategy = Optional.ofNullable(strategy).orElse(MigrationStrategyEnum.ONE_WORKER);
        this.configString = configString;
    }

    public static void main(String[] args) {
        WorkerMigrationConfig workerMigrationConfig = new WorkerMigrationConfig(MigrationStrategyEnum.ONE_WORKER, "{'name':'value'}");
        System.out.println(workerMigrationConfig);
        WorkerMigrationConfig workerMigrationConfig2 = DEFAULT;
        System.out.println(workerMigrationConfig2);
    }

    public MigrationStrategyEnum getStrategy() {
        return this.strategy;
    }

    public String getConfigString() {
        return this.configString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerMigrationConfig that = (WorkerMigrationConfig)o;
        if (this.strategy != that.strategy) {
            return false;
        }
        return this.configString != null ? this.configString.equals(that.configString) : that.configString == null;
    }

    public int hashCode() {
        int result = this.strategy != null ? this.strategy.hashCode() : 0;
        result = 31 * result + (this.configString != null ? this.configString.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "WorkerMigrationConfig{strategy=" + (Object)((Object)this.strategy) + ", configString='" + this.configString + '\'' + '}';
    }

    public static enum MigrationStrategyEnum {
        ONE_WORKER,
        PERCENTAGE;

    }
}

