/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common.metrics.spectator;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Tag;
import java.util.Arrays;
import java.util.Collections;

public class MetricId {
    private final String metricGroup;
    private final String metricName;
    private final Iterable<Tag> tags;

    public MetricId(String metricGroup, String metricName) {
        this(metricGroup, metricName, Collections.emptyList());
    }

    public MetricId(String metricGroup, String metricName, Iterable<Tag> tags) {
        this.metricGroup = metricGroup;
        this.metricName = metricName;
        this.tags = tags;
    }

    public MetricId(String metricGroup, String metricName, Tag ... tags) {
        this.metricGroup = metricGroup;
        this.metricName = metricName;
        this.tags = Arrays.asList(tags);
    }

    public String metricGroup() {
        return this.metricGroup;
    }

    public String metricName() {
        return this.metricName;
    }

    public Iterable<Tag> tags() {
        return this.tags;
    }

    public Id getSpectatorId(Registry registry) {
        return registry.createId(String.format("%s_%s", this.metricGroup, this.metricName), this.tags);
    }

    public String metricNameWithTags() {
        if (this.tags.iterator().hasNext()) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.metricName);
            for (Tag t : this.tags) {
                buf.append(':').append(t.key()).append('=').append(t.value());
            }
            return buf.toString();
        }
        return this.metricName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricId metricId = (MetricId)o;
        if (!this.metricGroup.equals(metricId.metricGroup)) {
            return false;
        }
        if (!this.metricName.equals(metricId.metricName)) {
            return false;
        }
        return this.tags.equals(metricId.tags);
    }

    public int hashCode() {
        int result = this.metricGroup.hashCode();
        result = 31 * result + this.metricName.hashCode();
        result = 31 * result + this.tags.hashCode();
        return result;
    }

    public String toString() {
        return "MetricId{metricGroup='" + this.metricGroup + '\'' + ", metricName='" + this.metricName + '\'' + ", tags=" + this.tags + '}';
    }
}

