/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common.metrics.spectator;

import com.netflix.spectator.api.Registry;
import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.spectator.MetricId;

public class CounterImpl
implements Counter {
    private final MetricId id;
    private final com.netflix.spectator.api.Counter spectatorCounter;

    public CounterImpl(MetricId id, Registry registry) {
        this.id = id;
        this.spectatorCounter = registry.counter(id.getSpectatorId(registry));
    }

    @Override
    public void increment() {
        this.spectatorCounter.increment();
    }

    @Override
    public void increment(long x) {
        if (x < 0L) {
            throw new IllegalArgumentException("Can't add negative numbers");
        }
        this.spectatorCounter.increment(x);
    }

    @Override
    public long value() {
        return this.spectatorCounter.count();
    }

    @Override
    public long rateValue() {
        return -1L;
    }

    @Override
    public long rateTimeInMilliseconds() {
        return -1L;
    }

    @Override
    public String event() {
        return this.spectatorCounter.id().toString();
    }

    @Override
    public MetricId id() {
        return this.id;
    }
}

