/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common.metrics.netty;

import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Gauge;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import io.mantisrx.common.metrics.netty.TcpServerListener;
import java.util.concurrent.TimeUnit;
import mantis.io.reactivex.netty.metrics.HttpServerMetricEventsListener;
import mantis.io.reactivex.netty.server.ServerMetricsEvent;

public class HttpServerListener
extends TcpServerListener<ServerMetricsEvent<?>> {
    private final Gauge requestBacklog;
    private final Gauge inflightRequests;
    private final Counter processedRequests;
    private final Counter failedRequests;
    private final Counter responseWriteFailed;
    private final HttpServerMetricEventsListenerImpl delegate;

    protected HttpServerListener(String monitorId) {
        super(monitorId);
        Metrics m = new Metrics.Builder().name("httpServer_" + monitorId).addGauge("requestBacklog").addGauge("inflightRequests").addCounter("processedRequests").addCounter("failedRequests").addCounter("responseWriteFailed").build();
        m = MetricsRegistry.getInstance().registerAndGet(m);
        this.requestBacklog = m.getGauge("requestBacklog");
        this.inflightRequests = m.getGauge("inflightRequests");
        this.processedRequests = m.getCounter("processedRequests");
        this.failedRequests = m.getCounter("failedRequests");
        this.responseWriteFailed = m.getCounter("responseWriteFailed");
        this.delegate = new HttpServerMetricEventsListenerImpl();
    }

    public static HttpServerListener newHttpListener(String monitorId) {
        return new HttpServerListener(monitorId);
    }

    public void onEvent(ServerMetricsEvent<?> event, long duration, TimeUnit timeUnit, Throwable throwable, Object value) {
        this.delegate.onEvent(event, duration, timeUnit, throwable, value);
    }

    public long getRequestBacklog() {
        return this.requestBacklog.value();
    }

    public long getInflightRequests() {
        return this.inflightRequests.value();
    }

    public long getProcessedRequests() {
        return this.processedRequests.value();
    }

    public long getFailedRequests() {
        return this.failedRequests.value();
    }

    public long getResponseWriteFailed() {
        return this.responseWriteFailed.value();
    }

    private class HttpServerMetricEventsListenerImpl
    extends HttpServerMetricEventsListener {
        private HttpServerMetricEventsListenerImpl() {
        }

        protected void onRequestHandlingFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpServerListener.this.processedRequests.increment();
            HttpServerListener.this.inflightRequests.decrement();
            HttpServerListener.this.failedRequests.increment();
        }

        protected void onRequestHandlingSuccess(long duration, TimeUnit timeUnit) {
            HttpServerListener.this.inflightRequests.decrement();
            HttpServerListener.this.processedRequests.increment();
        }

        protected void onResponseContentWriteSuccess(long duration, TimeUnit timeUnit) {
        }

        protected void onResponseHeadersWriteSuccess(long duration, TimeUnit timeUnit) {
        }

        protected void onResponseContentWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpServerListener.this.responseWriteFailed.increment();
        }

        protected void onResponseHeadersWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpServerListener.this.responseWriteFailed.increment();
        }

        protected void onRequestReceiveComplete(long duration, TimeUnit timeUnit) {
        }

        protected void onRequestHandlingStart(long duration, TimeUnit timeUnit) {
            HttpServerListener.this.requestBacklog.decrement();
        }

        protected void onNewRequestReceived() {
            HttpServerListener.this.requestBacklog.increment();
            HttpServerListener.this.inflightRequests.increment();
        }

        protected void onConnectionHandlingFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpServerListener.this.onConnectionHandlingFailed(duration, timeUnit, throwable);
        }

        protected void onConnectionHandlingSuccess(long duration, TimeUnit timeUnit) {
            HttpServerListener.this.onConnectionHandlingSuccess(duration, timeUnit);
        }

        protected void onConnectionHandlingStart(long duration, TimeUnit timeUnit) {
            HttpServerListener.this.onConnectionHandlingStart(duration, timeUnit);
        }

        protected void onNewClientConnected() {
            HttpServerListener.this.onNewClientConnected();
        }

        protected void onByteRead(long bytesRead) {
            HttpServerListener.this.onByteRead(bytesRead);
        }

        protected void onFlushFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpServerListener.this.onFlushFailed(duration, timeUnit, throwable);
        }

        protected void onFlushSuccess(long duration, TimeUnit timeUnit) {
            HttpServerListener.this.onFlushSuccess(duration, timeUnit);
        }

        protected void onFlushStart() {
            HttpServerListener.this.onFlushStart();
        }

        protected void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpServerListener.this.onWriteFailed(duration, timeUnit, throwable);
        }

        protected void onWriteSuccess(long duration, TimeUnit timeUnit, long bytesWritten) {
            HttpServerListener.this.onWriteSuccess(duration, timeUnit, bytesWritten);
        }

        protected void onWriteStart() {
            HttpServerListener.this.onWriteStart();
        }
    }
}

