/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common.metrics.netty;

import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Tag;
import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Gauge;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.netty.TcpClientListener;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import mantis.io.reactivex.netty.client.ClientMetricsEvent;
import mantis.io.reactivex.netty.metrics.HttpClientMetricEventsListener;

public class HttpClientListener
extends TcpClientListener<ClientMetricsEvent<?>> {
    private final Gauge requestBacklog;
    private final Gauge inflightRequests;
    private final Counter processedRequests;
    private final Counter requestWriteFailed;
    private final Counter failedResponses;
    private final HttpClientMetricEventsListenerImpl delegate = new HttpClientMetricEventsListenerImpl();

    protected HttpClientListener(String monitorId) {
        super(monitorId);
        String metricsGroup = "httpClient";
        String idValue = Optional.ofNullable(monitorId).orElse("none");
        BasicTag idTag = new BasicTag("groupId", idValue);
        Metrics m = new Metrics.Builder().id("httpClient", new Tag[]{idTag}).addGauge("requestBacklog").addGauge("inflightRequests").addCounter("processedRequests").addCounter("requestWriteFailed").addCounter("failedResponses").build();
        this.requestBacklog = m.getGauge("requestBacklog");
        this.inflightRequests = m.getGauge("inflightRequests");
        this.processedRequests = m.getCounter("processedRequests");
        this.requestWriteFailed = m.getCounter("requestWriteFailed");
        this.failedResponses = m.getCounter("failedResponses");
    }

    public static HttpClientListener newHttpListener(String monitorId) {
        return new HttpClientListener(monitorId);
    }

    public void onEvent(ClientMetricsEvent<?> event, long duration, TimeUnit timeUnit, Throwable throwable, Object value) {
        this.delegate.onEvent(event, duration, timeUnit, throwable, value);
    }

    public long getRequestBacklog() {
        return (long)this.requestBacklog.doubleValue();
    }

    public long getInflightRequests() {
        return (long)this.inflightRequests.doubleValue();
    }

    public long getProcessedRequests() {
        return this.processedRequests.value();
    }

    public long getRequestWriteFailed() {
        return this.requestWriteFailed.value();
    }

    public long getFailedResponses() {
        return this.failedResponses.value();
    }

    private class HttpClientMetricEventsListenerImpl
    extends HttpClientMetricEventsListener {
        private HttpClientMetricEventsListenerImpl() {
        }

        protected void onRequestProcessingComplete(long duration, TimeUnit timeUnit) {
        }

        protected void onResponseReceiveComplete(long duration, TimeUnit timeUnit) {
            HttpClientListener.this.inflightRequests.decrement();
            HttpClientListener.this.processedRequests.increment();
        }

        protected void onResponseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpClientListener.this.inflightRequests.decrement();
            HttpClientListener.this.processedRequests.increment();
            HttpClientListener.this.failedResponses.increment();
        }

        protected void onRequestWriteComplete(long duration, TimeUnit timeUnit) {
        }

        protected void onRequestContentWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpClientListener.this.requestWriteFailed.increment();
        }

        protected void onRequestHeadersWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpClientListener.this.requestWriteFailed.increment();
        }

        protected void onRequestHeadersWriteStart() {
            HttpClientListener.this.requestBacklog.decrement();
        }

        protected void onRequestSubmitted() {
            HttpClientListener.this.requestBacklog.increment();
            HttpClientListener.this.inflightRequests.increment();
        }

        protected void onByteRead(long bytesRead) {
            HttpClientListener.this.onByteRead(bytesRead);
        }

        protected void onFlushFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpClientListener.this.onFlushFailed(duration, timeUnit, throwable);
        }

        protected void onFlushSuccess(long duration, TimeUnit timeUnit) {
            HttpClientListener.this.onFlushSuccess(duration, timeUnit);
        }

        protected void onFlushStart() {
            HttpClientListener.this.onFlushStart();
        }

        protected void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpClientListener.this.onWriteFailed(duration, timeUnit, throwable);
        }

        protected void onWriteSuccess(long duration, TimeUnit timeUnit, long bytesWritten) {
            HttpClientListener.this.onWriteSuccess(duration, timeUnit, bytesWritten);
        }

        protected void onWriteStart() {
            HttpClientListener.this.onWriteStart();
        }

        protected void onPoolReleaseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpClientListener.this.onPoolReleaseFailed(duration, timeUnit, throwable);
        }

        protected void onPoolReleaseSuccess(long duration, TimeUnit timeUnit) {
            HttpClientListener.this.onPoolReleaseSuccess(duration, timeUnit);
        }

        protected void onPoolReleaseStart() {
            HttpClientListener.this.onPoolReleaseStart();
        }

        protected void onPooledConnectionEviction() {
            HttpClientListener.this.onPooledConnectionEviction();
        }

        protected void onPooledConnectionReuse(long duration, TimeUnit timeUnit) {
            HttpClientListener.this.onPooledConnectionReuse(duration, timeUnit);
        }

        protected void onPoolAcquireFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpClientListener.this.onPoolAcquireFailed(duration, timeUnit, throwable);
        }

        protected void onPoolAcquireSuccess(long duration, TimeUnit timeUnit) {
            HttpClientListener.this.onPoolAcquireSuccess(duration, timeUnit);
        }

        protected void onPoolAcquireStart() {
            HttpClientListener.this.onPoolAcquireStart();
        }

        protected void onConnectionCloseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpClientListener.this.onConnectionCloseFailed(duration, timeUnit, throwable);
        }

        protected void onConnectionCloseSuccess(long duration, TimeUnit timeUnit) {
            HttpClientListener.this.onConnectionCloseSuccess(duration, timeUnit);
        }

        protected void onConnectionCloseStart() {
            HttpClientListener.this.onConnectionCloseStart();
        }

        protected void onConnectFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpClientListener.this.onConnectFailed(duration, timeUnit, throwable);
        }

        protected void onConnectSuccess(long duration, TimeUnit timeUnit) {
            HttpClientListener.this.onConnectSuccess(duration, timeUnit);
        }

        protected void onConnectStart() {
            HttpClientListener.this.onConnectStart();
        }
    }
}

