/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common.metrics;

import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.spectator.MetricGroupId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MetricsRegistry {
    private static final MetricsRegistry instance = new MetricsRegistry();
    private ConcurrentMap<String, Metrics> metricsRegistered = new ConcurrentHashMap<String, Metrics>();

    private MetricsRegistry() {
    }

    public static MetricsRegistry getInstance() {
        return instance;
    }

    public Metrics registerAndGet(Metrics metrics) {
        Metrics old = this.metricsRegistered.putIfAbsent(metrics.getMetricGroupId().id(), metrics);
        if (old == null) {
            return metrics;
        }
        return old;
    }

    Collection<Metrics> metrics() {
        return this.metricsRegistered.values();
    }

    public Collection<Metrics> getMetrics(String prefix) {
        ArrayList<Metrics> result = new ArrayList<Metrics>();
        for (Metrics m : this.metricsRegistered.values()) {
            if (!m.getMetricGroupId().id().startsWith(prefix)) continue;
            result.add(m);
        }
        return result;
    }

    @Deprecated
    public boolean remove(String metricGroupId) {
        return this.metricsRegistered.remove(metricGroupId) != null;
    }

    public boolean remove(MetricGroupId metricGroupId) {
        return this.metricsRegistered.remove(metricGroupId.id()) != null;
    }

    @Deprecated
    public Metrics getMetric(String metricGroupId) {
        return (Metrics)this.metricsRegistered.get(metricGroupId);
    }

    public Metrics getMetric(MetricGroupId metricGroupId) {
        return (Metrics)this.metricsRegistered.get(metricGroupId.id());
    }
}

