/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SpellCheckResult<V> {
    private final List<MisspelledTerm<V>> misspelledTerms = new ArrayList<MisspelledTerm<V>>();

    public List<MisspelledTerm<V>> getMisspelledTerms() {
        return this.misspelledTerms;
    }

    public boolean hasMisspelledTerms() {
        return !this.misspelledTerms.isEmpty();
    }

    public int getMisspelledTermCount() {
        return this.misspelledTerms.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpellCheckResult that = (SpellCheckResult)o;
        return Objects.equals(this.misspelledTerms, that.misspelledTerms);
    }

    public int hashCode() {
        return Objects.hash(this.misspelledTerms);
    }

    public String toString() {
        return "SpellCheckResult{misspelledTerms=" + this.misspelledTerms + '}';
    }

    void addMisspelledTerm(MisspelledTerm<V> vMisspelledTerm) {
        this.misspelledTerms.add(vMisspelledTerm);
    }

    public static class Suggestion<V> {
        private final double score;
        private final V suggestion;

        public Suggestion(double score, V suggestion) {
            this.score = score;
            this.suggestion = suggestion;
        }

        public double getScore() {
            return this.score;
        }

        public V getSuggestion() {
            return this.suggestion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Suggestion that = (Suggestion)o;
            return Double.compare(that.score, this.score) == 0 && Objects.equals(this.suggestion, that.suggestion);
        }

        public int hashCode() {
            return Objects.hash(this.score, this.suggestion);
        }

        public String toString() {
            return "Suggestion{score=" + this.score + ", suggestion=" + this.suggestion + '}';
        }
    }

    public static class MisspelledTerm<V> {
        private final V term;
        private final List<Suggestion<V>> suggestions;

        public MisspelledTerm(V term, List<Suggestion<V>> suggestions) {
            this.term = term;
            this.suggestions = suggestions;
        }

        public V getTerm() {
            return this.term;
        }

        public List<Suggestion<V>> getSuggestions() {
            return this.suggestions;
        }

        public boolean hasSuggestions() {
            return this.suggestions != null && !this.suggestions.isEmpty();
        }

        public int getSuggestionCount() {
            return this.suggestions != null ? this.suggestions.size() : 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MisspelledTerm that = (MisspelledTerm)o;
            return Objects.equals(this.term, that.term) && Objects.equals(this.suggestions, that.suggestions);
        }

        public int hashCode() {
            return Objects.hash(this.term, this.suggestions);
        }

        public String toString() {
            return "MisspelledTerm{term=" + this.term + ", suggestions=" + this.suggestions + '}';
        }
    }
}

