/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.TrackingInfo;
import io.lettuce.core.output.ComplexData;
import io.lettuce.core.output.ComplexDataParser;
import io.lettuce.core.protocol.CommandKeyword;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TrackingInfoParser
implements ComplexDataParser<TrackingInfo> {
    public static final TrackingInfoParser INSTANCE = new TrackingInfoParser();

    private TrackingInfoParser() {
    }

    @Override
    public TrackingInfo parse(ComplexData dynamicData) {
        Map<Object, Object> data = this.verifyStructure(dynamicData);
        Set<Object> flags = ((ComplexData)data.get(CommandKeyword.FLAGS.toString().toLowerCase())).getDynamicSet();
        Long clientId = (Long)data.get(CommandKeyword.REDIRECT.toString().toLowerCase());
        List<Object> prefixes = ((ComplexData)data.get(CommandKeyword.PREFIXES.toString().toLowerCase())).getDynamicList();
        HashSet<TrackingInfo.TrackingFlag> parsedFlags = new HashSet<TrackingInfo.TrackingFlag>();
        ArrayList<String> parsedPrefixes = new ArrayList<String>();
        for (Object flag : flags) {
            String toParse = (String)flag;
            parsedFlags.add(TrackingInfo.TrackingFlag.from(toParse));
        }
        for (Object prefix : prefixes) {
            parsedPrefixes.add((String)prefix);
        }
        return new TrackingInfo(parsedFlags, clientId, parsedPrefixes);
    }

    private Map<Object, Object> verifyStructure(ComplexData trackinginfoOutput) {
        if (trackinginfoOutput == null) {
            throw new IllegalArgumentException("Failed while parsing CLIENT TRACKINGINFO: trackinginfoOutput must not be null");
        }
        Map<Object, Object> data = trackinginfoOutput.getDynamicMap();
        if (data == null || data.isEmpty()) {
            throw new IllegalArgumentException("Failed while parsing CLIENT TRACKINGINFO: data must not be null or empty");
        }
        if (!(data.containsKey(CommandKeyword.FLAGS.toString().toLowerCase()) && data.containsKey(CommandKeyword.REDIRECT.toString().toLowerCase()) && data.containsKey(CommandKeyword.PREFIXES.toString().toLowerCase()))) {
            throw new IllegalArgumentException("Failed while parsing CLIENT TRACKINGINFO: trackinginfoOutput has missing flags");
        }
        return data;
    }
}

