/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.json.JsonType;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.OutputFactory;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;

public class JsonTypeListOutput<K, V>
extends CommandOutput<K, V, List<JsonType>> {
    private boolean initialized;

    public JsonTypeListOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyList());
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (!this.initialized) {
            this.multi(1);
        }
        ((List)this.output).add(JsonType.fromString(this.decodeString(bytes)));
    }

    @Override
    public void multi(int count) {
        if (!this.initialized) {
            this.output = OutputFactory.newList(count);
            this.initialized = true;
        }
    }
}

