/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.ConcurrentLruCache;
import io.lettuce.core.ReadFrom;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.internal.LettuceLists;
import io.lettuce.core.internal.LettuceStrings;
import io.lettuce.core.models.role.RedisNodeDescription;
import io.netty.util.NetUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;

class ReadFromImpl {
    private static final Predicate<RedisNodeDescription> IS_UPSTREAM = node -> node.getRole().isUpstream();
    private static final Predicate<RedisNodeDescription> IS_REPLICA = node -> node.getRole().isReplica();

    ReadFromImpl() {
    }

    static class UnorderedPredicateReadFromAdapter
    extends OrderedPredicateReadFromAdapter {
        @SafeVarargs
        UnorderedPredicateReadFromAdapter(Predicate<RedisNodeDescription> ... predicates) {
            super(predicates);
        }

        @Override
        protected boolean isOrderSensitive() {
            return false;
        }
    }

    static class OrderedPredicateReadFromAdapter
    extends ReadFrom {
        private final Predicate<RedisNodeDescription>[] predicates;

        @SafeVarargs
        OrderedPredicateReadFromAdapter(Predicate<RedisNodeDescription> ... predicates) {
            this.predicates = predicates;
        }

        @Override
        public List<RedisNodeDescription> select(ReadFrom.Nodes nodes) {
            ArrayList<RedisNodeDescription> result = new ArrayList<RedisNodeDescription>(nodes.getNodes().size());
            for (Predicate<RedisNodeDescription> predicate : this.predicates) {
                for (RedisNodeDescription node : nodes) {
                    if (!predicate.test(node)) continue;
                    result.add(node);
                }
            }
            return result;
        }

        @Override
        protected boolean isOrderSensitive() {
            return true;
        }
    }

    static class ReadFromRegex
    extends ReadFrom {
        private final ReadFrom delegate;
        private final boolean orderSensitive;

        public ReadFromRegex(Pattern pattern, boolean orderSensitive) {
            LettuceAssert.notNull((Object)pattern, "Pattern must not be null");
            this.orderSensitive = orderSensitive;
            this.delegate = new UnorderedPredicateReadFromAdapter(redisNodeDescription -> {
                String host = redisNodeDescription.getUri().getHost();
                if (LettuceStrings.isEmpty(host)) {
                    return false;
                }
                return pattern.matcher(host).matches();
            });
        }

        @Override
        public List<RedisNodeDescription> select(ReadFrom.Nodes nodes) {
            return this.delegate.select(nodes);
        }

        @Override
        protected boolean isOrderSensitive() {
            return this.orderSensitive;
        }
    }

    static final class ReadFromSubnet
    extends ReadFrom {
        private static final int CACHE_SIZE = 48;
        private final List<SubnetRule> rules = new ArrayList<SubnetRule>();
        private final ConcurrentLruCache<String, Integer> ipv4AddressCache = new ConcurrentLruCache<String, Integer>(48, Ipv4SubnetRule::toInt);
        private final ConcurrentLruCache<String, BigInteger> ipv6AddressCache = new ConcurrentLruCache<String, BigInteger>(48, Ipv6SubnetRule::toBigInteger);

        ReadFromSubnet(String ... cidrNotations) {
            LettuceAssert.notEmpty((Object[])cidrNotations, "CIDR notations must not be empty");
            for (String cidrNotation : cidrNotations) {
                this.rules.add(this.createSubnetRule(cidrNotation));
            }
        }

        @Override
        public List<RedisNodeDescription> select(ReadFrom.Nodes nodes) {
            ArrayList<RedisNodeDescription> result = new ArrayList<RedisNodeDescription>(nodes.getNodes().size());
            for (RedisNodeDescription node : nodes) {
                if (!this.test(node)) continue;
                result.add(node);
            }
            return result;
        }

        private boolean test(RedisNodeDescription node) {
            for (SubnetRule rule : this.rules) {
                if (!rule.isInSubnet(node.getUri().getHost())) continue;
                return true;
            }
            return false;
        }

        SubnetRule createSubnetRule(String cidrNotation) {
            String[] parts = cidrNotation.split("/");
            LettuceAssert.isTrue(parts.length == 2, "CIDR notation must have exact one '/'");
            String ipAddress = parts[0];
            int cidrPrefix = Integer.parseInt(parts[1]);
            if (NetUtil.isValidIpV4Address((String)ipAddress)) {
                return new Ipv4SubnetRule(ipAddress, cidrPrefix, this.ipv4AddressCache);
            }
            if (NetUtil.isValidIpV6Address((String)ipAddress)) {
                return new Ipv6SubnetRule(ipAddress, cidrPrefix, this.ipv6AddressCache);
            }
            throw new IllegalArgumentException("Invalid CIDR notation " + cidrNotation);
        }

        static class Ipv6SubnetRule
        implements SubnetRule {
            private static final int IPV6_BYTE_COUNT = 16;
            private final BigInteger networkAddress;
            private final BigInteger subnetMask;
            private final ConcurrentLruCache<String, BigInteger> ipv6AddressCache;

            public Ipv6SubnetRule(String ipAddress, int cidrPrefix, ConcurrentLruCache<String, BigInteger> ipv6AddressCache) {
                LettuceAssert.isTrue(NetUtil.isValidIpV6Address((String)ipAddress), () -> String.format("Invalid IPv6 IP address %s", ipAddress));
                LettuceAssert.isTrue(0 <= cidrPrefix && cidrPrefix <= 128, () -> String.format("Invalid CIDR prefix %d", cidrPrefix));
                this.subnetMask = Ipv6SubnetRule.toSubnetMask(cidrPrefix);
                this.networkAddress = Ipv6SubnetRule.toNetworkAddress(ipAddress, this.subnetMask);
                this.ipv6AddressCache = ipv6AddressCache;
            }

            @Override
            public boolean isInSubnet(String ipAddress) {
                if (LettuceStrings.isEmpty(ipAddress) || !NetUtil.isValidIpV6Address((String)ipAddress)) {
                    return false;
                }
                BigInteger address = this.ipv6AddressCache.get(ipAddress);
                return address.and(this.subnetMask).equals(this.networkAddress);
            }

            private static BigInteger toSubnetMask(int cidrPrefix) {
                return BigInteger.valueOf(-1L).shiftLeft(128 - cidrPrefix);
            }

            private static BigInteger toNetworkAddress(String ipAddress, BigInteger subnetMask) {
                return Ipv6SubnetRule.toBigInteger(ipAddress).and(subnetMask);
            }

            static BigInteger toBigInteger(String ipAddress) {
                byte[] octets = NetUtil.createByteArrayFromIpAddressString((String)ipAddress);
                LettuceAssert.isTrue(octets != null && octets.length == 16, () -> String.format("Invalid IP address %s", ipAddress));
                return new BigInteger(octets);
            }
        }

        static class Ipv4SubnetRule
        implements SubnetRule {
            private static final int IPV4_BYTE_COUNT = 4;
            private final int networkAddress;
            private final int subnetMask;
            private final ConcurrentLruCache<String, Integer> ipv4AddressCache;

            Ipv4SubnetRule(String ipAddress, int cidrPrefix, ConcurrentLruCache<String, Integer> ipv4AddressCache) {
                LettuceAssert.isTrue(NetUtil.isValidIpV4Address((String)ipAddress), () -> String.format("Invalid IPv4 IP address %s", ipAddress));
                LettuceAssert.isTrue(0 <= cidrPrefix && cidrPrefix <= 32, () -> String.format("Invalid CIDR prefix %d", cidrPrefix));
                this.subnetMask = this.toSubnetMask(cidrPrefix);
                this.networkAddress = this.toNetworkAddress(ipAddress, this.subnetMask);
                this.ipv4AddressCache = ipv4AddressCache;
            }

            @Override
            public boolean isInSubnet(String ipAddress) {
                if (LettuceStrings.isEmpty(ipAddress) || !NetUtil.isValidIpV4Address((String)ipAddress)) {
                    return false;
                }
                Integer address = this.ipv4AddressCache.get(ipAddress);
                return (address & this.subnetMask) == this.networkAddress;
            }

            private int toSubnetMask(int cidrPrefix) {
                return (int)(-1L << 32 - cidrPrefix);
            }

            private int toNetworkAddress(String ipAddress, int subnetMask) {
                return Ipv4SubnetRule.toInt(ipAddress) & subnetMask;
            }

            static int toInt(String ipAddress) {
                byte[] octets = NetUtil.createByteArrayFromIpAddressString((String)ipAddress);
                LettuceAssert.isTrue(octets != null && octets.length == 4, () -> String.format("Invalid IP address %s", ipAddress));
                return (octets[0] & 0xFF) << 24 | (octets[1] & 0xFF) << 16 | (octets[2] & 0xFF) << 8 | octets[3] & 0xFF;
            }
        }

        static interface SubnetRule {
            public boolean isInSubnet(String var1);
        }
    }

    static final class ReadFromAnyReplica
    extends UnorderedPredicateReadFromAdapter {
        public ReadFromAnyReplica() {
            super(IS_REPLICA);
        }
    }

    static final class ReadFromAnyNode
    extends UnorderedPredicateReadFromAdapter {
        public ReadFromAnyNode() {
            super(x -> true);
        }
    }

    static final class ReadFromLowestCommandLatency
    extends ReadFrom {
        ReadFromLowestCommandLatency() {
        }

        @Override
        public List<RedisNodeDescription> select(ReadFrom.Nodes nodes) {
            return nodes.getNodes();
        }

        @Override
        protected boolean isOrderSensitive() {
            return true;
        }
    }

    static final class ReadFromReplicaPreferred
    extends OrderedPredicateReadFromAdapter {
        ReadFromReplicaPreferred() {
            super(IS_REPLICA, IS_UPSTREAM);
        }
    }

    static final class ReadFromReplica
    extends OrderedPredicateReadFromAdapter {
        ReadFromReplica() {
            super(IS_REPLICA);
        }
    }

    static final class ReadFromUpstreamPreferred
    extends OrderedPredicateReadFromAdapter {
        ReadFromUpstreamPreferred() {
            super(IS_UPSTREAM, IS_REPLICA);
        }
    }

    static final class ReadFromUpstream
    extends ReadFrom {
        ReadFromUpstream() {
        }

        @Override
        public List<RedisNodeDescription> select(ReadFrom.Nodes nodes) {
            for (RedisNodeDescription node : nodes) {
                if (!node.getRole().isUpstream()) continue;
                return LettuceLists.newList(node);
            }
            return Collections.emptyList();
        }
    }
}

