/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.AclCategory;
import io.lettuce.core.AclSetuserArgs;
import io.lettuce.core.BitFieldArgs;
import io.lettuce.core.Consumer;
import io.lettuce.core.CopyArgs;
import io.lettuce.core.ExpireArgs;
import io.lettuce.core.FlushMode;
import io.lettuce.core.GeoAddArgs;
import io.lettuce.core.GeoArgs;
import io.lettuce.core.GeoCoordinates;
import io.lettuce.core.GeoRadiusStoreArgs;
import io.lettuce.core.GeoSearch;
import io.lettuce.core.GeoValue;
import io.lettuce.core.GeoWithin;
import io.lettuce.core.GetExArgs;
import io.lettuce.core.KeyScanCursor;
import io.lettuce.core.KeyValue;
import io.lettuce.core.KillArgs;
import io.lettuce.core.LMPopArgs;
import io.lettuce.core.LMoveArgs;
import io.lettuce.core.LPosArgs;
import io.lettuce.core.Limit;
import io.lettuce.core.MapScanCursor;
import io.lettuce.core.MigrateArgs;
import io.lettuce.core.Range;
import io.lettuce.core.RestoreArgs;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.ScoredValue;
import io.lettuce.core.ScoredValueScanCursor;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.SetArgs;
import io.lettuce.core.ShutdownArgs;
import io.lettuce.core.SortArgs;
import io.lettuce.core.StrAlgoArgs;
import io.lettuce.core.StreamMessage;
import io.lettuce.core.StreamScanCursor;
import io.lettuce.core.StringMatchResult;
import io.lettuce.core.TrackingArgs;
import io.lettuce.core.UnblockType;
import io.lettuce.core.Value;
import io.lettuce.core.ValueScanCursor;
import io.lettuce.core.XAddArgs;
import io.lettuce.core.XAutoClaimArgs;
import io.lettuce.core.XClaimArgs;
import io.lettuce.core.XGroupCreateArgs;
import io.lettuce.core.XPendingArgs;
import io.lettuce.core.XReadArgs;
import io.lettuce.core.XTrimArgs;
import io.lettuce.core.ZAddArgs;
import io.lettuce.core.ZAggregateArgs;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.internal.LettuceStrings;
import io.lettuce.core.models.stream.ClaimedMessages;
import io.lettuce.core.models.stream.PendingMessage;
import io.lettuce.core.models.stream.PendingMessages;
import io.lettuce.core.output.ArrayOutput;
import io.lettuce.core.output.BooleanListOutput;
import io.lettuce.core.output.BooleanOutput;
import io.lettuce.core.output.ByteArrayOutput;
import io.lettuce.core.output.ClaimedMessagesOutput;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.DateOutput;
import io.lettuce.core.output.DoubleListOutput;
import io.lettuce.core.output.DoubleOutput;
import io.lettuce.core.output.EnumSetOutput;
import io.lettuce.core.output.GenericMapOutput;
import io.lettuce.core.output.GeoCoordinatesListOutput;
import io.lettuce.core.output.GeoCoordinatesValueListOutput;
import io.lettuce.core.output.GeoWithinListOutput;
import io.lettuce.core.output.IntegerListOutput;
import io.lettuce.core.output.IntegerOutput;
import io.lettuce.core.output.KeyListOutput;
import io.lettuce.core.output.KeyOutput;
import io.lettuce.core.output.KeyScanOutput;
import io.lettuce.core.output.KeyScanStreamingOutput;
import io.lettuce.core.output.KeyStreamingChannel;
import io.lettuce.core.output.KeyStreamingOutput;
import io.lettuce.core.output.KeyValueListOutput;
import io.lettuce.core.output.KeyValueOutput;
import io.lettuce.core.output.KeyValueScanStreamingOutput;
import io.lettuce.core.output.KeyValueScoredValueOutput;
import io.lettuce.core.output.KeyValueStreamingChannel;
import io.lettuce.core.output.KeyValueStreamingOutput;
import io.lettuce.core.output.KeyValueValueListOutput;
import io.lettuce.core.output.ListOfGenericMapsOutput;
import io.lettuce.core.output.MapOutput;
import io.lettuce.core.output.MapScanOutput;
import io.lettuce.core.output.NestedMultiOutput;
import io.lettuce.core.output.PendingMessageListOutput;
import io.lettuce.core.output.PendingMessagesOutput;
import io.lettuce.core.output.ScoredValueListOutput;
import io.lettuce.core.output.ScoredValueOutput;
import io.lettuce.core.output.ScoredValueScanOutput;
import io.lettuce.core.output.ScoredValueScanStreamingOutput;
import io.lettuce.core.output.ScoredValueStreamingChannel;
import io.lettuce.core.output.ScoredValueStreamingOutput;
import io.lettuce.core.output.StatusOutput;
import io.lettuce.core.output.StreamMessageListOutput;
import io.lettuce.core.output.StreamReadOutput;
import io.lettuce.core.output.StringListOutput;
import io.lettuce.core.output.StringMatchResultOutput;
import io.lettuce.core.output.StringValueListOutput;
import io.lettuce.core.output.ValueListOutput;
import io.lettuce.core.output.ValueOutput;
import io.lettuce.core.output.ValueScanOutput;
import io.lettuce.core.output.ValueScanStreamingOutput;
import io.lettuce.core.output.ValueSetOutput;
import io.lettuce.core.output.ValueStreamingChannel;
import io.lettuce.core.output.ValueStreamingOutput;
import io.lettuce.core.output.ValueValueListOutput;
import io.lettuce.core.protocol.BaseRedisCommandBuilder;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.protocol.CommandType;
import io.lettuce.core.protocol.RedisCommand;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

class RedisCommandBuilder<K, V>
extends BaseRedisCommandBuilder<K, V> {
    private static final String MUST_NOT_CONTAIN_NULL_ELEMENTS = "must not contain null elements";
    private static final String MUST_NOT_BE_EMPTY = "must not be empty";
    private static final String MUST_NOT_BE_NULL = "must not be null";
    private static final byte[] MINUS_BYTES = new byte[]{45};
    private static final byte[] PLUS_BYTES = new byte[]{43};

    RedisCommandBuilder(RedisCodec<K, V> codec) {
        super(codec);
    }

    Command<K, V, Set<AclCategory>> aclCat() {
        CommandArgs args = new CommandArgs(this.codec);
        args.add(CommandKeyword.CAT);
        return this.createCommand(CommandType.ACL, new EnumSetOutput(this.codec, AclCategory.class, String::toUpperCase, it -> null), args);
    }

    Command<K, V, Set<CommandType>> aclCat(AclCategory category) {
        LettuceAssert.notNull((Object)category, "Category must not be null");
        CommandArgs args = new CommandArgs(this.codec);
        args.add(CommandKeyword.CAT).add(category.name().toLowerCase());
        return this.createCommand(CommandType.ACL, new EnumSetOutput(this.codec, CommandType.class, String::toUpperCase, it -> null), args);
    }

    Command<K, V, Long> aclDeluser(String ... usernames) {
        RedisCommandBuilder.notEmpty(usernames);
        CommandArgs args = new CommandArgs(this.codec);
        args.add(CommandKeyword.DELUSER);
        for (String username : usernames) {
            args.add(username);
        }
        return this.createCommand(CommandType.ACL, new IntegerOutput(this.codec), args);
    }

    Command<K, V, String> aclDryRun(String username, String command, String ... commandArgs) {
        LettuceAssert.notNull((Object)username, "username must not be null");
        LettuceAssert.notNull((Object)command, "command must not be null");
        CommandArgs args = new CommandArgs(this.codec);
        args.add(CommandKeyword.DRYRUN).add(username).add(command);
        for (String commandArg : commandArgs) {
            args.add(commandArg);
        }
        return this.createCommand(CommandType.ACL, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> aclDryRun(String username, RedisCommand<K, V, ?> command) {
        LettuceAssert.notNull((Object)username, "username must not be null");
        LettuceAssert.notNull(command, "command must not be null");
        CommandArgs args = new CommandArgs(this.codec);
        args.add(CommandKeyword.DRYRUN).add(username).add(command.getType()).addAll(command.getArgs());
        return this.createCommand(CommandType.ACL, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> aclGenpass() {
        CommandArgs args = new CommandArgs(this.codec);
        args.add(CommandKeyword.GENPASS);
        return this.createCommand(CommandType.ACL, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> aclGenpass(int bits) {
        CommandArgs args = new CommandArgs(this.codec);
        args.add(CommandKeyword.GENPASS).add(bits);
        return this.createCommand(CommandType.ACL, new StatusOutput(this.codec), args);
    }

    Command<K, V, List<Object>> aclGetuser(String username) {
        LettuceAssert.notNull((Object)username, "Username must not be null");
        CommandArgs args = new CommandArgs(this.codec);
        args.add(CommandKeyword.GETUSER).add(username);
        return this.createCommand(CommandType.ACL, new NestedMultiOutput(this.codec), args);
    }

    Command<K, V, List<String>> aclList() {
        CommandArgs args = new CommandArgs(this.codec);
        args.add(CommandKeyword.LIST);
        return this.createCommand(CommandType.ACL, new StringListOutput(this.codec), args);
    }

    Command<K, V, String> aclLoad() {
        CommandArgs args = new CommandArgs(this.codec);
        args.add(CommandKeyword.LOAD);
        return this.createCommand(CommandType.ACL, new StatusOutput(this.codec), args);
    }

    Command<K, V, List<Map<String, Object>>> aclLog() {
        CommandArgs args = new CommandArgs(this.codec);
        args.add(CommandKeyword.LOG);
        return new Command(CommandType.ACL, new ListOfGenericMapsOutput<String, String>(StringCodec.ASCII), args);
    }

    Command<K, V, List<Map<String, Object>>> aclLog(int count) {
        CommandArgs args = new CommandArgs(this.codec);
        args.add(CommandKeyword.LOG).add(count);
        return new Command(CommandType.ACL, new ListOfGenericMapsOutput<String, String>(StringCodec.ASCII), args);
    }

    Command<K, V, String> aclLogReset() {
        CommandArgs args = new CommandArgs(this.codec);
        args.add(CommandKeyword.LOG).add(CommandKeyword.RESET);
        return this.createCommand(CommandType.ACL, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> aclSave() {
        CommandArgs args = new CommandArgs(this.codec);
        args.add(CommandKeyword.SAVE);
        return this.createCommand(CommandType.ACL, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> aclSetuser(String username, AclSetuserArgs setuserArgs) {
        RedisCommandBuilder.notNullKey(username);
        CommandArgs args = new CommandArgs(this.codec);
        args.add(CommandKeyword.SETUSER).add(username);
        setuserArgs.build(args);
        return this.createCommand(CommandType.ACL, new StatusOutput(this.codec), args);
    }

    Command<K, V, List<String>> aclUsers() {
        CommandArgs args = new CommandArgs(this.codec);
        args.add(CommandKeyword.USERS);
        return this.createCommand(CommandType.ACL, new StringListOutput(this.codec), args);
    }

    Command<K, V, String> aclWhoami() {
        CommandArgs args = new CommandArgs(this.codec);
        args.add(CommandKeyword.WHOAMI);
        return this.createCommand(CommandType.ACL, new StatusOutput(this.codec), args);
    }

    Command<K, V, Long> append(K key, V value) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.APPEND, new IntegerOutput(this.codec), key, value);
    }

    Command<K, V, String> asking() {
        CommandArgs args = new CommandArgs(this.codec);
        return this.createCommand(CommandType.ASKING, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> auth(CharSequence password) {
        LettuceAssert.notNull((Object)password, "Password must not be null");
        char[] chars = new char[password.length()];
        for (int i = 0; i < password.length(); ++i) {
            chars[i] = password.charAt(i);
        }
        return this.auth(chars);
    }

    Command<K, V, String> auth(char[] password) {
        LettuceAssert.notNull((Object)password, "Password must not be null");
        CommandArgs args = new CommandArgs(this.codec).add(password);
        return this.createCommand(CommandType.AUTH, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> auth(String username, CharSequence password) {
        LettuceAssert.notNull((Object)username, "Username must not be null");
        LettuceAssert.isTrue(!username.isEmpty(), "Username must not be empty");
        LettuceAssert.notNull((Object)password, "Password must not be null");
        char[] chars = new char[password.length()];
        for (int i = 0; i < password.length(); ++i) {
            chars[i] = password.charAt(i);
        }
        return this.auth(username, chars);
    }

    Command<K, V, String> auth(String username, char[] password) {
        LettuceAssert.notNull((Object)username, "Username must not be null");
        LettuceAssert.isTrue(!username.isEmpty(), "Username must not be empty");
        LettuceAssert.notNull((Object)password, "Password must not be null");
        CommandArgs args = new CommandArgs(this.codec).add(username).add(password);
        return this.createCommand(CommandType.AUTH, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> bgrewriteaof() {
        return this.createCommand(CommandType.BGREWRITEAOF, new StatusOutput(this.codec));
    }

    Command<K, V, String> bgsave() {
        return this.createCommand(CommandType.BGSAVE, new StatusOutput(this.codec));
    }

    Command<K, V, Long> bitcount(K key) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        return this.createCommand(CommandType.BITCOUNT, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> bitcount(K key, long start, long end) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(start).add(end);
        return this.createCommand(CommandType.BITCOUNT, new IntegerOutput(this.codec), args);
    }

    Command<K, V, List<Long>> bitfield(K key, BitFieldArgs bitFieldArgs) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull((Object)bitFieldArgs, "BitFieldArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key);
        bitFieldArgs.build(args);
        return this.createCommand(CommandType.BITFIELD, new ArrayOutput(this.codec), args);
    }

    Command<K, V, List<Value<Long>>> bitfieldValue(K key, BitFieldArgs bitFieldArgs) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull((Object)bitFieldArgs, "BitFieldArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key);
        bitFieldArgs.build(args);
        return this.createCommand(CommandType.BITFIELD, new ValueValueListOutput(this.codec), args);
    }

    Command<K, V, Long> bitopAnd(K destination, K ... keys) {
        LettuceAssert.notNull(destination, "Destination must not be null");
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec);
        args.add(CommandKeyword.AND).addKey(destination).addKeys(keys);
        return this.createCommand(CommandType.BITOP, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> bitopNot(K destination, K source) {
        LettuceAssert.notNull(destination, "Destination must not be null");
        LettuceAssert.notNull(source, "Source must not be null");
        CommandArgs args = new CommandArgs(this.codec);
        args.add(CommandKeyword.NOT).addKey(destination).addKey(source);
        return this.createCommand(CommandType.BITOP, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> bitopOr(K destination, K ... keys) {
        LettuceAssert.notNull(destination, "Destination must not be null");
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec);
        args.add(CommandKeyword.OR).addKey(destination).addKeys(keys);
        return this.createCommand(CommandType.BITOP, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> bitopXor(K destination, K ... keys) {
        LettuceAssert.notNull(destination, "Destination must not be null");
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec);
        args.add(CommandKeyword.XOR).addKey(destination).addKeys(keys);
        return this.createCommand(CommandType.BITOP, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> bitpos(K key, boolean state) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(state ? 1L : 0L);
        return this.createCommand(CommandType.BITPOS, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> bitpos(K key, boolean state, long start) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(state ? 1L : 0L).add(start);
        return this.createCommand(CommandType.BITPOS, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> bitpos(K key, boolean state, long start, long end) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(state ? 1L : 0L).add(start).add(end);
        return this.createCommand(CommandType.BITPOS, new IntegerOutput(this.codec), args);
    }

    Command<K, V, V> blmove(K source, K destination, LMoveArgs lMoveArgs, long timeout) {
        LettuceAssert.notNull(source, "Source must not be null");
        LettuceAssert.notNull(destination, "Destination must not be null");
        LettuceAssert.notNull((Object)lMoveArgs, "LMoveArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(source).addKey(destination);
        lMoveArgs.build(args);
        args.add(timeout);
        return this.createCommand(CommandType.BLMOVE, new ValueOutput(this.codec), args);
    }

    Command<K, V, V> blmove(K source, K destination, LMoveArgs lMoveArgs, double timeout) {
        LettuceAssert.notNull(source, "Source must not be null");
        LettuceAssert.notNull(destination, "Destination must not be null");
        LettuceAssert.notNull((Object)lMoveArgs, "LMoveArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(source).addKey(destination);
        lMoveArgs.build(args);
        args.add(timeout);
        return this.createCommand(CommandType.BLMOVE, new ValueOutput(this.codec), args);
    }

    Command<K, V, KeyValue<K, List<V>>> blmpop(long timeout, LMPopArgs lmPopArgs, K ... keys) {
        LettuceAssert.notNull(keys, "Keys must not be null");
        LettuceAssert.notNull((Object)lmPopArgs, "LMPopArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec).add(timeout).add(keys.length).addKeys(keys);
        lmPopArgs.build(args);
        return this.createCommand(CommandType.BLMPOP, new KeyValueValueListOutput(this.codec), args);
    }

    Command<K, V, KeyValue<K, List<V>>> blmpop(double timeout, LMPopArgs lmPopArgs, K ... keys) {
        LettuceAssert.notNull(keys, "Keys must not be null");
        LettuceAssert.notNull((Object)lmPopArgs, "LMPopArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec).add(timeout).add(keys.length).addKeys(keys);
        lmPopArgs.build(args);
        return this.createCommand(CommandType.BLMPOP, new KeyValueValueListOutput(this.codec), args);
    }

    Command<K, V, KeyValue<K, V>> blpop(long timeout, K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys).add(timeout);
        return this.createCommand(CommandType.BLPOP, new KeyValueOutput(this.codec), args);
    }

    Command<K, V, KeyValue<K, V>> blpop(double timeout, K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys).add(timeout);
        return this.createCommand(CommandType.BLPOP, new KeyValueOutput(this.codec), args);
    }

    Command<K, V, KeyValue<K, V>> brpop(long timeout, K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys).add(timeout);
        return this.createCommand(CommandType.BRPOP, new KeyValueOutput(this.codec), args);
    }

    Command<K, V, KeyValue<K, V>> brpop(double timeout, K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys).add(timeout);
        return this.createCommand(CommandType.BRPOP, new KeyValueOutput(this.codec), args);
    }

    Command<K, V, V> brpoplpush(long timeout, K source, K destination) {
        LettuceAssert.notNull(source, "Source must not be null");
        LettuceAssert.notNull(destination, "Destination must not be null");
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(source).addKey(destination).add(timeout);
        return this.createCommand(CommandType.BRPOPLPUSH, new ValueOutput(this.codec), args);
    }

    Command<K, V, V> brpoplpush(double timeout, K source, K destination) {
        LettuceAssert.notNull(source, "Source must not be null");
        LettuceAssert.notNull(destination, "Destination must not be null");
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(source).addKey(destination).add(timeout);
        return this.createCommand(CommandType.BRPOPLPUSH, new ValueOutput(this.codec), args);
    }

    Command<K, V, String> clientCaching(boolean enabled) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.CACHING).add(enabled ? CommandKeyword.YES : CommandKeyword.NO);
        return this.createCommand(CommandType.CLIENT, new StatusOutput(this.codec), args);
    }

    Command<K, V, K> clientGetname() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.GETNAME);
        return this.createCommand(CommandType.CLIENT, new KeyOutput(this.codec), args);
    }

    Command<K, V, Long> clientGetredir() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.GETREDIR);
        return this.createCommand(CommandType.CLIENT, new IntegerOutput(this.codec), args);
    }

    Command<K, V, String> clientKill(String addr) {
        LettuceAssert.notNull((Object)addr, "Addr must not be null");
        LettuceAssert.notEmpty((CharSequence)addr, "Addr must not be empty");
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.KILL).add(addr);
        return this.createCommand(CommandType.CLIENT, new StatusOutput(this.codec), args);
    }

    Command<K, V, Long> clientKill(KillArgs killArgs) {
        LettuceAssert.notNull((Object)killArgs, "KillArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.KILL);
        killArgs.build(args);
        return this.createCommand(CommandType.CLIENT, new IntegerOutput(this.codec), args);
    }

    Command<K, V, String> clientList() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.LIST);
        return this.createCommand(CommandType.CLIENT, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> clientNoEvict(boolean on) {
        CommandArgs args = new CommandArgs(this.codec).add("NO-EVICT").add(on ? CommandKeyword.ON : CommandKeyword.OFF);
        return this.createCommand(CommandType.CLIENT, new StatusOutput(this.codec), args);
    }

    Command<K, V, Long> clientId() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.ID);
        return this.createCommand(CommandType.CLIENT, new IntegerOutput(this.codec), args);
    }

    Command<K, V, String> clientPause(long timeout) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.PAUSE).add(timeout);
        return this.createCommand(CommandType.CLIENT, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> clientSetname(K name) {
        LettuceAssert.notNull(name, "Name must not be null");
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.SETNAME).addKey(name);
        return this.createCommand(CommandType.CLIENT, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> clientTracking(TrackingArgs trackingArgs) {
        LettuceAssert.notNull((Object)trackingArgs, "TrackingArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.TRACKING);
        trackingArgs.build(args);
        return this.createCommand(CommandType.CLIENT, new StatusOutput(this.codec), args);
    }

    Command<K, V, Long> clientUnblock(long id, UnblockType type) {
        LettuceAssert.notNull((Object)type, "UnblockType must not be null");
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.UNBLOCK).add(id).add(type);
        return this.createCommand(CommandType.CLIENT, new IntegerOutput(this.codec), args);
    }

    Command<K, V, String> clusterAddslots(int[] slots) {
        RedisCommandBuilder.notEmptySlots(slots);
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.ADDSLOTS);
        for (int slot : slots) {
            args.add(slot);
        }
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> clusterAddSlotsRange(Range<Integer> ... ranges) {
        RedisCommandBuilder.notEmptyRanges(ranges);
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.ADDSLOTSRANGE);
        for (Range<Integer> range : ranges) {
            args.add(range.getLower().getValue().intValue());
            args.add(range.getUpper().getValue().intValue());
        }
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> clusterBumpepoch() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.BUMPEPOCH);
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    Command<K, V, Long> clusterCountFailureReports(String nodeId) {
        RedisCommandBuilder.assertNodeId(nodeId);
        CommandArgs args = new CommandArgs(this.codec).add("COUNT-FAILURE-REPORTS").add(nodeId);
        return this.createCommand(CommandType.CLUSTER, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> clusterCountKeysInSlot(int slot) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.COUNTKEYSINSLOT).add(slot);
        return this.createCommand(CommandType.CLUSTER, new IntegerOutput(this.codec), args);
    }

    Command<K, V, String> clusterDelslots(int[] slots) {
        RedisCommandBuilder.notEmptySlots(slots);
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.DELSLOTS);
        for (int slot : slots) {
            args.add(slot);
        }
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> clusterDelSlotsRange(Range<Integer> ... ranges) {
        RedisCommandBuilder.notEmptyRanges(ranges);
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.DELSLOTSRANGE);
        for (Range<Integer> range : ranges) {
            args.add(range.getLower().getValue().intValue());
            args.add(range.getUpper().getValue().intValue());
        }
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> clusterFailover(boolean force) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.FAILOVER);
        if (force) {
            args.add(CommandKeyword.FORCE);
        }
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> clusterFlushslots() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.FLUSHSLOTS);
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> clusterForget(String nodeId) {
        RedisCommandBuilder.assertNodeId(nodeId);
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.FORGET).add(nodeId);
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    Command<K, V, List<K>> clusterGetKeysInSlot(int slot, int count) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.GETKEYSINSLOT).add(slot).add(count);
        return this.createCommand(CommandType.CLUSTER, new KeyListOutput(this.codec), args);
    }

    Command<K, V, String> clusterInfo() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandType.INFO);
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    Command<K, V, Long> clusterKeyslot(K key) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.KEYSLOT).addKey(key);
        return this.createCommand(CommandType.CLUSTER, new IntegerOutput(this.codec), args);
    }

    Command<K, V, String> clusterMeet(String ip, int port) {
        LettuceAssert.notNull((Object)ip, "IP must not be null");
        LettuceAssert.notEmpty((CharSequence)ip, "IP must not be empty");
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.MEET).add(ip).add(port);
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> clusterMyId() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandType.MYID);
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> clusterNodes() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.NODES);
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> clusterReplicate(String nodeId) {
        RedisCommandBuilder.assertNodeId(nodeId);
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.REPLICATE).add(nodeId);
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    Command<K, V, List<String>> clusterReplicas(String nodeId) {
        RedisCommandBuilder.assertNodeId(nodeId);
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.REPLICAS).add(nodeId);
        return this.createCommand(CommandType.CLUSTER, new StringListOutput(this.codec), args);
    }

    Command<K, V, String> clusterReset(boolean hard) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.RESET);
        if (hard) {
            args.add(CommandKeyword.HARD);
        } else {
            args.add(CommandKeyword.SOFT);
        }
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> clusterSaveconfig() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.SAVECONFIG);
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> clusterSetConfigEpoch(long configEpoch) {
        CommandArgs args = new CommandArgs(this.codec).add("SET-CONFIG-EPOCH").add(configEpoch);
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> clusterSetSlotImporting(int slot, String nodeId) {
        RedisCommandBuilder.assertNodeId(nodeId);
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.SETSLOT).add(slot).add(CommandKeyword.IMPORTING).add(nodeId);
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> clusterSetSlotMigrating(int slot, String nodeId) {
        RedisCommandBuilder.assertNodeId(nodeId);
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.SETSLOT).add(slot).add(CommandKeyword.MIGRATING).add(nodeId);
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> clusterSetSlotNode(int slot, String nodeId) {
        RedisCommandBuilder.assertNodeId(nodeId);
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.SETSLOT).add(slot).add(CommandKeyword.NODE).add(nodeId);
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> clusterSetSlotStable(int slot) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.SETSLOT).add(slot).add(CommandKeyword.STABLE);
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    Command<K, V, List<Object>> clusterShards() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.SHARDS);
        return this.createCommand(CommandType.CLUSTER, new ArrayOutput(this.codec), args);
    }

    Command<K, V, List<String>> clusterSlaves(String nodeId) {
        RedisCommandBuilder.assertNodeId(nodeId);
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.SLAVES).add(nodeId);
        return this.createCommand(CommandType.CLUSTER, new StringListOutput(this.codec), args);
    }

    Command<K, V, List<Object>> clusterSlots() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.SLOTS);
        return this.createCommand(CommandType.CLUSTER, new ArrayOutput(this.codec), args);
    }

    Command<K, V, List<Object>> command() {
        CommandArgs<String, String> args = new CommandArgs<String, String>(StringCodec.UTF8);
        return (Command)Command.class.cast(new Command(CommandType.COMMAND, new ArrayOutput<String, String>(StringCodec.UTF8), args));
    }

    Command<K, V, Long> commandCount() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.COUNT);
        return this.createCommand(CommandType.COMMAND, new IntegerOutput(this.codec), args);
    }

    Command<K, V, List<Object>> commandInfo(String ... commands) {
        LettuceAssert.notNull((Object)commands, "Commands must not be null");
        LettuceAssert.notEmpty((Object[])commands, "Commands must not be empty");
        LettuceAssert.noNullElements((Object[])commands, "Commands must not contain null elements");
        CommandArgs<String, String> args = new CommandArgs<String, String>(StringCodec.UTF8);
        args.add(CommandType.INFO);
        for (String command : commands) {
            args.add(command);
        }
        return (Command)Command.class.cast(new Command(CommandType.COMMAND, new ArrayOutput<String, String>(StringCodec.UTF8), args));
    }

    Command<K, V, Map<String, String>> configGet(String parameter) {
        LettuceAssert.notNull((Object)parameter, "Parameter must not be null");
        LettuceAssert.notEmpty((CharSequence)parameter, "Parameter must not be empty");
        CommandArgs<String, String> args = new CommandArgs<String, String>(StringCodec.UTF8).add(CommandType.GET).add(parameter);
        return (Command)Command.class.cast(new Command(CommandType.CONFIG, new MapOutput<String, String>(StringCodec.UTF8), args));
    }

    Command<K, V, Map<String, String>> configGet(String ... parameters) {
        LettuceAssert.notNull((Object)parameters, "Parameters must not be null");
        LettuceAssert.notEmpty((Object[])parameters, "Parameters must not be empty");
        CommandArgs<String, String> args = new CommandArgs<String, String>(StringCodec.UTF8).add(CommandType.GET);
        for (String parameter : parameters) {
            args.add(parameter);
        }
        return (Command)Command.class.cast(new Command(CommandType.CONFIG, new MapOutput<String, String>(StringCodec.UTF8), args));
    }

    Command<K, V, String> configResetstat() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.RESETSTAT);
        return this.createCommand(CommandType.CONFIG, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> configRewrite() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.REWRITE);
        return this.createCommand(CommandType.CONFIG, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> configSet(String parameter, String value) {
        LettuceAssert.notNull((Object)parameter, "Parameter must not be null");
        LettuceAssert.notEmpty((CharSequence)parameter, "Parameter must not be empty");
        LettuceAssert.notNull((Object)value, "Value must not be null");
        CommandArgs args = new CommandArgs(this.codec).add(CommandType.SET).add(parameter).add(value);
        return this.createCommand(CommandType.CONFIG, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> configSet(Map<String, String> configValues) {
        LettuceAssert.notNull(configValues, "ConfigValues must not be null");
        LettuceAssert.isTrue(!configValues.isEmpty(), "ConfigValues must not be empty");
        CommandArgs args = new CommandArgs(this.codec).add(CommandType.SET);
        configValues.forEach((parameter, value) -> {
            args.add((String)parameter);
            args.add((String)value);
        });
        return this.createCommand(CommandType.CONFIG, new StatusOutput(this.codec), args);
    }

    Command<K, V, Long> dbsize() {
        return this.createCommand(CommandType.DBSIZE, new IntegerOutput(this.codec));
    }

    Command<K, V, String> debugCrashAndRecover(Long delay) {
        CommandArgs args = new CommandArgs(this.codec).add("CRASH-AND-RECOVER");
        if (delay != null) {
            args.add(delay);
        }
        return this.createCommand(CommandType.DEBUG, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> debugHtstats(int db) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.HTSTATS).add(db);
        return this.createCommand(CommandType.DEBUG, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> debugObject(K key) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).add(CommandType.OBJECT).addKey(key);
        return this.createCommand(CommandType.DEBUG, new StatusOutput(this.codec), args);
    }

    Command<K, V, Void> debugOom() {
        return this.createCommand(CommandType.DEBUG, null, new CommandArgs(this.codec).add("OOM"));
    }

    Command<K, V, String> debugReload() {
        return this.createCommand(CommandType.DEBUG, new StatusOutput(this.codec), new CommandArgs(this.codec).add(CommandKeyword.RELOAD));
    }

    Command<K, V, String> debugRestart(Long delay) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.RESTART);
        if (delay != null) {
            args.add(delay);
        }
        return this.createCommand(CommandType.DEBUG, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> debugSdslen(K key) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.DEBUG, new StatusOutput(this.codec), new CommandArgs(this.codec).add("SDSLEN").addKey(key));
    }

    Command<K, V, Void> debugSegfault() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.SEGFAULT);
        return this.createCommand(CommandType.DEBUG, null, args);
    }

    Command<K, V, Long> decr(K key) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.DECR, new IntegerOutput(this.codec), key);
    }

    Command<K, V, Long> decrby(K key, long amount) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(amount);
        return this.createCommand(CommandType.DECRBY, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> del(K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.DEL, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> del(Iterable<K> keys) {
        LettuceAssert.notNull(keys, "Keys must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.DEL, new IntegerOutput(this.codec), args);
    }

    Command<K, V, String> discard() {
        return this.createCommand(CommandType.DISCARD, new StatusOutput(this.codec));
    }

    Command<K, V, byte[]> dump(K key) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        return this.createCommand(CommandType.DUMP, new ByteArrayOutput(this.codec), args);
    }

    Command<K, V, V> echo(V msg) {
        LettuceAssert.notNull(msg, "message must not be null");
        CommandArgs args = new CommandArgs(this.codec).addValue(msg);
        return this.createCommand(CommandType.ECHO, new ValueOutput(this.codec), args);
    }

    <T> Command<K, V, T> eval(byte[] script, ScriptOutputType type, K[] keys, V ... values) {
        return this.eval(script, type, false, keys, values);
    }

    <T> Command<K, V, T> eval(byte[] script, ScriptOutputType type, boolean readonly, K[] keys, V ... values) {
        LettuceAssert.notNull((Object)script, "Script must not be null");
        LettuceAssert.notNull((Object)type, "ScriptOutputType must not be null");
        LettuceAssert.notNull(keys, "Keys must not be null");
        LettuceAssert.notNull(values, "Values must not be null");
        CommandArgs args = new CommandArgs(this.codec);
        args.add(script).add(keys.length).addKeys(keys).addValues(values);
        CommandOutput output = this.newScriptOutput(this.codec, type);
        return this.createCommand(readonly ? CommandType.EVAL_RO : CommandType.EVAL, output, args);
    }

    <T> Command<K, V, T> evalsha(String digest, ScriptOutputType type, K[] keys, V ... values) {
        return this.evalsha(digest, type, false, keys, values);
    }

    <T> Command<K, V, T> evalsha(String digest, ScriptOutputType type, boolean readonly, K[] keys, V ... values) {
        LettuceAssert.notNull((Object)digest, "Digest must not be null");
        LettuceAssert.notEmpty((CharSequence)digest, "Digest must not be empty");
        LettuceAssert.notNull((Object)type, "ScriptOutputType must not be null");
        LettuceAssert.notNull(keys, "Keys must not be null");
        LettuceAssert.notNull(values, "Values must not be null");
        CommandArgs args = new CommandArgs(this.codec);
        args.add(digest).add(keys.length).addKeys(keys).addValues(values);
        CommandOutput output = this.newScriptOutput(this.codec, type);
        return this.createCommand(readonly ? CommandType.EVALSHA_RO : CommandType.EVALSHA, output, args);
    }

    Command<K, V, Boolean> exists(K key) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.EXISTS, new BooleanOutput(this.codec), key);
    }

    Command<K, V, Long> exists(K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        return this.createCommand(CommandType.EXISTS, new IntegerOutput(this.codec), new CommandArgs(this.codec).addKeys(keys));
    }

    Command<K, V, Long> exists(Iterable<K> keys) {
        LettuceAssert.notNull(keys, "Keys must not be null");
        return this.createCommand(CommandType.EXISTS, new IntegerOutput(this.codec), new CommandArgs(this.codec).addKeys(keys));
    }

    Command<K, V, Boolean> expire(K key, long seconds, ExpireArgs expireArgs) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(seconds);
        if (expireArgs != null) {
            expireArgs.build(args);
        }
        return this.createCommand(CommandType.EXPIRE, new BooleanOutput(this.codec), args);
    }

    Command<K, V, Boolean> expireat(K key, long timestamp, ExpireArgs expireArgs) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(timestamp);
        if (expireArgs != null) {
            expireArgs.build(args);
        }
        return this.createCommand(CommandType.EXPIREAT, new BooleanOutput(this.codec), args);
    }

    Command<K, V, Long> expiretime(K key) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        return this.createCommand(CommandType.EXPIRETIME, new IntegerOutput(this.codec), args);
    }

    Command<K, V, String> flushall() {
        return this.createCommand(CommandType.FLUSHALL, new StatusOutput(this.codec));
    }

    Command<K, V, String> flushall(FlushMode flushMode) {
        LettuceAssert.notNull((Object)flushMode, "FlushMode must not be null");
        return this.createCommand(CommandType.FLUSHALL, new StatusOutput(this.codec), new CommandArgs(this.codec).add(flushMode));
    }

    Command<K, V, String> flushdb() {
        return this.createCommand(CommandType.FLUSHDB, new StatusOutput(this.codec));
    }

    Command<K, V, String> flushdb(FlushMode flushMode) {
        LettuceAssert.notNull((Object)flushMode, "FlushMode must not be null");
        return this.createCommand(CommandType.FLUSHDB, new StatusOutput(this.codec), new CommandArgs(this.codec).add(flushMode));
    }

    Command<K, V, Long> geoadd(K key, double longitude, double latitude, V member, GeoAddArgs geoArgs) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        if (geoArgs != null) {
            geoArgs.build(args);
        }
        args.add(longitude).add(latitude).addValue(member);
        return this.createCommand(CommandType.GEOADD, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> geoadd(K key, Object[] lngLatMember, GeoAddArgs geoArgs) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull((Object)lngLatMember, "LngLatMember must not be null");
        LettuceAssert.notEmpty(lngLatMember, "LngLatMember must not be empty");
        LettuceAssert.noNullElements(lngLatMember, "LngLatMember must not contain null elements");
        LettuceAssert.isTrue(lngLatMember.length % 3 == 0, "LngLatMember.length must be a multiple of 3 and contain a sequence of longitude1, latitude1, member1, longitude2, latitude2, member2, ... longitudeN, latitudeN, memberN");
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        if (geoArgs != null) {
            geoArgs.build(args);
        }
        for (int i = 0; i < lngLatMember.length; i += 3) {
            args.add((Double)lngLatMember[i]);
            args.add((Double)lngLatMember[i + 1]);
            args.addValue(lngLatMember[i + 2]);
        }
        return this.createCommand(CommandType.GEOADD, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> geoadd(K key, GeoValue<V>[] values, GeoAddArgs geoArgs) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(values, "Values must not be null");
        LettuceAssert.notEmpty((Object[])values, "Values must not be empty");
        LettuceAssert.noNullElements((Object[])values, "Values must not contain null elements");
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        if (geoArgs != null) {
            geoArgs.build(args);
        }
        for (GeoValue<V> value : values) {
            args.add(value.getCoordinates().getX().doubleValue());
            args.add(value.getCoordinates().getY().doubleValue());
            args.addValue(value.getValue());
        }
        return this.createCommand(CommandType.GEOADD, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Double> geodist(K key, V from, V to, GeoArgs.Unit unit) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(from, "From must not be null");
        LettuceAssert.notNull(from, "To must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addValue(from).addValue(to);
        if (unit != null) {
            args.add(unit.name());
        }
        return this.createCommand(CommandType.GEODIST, new DoubleOutput(this.codec), args);
    }

    Command<K, V, List<Value<String>>> geohash(K key, V ... members) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(members, "Members must not be null");
        LettuceAssert.notEmpty((Object[])members, "Members must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addValues(members);
        return this.createCommand(CommandType.GEOHASH, new StringValueListOutput(this.codec), args);
    }

    Command<K, V, List<GeoCoordinates>> geopos(K key, V[] members) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(members, "Members must not be null");
        LettuceAssert.notEmpty((Object[])members, "Members must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addValues(members);
        return this.createCommand(CommandType.GEOPOS, new GeoCoordinatesListOutput(this.codec), args);
    }

    Command<K, V, List<Value<GeoCoordinates>>> geoposValues(K key, V[] members) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(members, "Members must not be null");
        LettuceAssert.notEmpty((Object[])members, "Members must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addValues(members);
        return this.createCommand(CommandType.GEOPOS, new GeoCoordinatesValueListOutput(this.codec), args);
    }

    Command<K, V, Set<V>> georadius(CommandType commandType, K key, double longitude, double latitude, double distance, String unit) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull((Object)unit, "Unit must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(longitude).add(latitude).add(distance).add(unit);
        return this.createCommand(commandType, new ValueSetOutput(this.codec), args);
    }

    Command<K, V, List<GeoWithin<V>>> georadius(CommandType commandType, K key, double longitude, double latitude, double distance, String unit, GeoArgs geoArgs) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull((Object)unit, "Unit must not be null");
        LettuceAssert.notEmpty((CharSequence)unit, "Unit must not be empty");
        LettuceAssert.notNull((Object)geoArgs, "GeoArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(longitude).add(latitude).add(distance).add(unit);
        geoArgs.build(args);
        return this.createCommand(commandType, new GeoWithinListOutput(this.codec, geoArgs.isWithDistance(), geoArgs.isWithHash(), geoArgs.isWithCoordinates()), args);
    }

    Command<K, V, Long> georadius(K key, double longitude, double latitude, double distance, String unit, GeoRadiusStoreArgs<K> geoRadiusStoreArgs) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull((Object)unit, "Unit must not be null");
        LettuceAssert.notEmpty((CharSequence)unit, "Unit must not be empty");
        LettuceAssert.notNull(geoRadiusStoreArgs, "GeoRadiusStoreArgs must not be null");
        LettuceAssert.isTrue(geoRadiusStoreArgs.getStoreKey() != null || geoRadiusStoreArgs.getStoreDistKey() != null, "At least STORE key or STOREDIST key is required");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(longitude).add(latitude).add(distance).add(unit);
        geoRadiusStoreArgs.build(args);
        return this.createCommand(CommandType.GEORADIUS, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Set<V>> georadiusbymember(CommandType commandType, K key, V member, double distance, String unit) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull((Object)unit, "Unit must not be null");
        LettuceAssert.notEmpty((CharSequence)unit, "Unit must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addValue(member).add(distance).add(unit);
        return this.createCommand(commandType, new ValueSetOutput(this.codec), args);
    }

    Command<K, V, List<GeoWithin<V>>> georadiusbymember(CommandType commandType, K key, V member, double distance, String unit, GeoArgs geoArgs) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull((Object)geoArgs, "GeoArgs must not be null");
        LettuceAssert.notNull((Object)unit, "Unit must not be null");
        LettuceAssert.notEmpty((CharSequence)unit, "Unit must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addValue(member).add(distance).add(unit);
        geoArgs.build(args);
        return this.createCommand(commandType, new GeoWithinListOutput(this.codec, geoArgs.isWithDistance(), geoArgs.isWithHash(), geoArgs.isWithCoordinates()), args);
    }

    Command<K, V, Long> georadiusbymember(K key, V member, double distance, String unit, GeoRadiusStoreArgs<K> geoRadiusStoreArgs) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(geoRadiusStoreArgs, "GeoRadiusStoreArgs must not be null");
        LettuceAssert.notNull((Object)unit, "Unit must not be null");
        LettuceAssert.notEmpty((CharSequence)unit, "Unit must not be empty");
        LettuceAssert.isTrue(geoRadiusStoreArgs.getStoreKey() != null || geoRadiusStoreArgs.getStoreDistKey() != null, "At least STORE key or STOREDIST key is required");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addValue(member).add(distance).add(unit);
        geoRadiusStoreArgs.build(args);
        return this.createCommand(CommandType.GEORADIUSBYMEMBER, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Set<V>> geosearch(K key, GeoSearch.GeoRef<K> reference, GeoSearch.GeoPredicate predicate) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(reference, "GeoRef must not be null");
        LettuceAssert.notNull((Object)predicate, "GeoPredicate must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        reference.build(args);
        predicate.build(args);
        return this.createCommand(CommandType.GEOSEARCH, new ValueSetOutput(this.codec), args);
    }

    Command<K, V, List<GeoWithin<V>>> geosearch(K key, GeoSearch.GeoRef<K> reference, GeoSearch.GeoPredicate predicate, GeoArgs geoArgs) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(reference, "GeoRef must not be null");
        LettuceAssert.notNull((Object)predicate, "GeoPredicate must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        reference.build(args);
        predicate.build(args);
        geoArgs.build(args);
        return this.createCommand(CommandType.GEOSEARCH, new GeoWithinListOutput(this.codec, geoArgs.isWithDistance(), geoArgs.isWithHash(), geoArgs.isWithCoordinates()), args);
    }

    Command<K, V, Long> geosearchstore(K destination, K key, GeoSearch.GeoRef<K> reference, GeoSearch.GeoPredicate predicate, GeoArgs geoArgs, boolean storeDist) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(destination, "Destination must not be null");
        LettuceAssert.notNull(key, "Key must not be null");
        LettuceAssert.notNull(reference, "GeoRef must not be null");
        LettuceAssert.notNull((Object)predicate, "GeoPredicate must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(destination).addKey(key);
        reference.build(args);
        predicate.build(args);
        geoArgs.build(args);
        if (storeDist) {
            args.add("STOREDIST");
        }
        return this.createCommand(CommandType.GEOSEARCHSTORE, new IntegerOutput(this.codec), args);
    }

    Command<K, V, V> get(K key) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.GET, new ValueOutput(this.codec), key);
    }

    Command<K, V, Long> getbit(K key, long offset) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(offset);
        return this.createCommand(CommandType.GETBIT, new IntegerOutput(this.codec), args);
    }

    Command<K, V, V> getdel(K key) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.GETDEL, new ValueOutput(this.codec), key);
    }

    Command<K, V, V> getex(K key, GetExArgs getExArgs) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull((Object)getExArgs, "GetExArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        getExArgs.build(args);
        return this.createCommand(CommandType.GETEX, new ValueOutput(this.codec), args);
    }

    Command<K, V, V> getrange(K key, long start, long end) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(start).add(end);
        return this.createCommand(CommandType.GETRANGE, new ValueOutput(this.codec), args);
    }

    Command<K, V, V> getset(K key, V value) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.GETSET, new ValueOutput(this.codec), key, value);
    }

    Command<K, V, Long> hdel(K key, K ... fields) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(fields, "Fields must not be null");
        LettuceAssert.notEmpty((Object[])fields, "Fields must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKeys(fields);
        return this.createCommand(CommandType.HDEL, new IntegerOutput(this.codec), args);
    }

    Command<String, String, Map<String, Object>> hello(int protocolVersion, String user, char[] password, String name) {
        CommandArgs<String, String> args = new CommandArgs<String, String>(StringCodec.ASCII).add(protocolVersion);
        if (user != null && password != null) {
            args.add(CommandType.AUTH).add(user).add(password);
        }
        if (name != null) {
            args.add(CommandKeyword.SETNAME).add(name);
        }
        return new Command<String, String, Map<String, Object>>(CommandType.HELLO, new GenericMapOutput<String, String>(StringCodec.ASCII), args);
    }

    Command<K, V, Boolean> hexists(K key, K field) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(field, "Field must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKey(field);
        return this.createCommand(CommandType.HEXISTS, new BooleanOutput(this.codec), args);
    }

    Command<K, V, V> hget(K key, K field) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(field, "Field must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKey(field);
        return this.createCommand(CommandType.HGET, new ValueOutput(this.codec), args);
    }

    Command<K, V, Map<K, V>> hgetall(K key) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.HGETALL, new MapOutput(this.codec), key);
    }

    Command<K, V, List<KeyValue<K, V>>> hgetallKeyValue(K key) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.HGETALL, new KeyValueListOutput(this.codec), key);
    }

    Command<K, V, Long> hgetall(KeyValueStreamingChannel<K, V> channel, K key) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNull(channel);
        return this.createCommand(CommandType.HGETALL, new KeyValueStreamingOutput<K, V>(this.codec, channel), key);
    }

    Command<K, V, Long> hincrby(K key, K field, long amount) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(field, "Field must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKey(field).add(amount);
        return this.createCommand(CommandType.HINCRBY, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Double> hincrbyfloat(K key, K field, double amount) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(field, "Field must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKey(field).add(amount);
        return this.createCommand(CommandType.HINCRBYFLOAT, new DoubleOutput(this.codec), args);
    }

    Command<K, V, List<K>> hkeys(K key) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.HKEYS, new KeyListOutput(this.codec), key);
    }

    Command<K, V, Long> hkeys(KeyStreamingChannel<K> channel, K key) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNull(channel);
        return this.createCommand(CommandType.HKEYS, new KeyStreamingOutput(this.codec, channel), key);
    }

    Command<K, V, Long> hlen(K key) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.HLEN, new IntegerOutput(this.codec), key);
    }

    Command<K, V, List<V>> hmget(K key, K ... fields) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(fields, "Fields must not be null");
        LettuceAssert.notEmpty((Object[])fields, "Fields must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKeys(fields);
        return this.createCommand(CommandType.HMGET, new ValueListOutput(this.codec), args);
    }

    Command<K, V, Long> hmget(ValueStreamingChannel<V> channel, K key, K ... fields) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(fields, "Fields must not be null");
        LettuceAssert.notEmpty((Object[])fields, "Fields must not be empty");
        RedisCommandBuilder.notNull(channel);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKeys(fields);
        return this.createCommand(CommandType.HMGET, new ValueStreamingOutput(this.codec, channel), args);
    }

    Command<K, V, Long> hmget(KeyValueStreamingChannel<K, V> channel, K key, K ... fields) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(fields, "Fields must not be null");
        LettuceAssert.notEmpty((Object[])fields, "Fields must not be empty");
        RedisCommandBuilder.notNull(channel);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKeys(fields);
        return this.createCommand(CommandType.HMGET, new KeyValueStreamingOutput<K, V>(this.codec, channel, Arrays.asList(fields)), args);
    }

    Command<K, V, List<KeyValue<K, V>>> hmgetKeyValue(K key, K ... fields) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(fields, "Fields must not be null");
        LettuceAssert.notEmpty((Object[])fields, "Fields must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKeys(fields);
        return this.createCommand(CommandType.HMGET, new KeyValueListOutput(this.codec, Arrays.asList(fields)), args);
    }

    Command<K, V, String> hmset(K key, Map<K, V> map) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(map, "Map must not be null");
        LettuceAssert.isTrue(!map.isEmpty(), "Map must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(map);
        return this.createCommand(CommandType.HMSET, new StatusOutput(this.codec), args);
    }

    Command<K, V, K> hrandfield(K key) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        return this.createCommand(CommandType.HRANDFIELD, new KeyOutput(this.codec), args);
    }

    Command<K, V, List<K>> hrandfield(K key, long count) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(count);
        return this.createCommand(CommandType.HRANDFIELD, new KeyListOutput(this.codec), args);
    }

    Command<K, V, KeyValue<K, V>> hrandfieldWithvalues(K key) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(1L).add(CommandKeyword.WITHVALUES);
        return this.createCommand(CommandType.HRANDFIELD, new KeyValueOutput(this.codec), args);
    }

    Command<K, V, List<KeyValue<K, V>>> hrandfieldWithvalues(K key, long count) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(count).add(CommandKeyword.WITHVALUES);
        return this.createCommand(CommandType.HRANDFIELD, new KeyValueListOutput(this.codec), args);
    }

    Command<K, V, MapScanCursor<K, V>> hscan(K key) {
        RedisCommandBuilder.notNullKey(key);
        return this.hscan(key, ScanCursor.INITIAL, null);
    }

    Command<K, V, MapScanCursor<K, V>> hscan(K key, ScanCursor scanCursor) {
        RedisCommandBuilder.notNullKey(key);
        return this.hscan(key, scanCursor, null);
    }

    Command<K, V, MapScanCursor<K, V>> hscan(K key, ScanArgs scanArgs) {
        RedisCommandBuilder.notNullKey(key);
        return this.hscan(key, ScanCursor.INITIAL, scanArgs);
    }

    Command<K, V, MapScanCursor<K, V>> hscan(K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key);
        this.scanArgs(scanCursor, scanArgs, args);
        MapScanOutput output = new MapScanOutput(this.codec);
        return this.createCommand(CommandType.HSCAN, output, args);
    }

    Command<K, V, StreamScanCursor> hscanStreaming(KeyValueStreamingChannel<K, V> channel, K key) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNull(channel);
        return this.hscanStreaming(channel, key, ScanCursor.INITIAL, null);
    }

    Command<K, V, StreamScanCursor> hscanStreaming(KeyValueStreamingChannel<K, V> channel, K key, ScanCursor scanCursor) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNull(channel);
        return this.hscanStreaming(channel, key, scanCursor, null);
    }

    Command<K, V, StreamScanCursor> hscanStreaming(KeyValueStreamingChannel<K, V> channel, K key, ScanArgs scanArgs) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNull(channel);
        return this.hscanStreaming(channel, key, ScanCursor.INITIAL, scanArgs);
    }

    Command<K, V, StreamScanCursor> hscanStreaming(KeyValueStreamingChannel<K, V> channel, K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNull(channel);
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key);
        this.scanArgs(scanCursor, scanArgs, args);
        KeyValueScanStreamingOutput<K, V> output = new KeyValueScanStreamingOutput<K, V>(this.codec, channel);
        return this.createCommand(CommandType.HSCAN, output, args);
    }

    Command<K, V, Boolean> hset(K key, K field, V value) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(field, "Field must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKey(field).addValue(value);
        return this.createCommand(CommandType.HSET, new BooleanOutput(this.codec), args);
    }

    Command<K, V, Long> hset(K key, Map<K, V> map) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(map, "Map must not be null");
        LettuceAssert.isTrue(!map.isEmpty(), "Map must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(map);
        return this.createCommand(CommandType.HSET, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Boolean> hsetnx(K key, K field, V value) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(field, "Field must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKey(field).addValue(value);
        return this.createCommand(CommandType.HSETNX, new BooleanOutput(this.codec), args);
    }

    Command<K, V, Long> hstrlen(K key, K field) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(field, "Field must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKey(field);
        return this.createCommand(CommandType.HSTRLEN, new IntegerOutput(this.codec), args);
    }

    Command<K, V, List<V>> hvals(K key) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.HVALS, new ValueListOutput(this.codec), key);
    }

    Command<K, V, Long> hvals(ValueStreamingChannel<V> channel, K key) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNull(channel);
        return this.createCommand(CommandType.HVALS, new ValueStreamingOutput(this.codec, channel), key);
    }

    Command<K, V, Long> incr(K key) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.INCR, new IntegerOutput(this.codec), key);
    }

    Command<K, V, Long> incrby(K key, long amount) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(amount);
        return this.createCommand(CommandType.INCRBY, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Double> incrbyfloat(K key, double amount) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(amount);
        return this.createCommand(CommandType.INCRBYFLOAT, new DoubleOutput(this.codec), args);
    }

    Command<K, V, String> info() {
        return this.createCommand(CommandType.INFO, new StatusOutput(this.codec));
    }

    Command<K, V, String> info(String section) {
        LettuceAssert.notNull((Object)section, "Section must not be null");
        CommandArgs args = new CommandArgs(this.codec).add(section);
        return this.createCommand(CommandType.INFO, new StatusOutput(this.codec), args);
    }

    Command<K, V, List<K>> keys(K pattern) {
        LettuceAssert.notNull(pattern, "Pattern must not be null");
        return this.createCommand(CommandType.KEYS, new KeyListOutput(this.codec), pattern);
    }

    Command<K, V, Long> keys(KeyStreamingChannel<K> channel, K pattern) {
        LettuceAssert.notNull(pattern, "Pattern must not be null");
        RedisCommandBuilder.notNull(channel);
        return this.createCommand(CommandType.KEYS, new KeyStreamingOutput(this.codec, channel), pattern);
    }

    Command<K, V, Date> lastsave() {
        return this.createCommand(CommandType.LASTSAVE, new DateOutput(this.codec));
    }

    Command<K, V, V> lindex(K key, long index) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(index);
        return this.createCommand(CommandType.LINDEX, new ValueOutput(this.codec), args);
    }

    Command<K, V, Long> linsert(K key, boolean before, V pivot, V value) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(before ? CommandKeyword.BEFORE : CommandKeyword.AFTER).addValue(pivot).addValue(value);
        return this.createCommand(CommandType.LINSERT, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> llen(K key) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.LLEN, new IntegerOutput(this.codec), key);
    }

    Command<K, V, V> lmove(K source, K destination, LMoveArgs lMoveArgs) {
        LettuceAssert.notNull(source, "Source must not be null");
        LettuceAssert.notNull(destination, "Destination must not be null");
        LettuceAssert.notNull((Object)lMoveArgs, "LMoveArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(source).addKey(destination);
        lMoveArgs.build(args);
        return this.createCommand(CommandType.LMOVE, new ValueOutput(this.codec), args);
    }

    Command<K, V, KeyValue<K, List<V>>> lmpop(LMPopArgs lmPopArgs, K ... keys) {
        LettuceAssert.notNull(keys, "Keys must not be null");
        LettuceAssert.notNull((Object)lmPopArgs, "LMPopArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec).add(keys.length).addKeys(keys);
        lmPopArgs.build(args);
        return this.createCommand(CommandType.LMPOP, new KeyValueValueListOutput(this.codec), args);
    }

    Command<K, V, V> lpop(K key) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.LPOP, new ValueOutput(this.codec), key);
    }

    Command<K, V, List<V>> lpop(K key, long count) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.LPOP, new ValueListOutput(this.codec), new CommandArgs(this.codec).addKey(key).add(count));
    }

    Command<K, V, Long> lpos(K key, V value, LPosArgs lposArgs) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addValue(value);
        if (lposArgs != null) {
            lposArgs.build(args);
        }
        return this.createCommand(CommandType.LPOS, new IntegerOutput(this.codec), args);
    }

    Command<K, V, List<Long>> lpos(K key, V value, long count, LPosArgs lposArgs) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addValue(value).add(CommandKeyword.COUNT).add(count);
        if (lposArgs != null) {
            lposArgs.build(args);
        }
        return this.createCommand(CommandType.LPOS, new IntegerListOutput(this.codec), args);
    }

    Command<K, V, Long> lpush(K key, V ... values) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notEmptyValues(values);
        return this.createCommand(CommandType.LPUSH, new IntegerOutput(this.codec), key, values);
    }

    Command<K, V, Long> lpushx(K key, V ... values) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notEmptyValues(values);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addValues(values);
        return this.createCommand(CommandType.LPUSHX, new IntegerOutput(this.codec), args);
    }

    Command<K, V, List<V>> lrange(K key, long start, long stop) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(start).add(stop);
        return this.createCommand(CommandType.LRANGE, new ValueListOutput(this.codec), args);
    }

    Command<K, V, Long> lrange(ValueStreamingChannel<V> channel, K key, long start, long stop) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNull(channel);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(start).add(stop);
        return this.createCommand(CommandType.LRANGE, new ValueStreamingOutput(this.codec, channel), args);
    }

    Command<K, V, Long> lrem(K key, long count, V value) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(count).addValue(value);
        return this.createCommand(CommandType.LREM, new IntegerOutput(this.codec), args);
    }

    Command<K, V, String> lset(K key, long index, V value) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(index).addValue(value);
        return this.createCommand(CommandType.LSET, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> ltrim(K key, long start, long stop) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(start).add(stop);
        return this.createCommand(CommandType.LTRIM, new StatusOutput(this.codec), args);
    }

    Command<K, V, Long> memoryUsage(K key) {
        return this.createCommand(CommandType.MEMORY, new IntegerOutput(this.codec), new CommandArgs(this.codec).add(CommandKeyword.USAGE).add(key.toString()));
    }

    Command<K, V, List<V>> mget(K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.MGET, new ValueListOutput(this.codec), args);
    }

    Command<K, V, List<V>> mget(Iterable<K> keys) {
        LettuceAssert.notNull(keys, "Keys must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.MGET, new ValueListOutput(this.codec), args);
    }

    Command<K, V, Long> mget(ValueStreamingChannel<V> channel, K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        RedisCommandBuilder.notNull(channel);
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.MGET, new ValueStreamingOutput(this.codec, channel), args);
    }

    Command<K, V, Long> mget(KeyValueStreamingChannel<K, V> channel, K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        RedisCommandBuilder.notNull(channel);
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.MGET, new KeyValueStreamingOutput<K, V>(this.codec, channel, Arrays.asList(keys)), args);
    }

    Command<K, V, Long> mget(ValueStreamingChannel<V> channel, Iterable<K> keys) {
        LettuceAssert.notNull(keys, "Keys must not be null");
        RedisCommandBuilder.notNull(channel);
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.MGET, new ValueStreamingOutput(this.codec, channel), args);
    }

    Command<K, V, Long> mget(KeyValueStreamingChannel<K, V> channel, Iterable<K> keys) {
        LettuceAssert.notNull(keys, "Keys must not be null");
        RedisCommandBuilder.notNull(channel);
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.MGET, new KeyValueStreamingOutput<K, V>(this.codec, channel, keys), args);
    }

    Command<K, V, List<KeyValue<K, V>>> mgetKeyValue(K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.MGET, new KeyValueListOutput(this.codec, Arrays.asList(keys)), args);
    }

    Command<K, V, List<KeyValue<K, V>>> mgetKeyValue(Iterable<K> keys) {
        LettuceAssert.notNull(keys, "Keys must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.MGET, new KeyValueListOutput(this.codec, keys), args);
    }

    Command<K, V, String> migrate(String host, int port, K key, int db, long timeout) {
        LettuceAssert.notNull((Object)host, "Host must not be null");
        LettuceAssert.notEmpty((CharSequence)host, "Host must not be empty");
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec);
        args.add(host).add(port).addKey(key).add(db).add(timeout);
        return this.createCommand(CommandType.MIGRATE, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> migrate(String host, int port, int db, long timeout, MigrateArgs<K> migrateArgs) {
        LettuceAssert.notNull((Object)host, "Host must not be null");
        LettuceAssert.notEmpty((CharSequence)host, "Host must not be empty");
        LettuceAssert.notNull(migrateArgs, "migrateArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec);
        args.add(host).add(port);
        if (migrateArgs.keys.size() == 1) {
            args.addKey(migrateArgs.keys.get(0));
        } else {
            args.add("");
        }
        args.add(db).add(timeout);
        migrateArgs.build(args);
        return this.createCommand(CommandType.MIGRATE, new StatusOutput(this.codec), args);
    }

    Command<K, V, Boolean> move(K key, int db) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(db);
        return this.createCommand(CommandType.MOVE, new BooleanOutput(this.codec), args);
    }

    Command<K, V, String> mset(Map<K, V> map) {
        LettuceAssert.notNull(map, "Map must not be null");
        LettuceAssert.isTrue(!map.isEmpty(), "Map must not be empty");
        CommandArgs args = new CommandArgs<K, V>(this.codec).add(map);
        return this.createCommand(CommandType.MSET, new StatusOutput(this.codec), args);
    }

    Command<K, V, Boolean> msetnx(Map<K, V> map) {
        LettuceAssert.notNull(map, "Map must not be null");
        LettuceAssert.isTrue(!map.isEmpty(), "Map must not be empty");
        CommandArgs args = new CommandArgs<K, V>(this.codec).add(map);
        return this.createCommand(CommandType.MSETNX, new BooleanOutput(this.codec), args);
    }

    Command<K, V, String> multi() {
        return this.createCommand(CommandType.MULTI, new StatusOutput(this.codec));
    }

    Command<K, V, String> objectEncoding(K key) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.ENCODING).addKey(key);
        return this.createCommand(CommandType.OBJECT, new StatusOutput(this.codec), args);
    }

    Command<K, V, Long> objectFreq(K key) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.FREQ).addKey(key);
        return this.createCommand(CommandType.OBJECT, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> objectIdletime(K key) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.IDLETIME).addKey(key);
        return this.createCommand(CommandType.OBJECT, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> objectRefcount(K key) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.REFCOUNT).addKey(key);
        return this.createCommand(CommandType.OBJECT, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Boolean> persist(K key) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.PERSIST, new BooleanOutput(this.codec), key);
    }

    Command<K, V, Boolean> pexpire(K key, long milliseconds, ExpireArgs expireArgs) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(milliseconds);
        if (expireArgs != null) {
            expireArgs.build(args);
        }
        return this.createCommand(CommandType.PEXPIRE, new BooleanOutput(this.codec), args);
    }

    Command<K, V, Boolean> pexpireat(K key, long timestamp, ExpireArgs expireArgs) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(timestamp);
        if (expireArgs != null) {
            expireArgs.build(args);
        }
        return this.createCommand(CommandType.PEXPIREAT, new BooleanOutput(this.codec), args);
    }

    Command<K, V, Long> pexpiretime(K key) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        return this.createCommand(CommandType.PEXPIRETIME, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> pfadd(K key, V value, V ... moreValues) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(value, "Value must not be null");
        LettuceAssert.notNull(moreValues, "MoreValues must not be null");
        LettuceAssert.noNullElements((Object[])moreValues, "MoreValues must not contain null elements");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addValue(value).addValues(moreValues);
        return this.createCommand(CommandType.PFADD, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> pfadd(K key, V ... values) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notEmptyValues(values);
        LettuceAssert.noNullElements((Object[])values, "Values must not contain null elements");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addValues(values);
        return this.createCommand(CommandType.PFADD, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> pfcount(K key, K ... moreKeys) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(moreKeys, "MoreKeys must not be null");
        LettuceAssert.noNullElements((Object[])moreKeys, "MoreKeys must not contain null elements");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKeys(moreKeys);
        return this.createCommand(CommandType.PFCOUNT, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> pfcount(K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.PFCOUNT, new IntegerOutput(this.codec), args);
    }

    Command<K, V, String> pfmerge(K destkey, K sourcekey, K ... moreSourceKeys) {
        LettuceAssert.notNull(destkey, "Destkey must not be null");
        LettuceAssert.notNull(sourcekey, "Sourcekey must not be null");
        LettuceAssert.notNull(moreSourceKeys, "MoreSourceKeys must not be null");
        LettuceAssert.noNullElements((Object[])moreSourceKeys, "MoreSourceKeys must not contain null elements");
        CommandArgs args = new CommandArgs(this.codec).addKeys(destkey).addKey(sourcekey).addKeys(moreSourceKeys);
        return this.createCommand(CommandType.PFMERGE, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> pfmerge(K destkey, K ... sourcekeys) {
        LettuceAssert.notNull(destkey, "Destkey must not be null");
        LettuceAssert.notNull(sourcekeys, "Sourcekeys must not be null");
        LettuceAssert.notEmpty((Object[])sourcekeys, "Sourcekeys must not be empty");
        LettuceAssert.noNullElements((Object[])sourcekeys, "Sourcekeys must not contain null elements");
        CommandArgs args = new CommandArgs(this.codec).addKeys(destkey).addKeys(sourcekeys);
        return this.createCommand(CommandType.PFMERGE, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> ping() {
        return this.createCommand(CommandType.PING, new StatusOutput(this.codec));
    }

    Command<K, V, String> psetex(K key, long milliseconds, V value) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(milliseconds).addValue(value);
        return this.createCommand(CommandType.PSETEX, new StatusOutput(this.codec), args);
    }

    Command<K, V, Long> pttl(K key) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        return this.createCommand(CommandType.PTTL, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> publish(K channel, V message) {
        LettuceAssert.notNull(channel, "Channel must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(channel).addValue(message);
        return this.createCommand(CommandType.PUBLISH, new IntegerOutput(this.codec), args);
    }

    Command<K, V, List<K>> pubsubChannels() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.CHANNELS);
        return this.createCommand(CommandType.PUBSUB, new KeyListOutput(this.codec), args);
    }

    Command<K, V, List<K>> pubsubChannels(K pattern) {
        LettuceAssert.notNull(pattern, "Pattern must not be null");
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.CHANNELS).addKey(pattern);
        return this.createCommand(CommandType.PUBSUB, new KeyListOutput(this.codec), args);
    }

    Command<K, V, Long> pubsubNumpat() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.NUMPAT);
        return this.createCommand(CommandType.PUBSUB, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Map<K, Long>> pubsubNumsub(K ... pattern) {
        LettuceAssert.notNull(pattern, "Pattern must not be null");
        LettuceAssert.notEmpty((Object[])pattern, "Pattern must not be empty");
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.NUMSUB).addKeys(pattern);
        return this.createCommand(CommandType.PUBSUB, new MapOutput(this.codec), args);
    }

    Command<K, V, String> quit() {
        return this.createCommand(CommandType.QUIT, new StatusOutput(this.codec));
    }

    Command<K, V, K> randomkey() {
        return this.createCommand(CommandType.RANDOMKEY, new KeyOutput(this.codec));
    }

    Command<K, V, String> readOnly() {
        return this.createCommand(CommandType.READONLY, new StatusOutput(this.codec));
    }

    Command<K, V, String> readWrite() {
        return this.createCommand(CommandType.READWRITE, new StatusOutput(this.codec));
    }

    Command<K, V, String> rename(K key, K newKey) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(newKey, "NewKey must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKey(newKey);
        return this.createCommand(CommandType.RENAME, new StatusOutput(this.codec), args);
    }

    Command<K, V, Boolean> renamenx(K key, K newKey) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(newKey, "NewKey must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKey(newKey);
        return this.createCommand(CommandType.RENAMENX, new BooleanOutput(this.codec), args);
    }

    Command<K, V, String> replicaof(String host, int port) {
        LettuceAssert.notNull((Object)host, "Host must not be null");
        LettuceAssert.notEmpty((CharSequence)host, "Host must not be empty");
        CommandArgs args = new CommandArgs(this.codec).add(host).add(port);
        return this.createCommand(CommandType.REPLICAOF, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> replicaofNoOne() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.NO).add(CommandKeyword.ONE);
        return this.createCommand(CommandType.REPLICAOF, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> restore(K key, byte[] value, RestoreArgs restoreArgs) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull((Object)value, "Value must not be null");
        LettuceAssert.notNull((Object)restoreArgs, "RestoreArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(restoreArgs.ttl).add(value);
        restoreArgs.build(args);
        return this.createCommand(CommandType.RESTORE, new StatusOutput(this.codec), args);
    }

    Command<K, V, List<Object>> role() {
        return this.createCommand(CommandType.ROLE, new ArrayOutput(this.codec));
    }

    Command<K, V, V> rpop(K key) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.RPOP, new ValueOutput(this.codec), key);
    }

    Command<K, V, List<V>> rpop(K key, long count) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.RPOP, new ValueListOutput(this.codec), new CommandArgs(this.codec).addKey(key).add(count));
    }

    Command<K, V, V> rpoplpush(K source, K destination) {
        LettuceAssert.notNull(source, "Source must not be null");
        LettuceAssert.notNull(destination, "Destination must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(source).addKey(destination);
        return this.createCommand(CommandType.RPOPLPUSH, new ValueOutput(this.codec), args);
    }

    Command<K, V, Long> rpush(K key, V ... values) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notEmptyValues(values);
        return this.createCommand(CommandType.RPUSH, new IntegerOutput(this.codec), key, values);
    }

    Command<K, V, Long> rpushx(K key, V ... values) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notEmptyValues(values);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addValues(values);
        return this.createCommand(CommandType.RPUSHX, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> sadd(K key, V ... members) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(members, "Members must not be null");
        LettuceAssert.notEmpty((Object[])members, "Members must not be empty");
        return this.createCommand(CommandType.SADD, new IntegerOutput(this.codec), key, members);
    }

    Command<K, V, String> save() {
        return this.createCommand(CommandType.SAVE, new StatusOutput(this.codec));
    }

    Command<K, V, KeyScanCursor<K>> scan() {
        return this.scan(ScanCursor.INITIAL, null);
    }

    Command<K, V, KeyScanCursor<K>> scan(ScanCursor scanCursor) {
        return this.scan(scanCursor, null);
    }

    Command<K, V, KeyScanCursor<K>> scan(ScanArgs scanArgs) {
        return this.scan(ScanCursor.INITIAL, scanArgs);
    }

    Command<K, V, KeyScanCursor<K>> scan(ScanCursor scanCursor, ScanArgs scanArgs) {
        CommandArgs args = new CommandArgs(this.codec);
        this.scanArgs(scanCursor, scanArgs, args);
        KeyScanOutput output = new KeyScanOutput(this.codec);
        return this.createCommand(CommandType.SCAN, output, args);
    }

    protected void scanArgs(ScanCursor scanCursor, ScanArgs scanArgs, CommandArgs<K, V> args) {
        LettuceAssert.notNull((Object)scanCursor, "ScanCursor must not be null");
        LettuceAssert.isTrue(!scanCursor.isFinished(), "ScanCursor must not be finished");
        args.add(scanCursor.getCursor());
        if (scanArgs != null) {
            scanArgs.build(args);
        }
    }

    Command<K, V, StreamScanCursor> scanStreaming(KeyStreamingChannel<K> channel) {
        RedisCommandBuilder.notNull(channel);
        LettuceAssert.notNull(channel, "KeyStreamingChannel must not be null");
        return this.scanStreaming(channel, ScanCursor.INITIAL, null);
    }

    Command<K, V, StreamScanCursor> scanStreaming(KeyStreamingChannel<K> channel, ScanCursor scanCursor) {
        RedisCommandBuilder.notNull(channel);
        LettuceAssert.notNull(channel, "KeyStreamingChannel must not be null");
        return this.scanStreaming(channel, scanCursor, null);
    }

    Command<K, V, StreamScanCursor> scanStreaming(KeyStreamingChannel<K> channel, ScanArgs scanArgs) {
        RedisCommandBuilder.notNull(channel);
        LettuceAssert.notNull(channel, "KeyStreamingChannel must not be null");
        return this.scanStreaming(channel, ScanCursor.INITIAL, scanArgs);
    }

    Command<K, V, StreamScanCursor> scanStreaming(KeyStreamingChannel<K> channel, ScanCursor scanCursor, ScanArgs scanArgs) {
        RedisCommandBuilder.notNull(channel);
        LettuceAssert.notNull(channel, "KeyStreamingChannel must not be null");
        CommandArgs args = new CommandArgs(this.codec);
        this.scanArgs(scanCursor, scanArgs, args);
        KeyScanStreamingOutput output = new KeyScanStreamingOutput(this.codec, channel);
        return this.createCommand(CommandType.SCAN, output, args);
    }

    Command<K, V, Long> scard(K key) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.SCARD, new IntegerOutput(this.codec), key);
    }

    Command<K, V, List<Boolean>> scriptExists(String ... digests) {
        LettuceAssert.notNull((Object)digests, "Digests must not be null");
        LettuceAssert.notEmpty((Object[])digests, "Digests must not be empty");
        LettuceAssert.noNullElements((Object[])digests, "Digests must not contain null elements");
        CommandArgs args = new CommandArgs(this.codec).add(CommandType.EXISTS);
        for (String sha : digests) {
            args.add(sha);
        }
        return this.createCommand(CommandType.SCRIPT, new BooleanListOutput(this.codec), args);
    }

    Command<K, V, String> scriptFlush() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.FLUSH);
        return this.createCommand(CommandType.SCRIPT, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> scriptFlush(FlushMode flushMode) {
        LettuceAssert.notNull((Object)flushMode, "FlushMode must not be null");
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.FLUSH).add(flushMode.name());
        return this.createCommand(CommandType.SCRIPT, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> scriptKill() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.KILL);
        return this.createCommand(CommandType.SCRIPT, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> scriptLoad(byte[] script) {
        LettuceAssert.notNull((Object)script, "Script must not be null");
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.LOAD).add(script);
        return this.createCommand(CommandType.SCRIPT, new StatusOutput(this.codec), args);
    }

    Command<K, V, Set<V>> sdiff(K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.SDIFF, new ValueSetOutput(this.codec), args);
    }

    Command<K, V, Long> sdiff(ValueStreamingChannel<V> channel, K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        RedisCommandBuilder.notNull(channel);
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.SDIFF, new ValueStreamingOutput(this.codec, channel), args);
    }

    Command<K, V, Long> sdiffstore(K destination, K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        LettuceAssert.notNull(destination, "Destination must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(destination).addKeys(keys);
        return this.createCommand(CommandType.SDIFFSTORE, new IntegerOutput(this.codec), args);
    }

    Command<K, V, String> select(int db) {
        CommandArgs args = new CommandArgs(this.codec).add(db);
        return this.createCommand(CommandType.SELECT, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> set(K key, V value) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.SET, new StatusOutput(this.codec), key, value);
    }

    Command<K, V, String> set(K key, V value, SetArgs setArgs) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addValue(value);
        setArgs.build(args);
        return this.createCommand(CommandType.SET, new StatusOutput(this.codec), args);
    }

    Command<K, V, V> setGet(K key, V value) {
        return this.setGet(key, value, new SetArgs());
    }

    Command<K, V, V> setGet(K key, V value, SetArgs setArgs) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull((Object)setArgs, "SetArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addValue(value);
        setArgs.build(args);
        args.add(CommandType.GET);
        return this.createCommand(CommandType.SET, new ValueOutput(this.codec), args);
    }

    Command<K, V, Long> setbit(K key, long offset, int value) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(offset).add(value);
        return this.createCommand(CommandType.SETBIT, new IntegerOutput(this.codec), args);
    }

    Command<K, V, String> setex(K key, long seconds, V value) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(seconds).addValue(value);
        return this.createCommand(CommandType.SETEX, new StatusOutput(this.codec), args);
    }

    Command<K, V, Boolean> setnx(K key, V value) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.SETNX, new BooleanOutput(this.codec), key, value);
    }

    Command<K, V, Long> setrange(K key, long offset, V value) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(offset).addValue(value);
        return this.createCommand(CommandType.SETRANGE, new IntegerOutput(this.codec), args);
    }

    Command<K, V, String> shutdown(boolean save) {
        CommandArgs args = new CommandArgs(this.codec);
        return this.createCommand(CommandType.SHUTDOWN, new StatusOutput(this.codec), save ? args.add(CommandType.SAVE) : args.add(CommandKeyword.NOSAVE));
    }

    Command<K, V, String> shutdown(ShutdownArgs shutdownArgs) {
        LettuceAssert.notNull((Object)shutdownArgs, "shutdownArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec);
        shutdownArgs.build(args);
        return this.createCommand(CommandType.SHUTDOWN, new StatusOutput(this.codec), args);
    }

    Command<K, V, Set<V>> sinter(K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.SINTER, new ValueSetOutput(this.codec), args);
    }

    Command<K, V, Long> sinter(ValueStreamingChannel<V> channel, K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        RedisCommandBuilder.notNull(channel);
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.SINTER, new ValueStreamingOutput(this.codec, channel), args);
    }

    Command<K, V, Long> sintercard(K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec).add(keys.length).addKeys(keys);
        return this.createCommand(CommandType.SINTERCARD, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> sintercard(long limit, K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec).add(keys.length).addKeys(keys).add(CommandKeyword.LIMIT).add(limit);
        return this.createCommand(CommandType.SINTERCARD, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> sinterstore(K destination, K ... keys) {
        LettuceAssert.notNull(destination, "Destination must not be null");
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec).addKey(destination).addKeys(keys);
        return this.createCommand(CommandType.SINTERSTORE, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Boolean> sismember(K key, V member) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.SISMEMBER, new BooleanOutput(this.codec), key, member);
    }

    Command<K, V, String> slaveof(String host, int port) {
        LettuceAssert.notNull((Object)host, "Host must not be null");
        LettuceAssert.notEmpty((CharSequence)host, "Host must not be empty");
        CommandArgs args = new CommandArgs(this.codec).add(host).add(port);
        return this.createCommand(CommandType.SLAVEOF, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> slaveofNoOne() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.NO).add(CommandKeyword.ONE);
        return this.createCommand(CommandType.SLAVEOF, new StatusOutput(this.codec), args);
    }

    Command<K, V, List<Object>> slowlogGet() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandType.GET);
        return this.createCommand(CommandType.SLOWLOG, new NestedMultiOutput(this.codec), args);
    }

    Command<K, V, List<Object>> slowlogGet(int count) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandType.GET).add(count);
        return this.createCommand(CommandType.SLOWLOG, new NestedMultiOutput(this.codec), args);
    }

    Command<K, V, Long> slowlogLen() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.LEN);
        return this.createCommand(CommandType.SLOWLOG, new IntegerOutput(this.codec), args);
    }

    Command<K, V, String> slowlogReset() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.RESET);
        return this.createCommand(CommandType.SLOWLOG, new StatusOutput(this.codec), args);
    }

    Command<K, V, Set<V>> smembers(K key) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.SMEMBERS, new ValueSetOutput(this.codec), key);
    }

    Command<K, V, Long> smembers(ValueStreamingChannel<V> channel, K key) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNull(channel);
        return this.createCommand(CommandType.SMEMBERS, new ValueStreamingOutput(this.codec, channel), key);
    }

    Command<K, V, List<Boolean>> smismember(K key, V ... members) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(members, "Members must not be null");
        LettuceAssert.notEmpty((Object[])members, "Members must not be empty");
        return this.createCommand(CommandType.SMISMEMBER, new BooleanListOutput(this.codec), key, members);
    }

    Command<K, V, Boolean> smove(K source, K destination, V member) {
        LettuceAssert.notNull(source, "Source must not be null");
        LettuceAssert.notNull(destination, "Destination must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(source).addKey(destination).addValue(member);
        return this.createCommand(CommandType.SMOVE, new BooleanOutput(this.codec), args);
    }

    Command<K, V, List<V>> sort(K key) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.SORT, new ValueListOutput(this.codec), key);
    }

    Command<K, V, List<V>> sort(K key, SortArgs sortArgs) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull((Object)sortArgs, "SortArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        sortArgs.build(args, null);
        return this.createCommand(CommandType.SORT, new ValueListOutput(this.codec), args);
    }

    Command<K, V, Long> sort(ValueStreamingChannel<V> channel, K key) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNull(channel);
        return this.createCommand(CommandType.SORT, new ValueStreamingOutput(this.codec, channel), key);
    }

    Command<K, V, Long> sort(ValueStreamingChannel<V> channel, K key, SortArgs sortArgs) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNull(channel);
        LettuceAssert.notNull((Object)sortArgs, "SortArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        sortArgs.build(args, null);
        return this.createCommand(CommandType.SORT, new ValueStreamingOutput(this.codec, channel), args);
    }

    Command<K, V, List<V>> sortReadOnly(K key) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.SORT_RO, new ValueListOutput(this.codec), key);
    }

    Command<K, V, List<V>> sortReadOnly(K key, SortArgs sortArgs) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull((Object)sortArgs, "SortArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        sortArgs.build(args, null);
        return this.createCommand(CommandType.SORT_RO, new ValueListOutput(this.codec), args);
    }

    Command<K, V, Long> sortReadOnly(ValueStreamingChannel<V> channel, K key) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNull(channel);
        return this.createCommand(CommandType.SORT_RO, new ValueStreamingOutput(this.codec, channel), key);
    }

    Command<K, V, Long> sortReadOnly(ValueStreamingChannel<V> channel, K key, SortArgs sortArgs) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNull(channel);
        LettuceAssert.notNull((Object)sortArgs, "SortArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        sortArgs.build(args, null);
        return this.createCommand(CommandType.SORT_RO, new ValueStreamingOutput(this.codec, channel), args);
    }

    Command<K, V, Long> sortStore(K key, SortArgs sortArgs, K destination) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(destination, "Destination must not be null");
        LettuceAssert.notNull((Object)sortArgs, "SortArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        sortArgs.build(args, destination);
        return this.createCommand(CommandType.SORT, new IntegerOutput(this.codec), args);
    }

    Command<K, V, V> spop(K key) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.SPOP, new ValueOutput(this.codec), key);
    }

    Command<K, V, Set<V>> spop(K key, long count) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(count);
        return this.createCommand(CommandType.SPOP, new ValueSetOutput(this.codec), args);
    }

    Command<K, V, V> srandmember(K key) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.SRANDMEMBER, new ValueOutput(this.codec), key);
    }

    Command<K, V, List<V>> srandmember(K key, long count) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(count);
        return this.createCommand(CommandType.SRANDMEMBER, new ValueListOutput(this.codec), args);
    }

    Command<K, V, Long> srandmember(ValueStreamingChannel<V> channel, K key, long count) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(count);
        return this.createCommand(CommandType.SRANDMEMBER, new ValueStreamingOutput(this.codec, channel), args);
    }

    Command<K, V, Long> srem(K key, V ... members) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(members, "Members must not be null");
        LettuceAssert.notEmpty((Object[])members, "Members must not be empty");
        return this.createCommand(CommandType.SREM, new IntegerOutput(this.codec), key, members);
    }

    Command<K, V, ValueScanCursor<V>> sscan(K key) {
        RedisCommandBuilder.notNullKey(key);
        return this.sscan(key, ScanCursor.INITIAL, null);
    }

    Command<K, V, ValueScanCursor<V>> sscan(K key, ScanCursor scanCursor) {
        RedisCommandBuilder.notNullKey(key);
        return this.sscan(key, scanCursor, null);
    }

    Command<K, V, ValueScanCursor<V>> sscan(K key, ScanArgs scanArgs) {
        RedisCommandBuilder.notNullKey(key);
        return this.sscan(key, ScanCursor.INITIAL, scanArgs);
    }

    Command<K, V, ValueScanCursor<V>> sscan(K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key);
        this.scanArgs(scanCursor, scanArgs, args);
        ValueScanOutput output = new ValueScanOutput(this.codec);
        return this.createCommand(CommandType.SSCAN, output, args);
    }

    Command<K, V, StreamScanCursor> sscanStreaming(ValueStreamingChannel<V> channel, K key) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNull(channel);
        return this.sscanStreaming(channel, key, ScanCursor.INITIAL, null);
    }

    Command<K, V, StreamScanCursor> sscanStreaming(ValueStreamingChannel<V> channel, K key, ScanCursor scanCursor) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNull(channel);
        return this.sscanStreaming(channel, key, scanCursor, null);
    }

    Command<K, V, StreamScanCursor> sscanStreaming(ValueStreamingChannel<V> channel, K key, ScanArgs scanArgs) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNull(channel);
        return this.sscanStreaming(channel, key, ScanCursor.INITIAL, scanArgs);
    }

    Command<K, V, StreamScanCursor> sscanStreaming(ValueStreamingChannel<V> channel, K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNull(channel);
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key);
        this.scanArgs(scanCursor, scanArgs, args);
        ValueScanStreamingOutput output = new ValueScanStreamingOutput(this.codec, channel);
        return this.createCommand(CommandType.SSCAN, output, args);
    }

    Command<K, V, Long> strlen(K key) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.STRLEN, new IntegerOutput(this.codec), key);
    }

    Command<K, V, StringMatchResult> stralgoLcs(StrAlgoArgs strAlgoArgs) {
        LettuceAssert.notNull((Object)strAlgoArgs, "StrAlgoArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec);
        strAlgoArgs.build(args);
        return this.createCommand(CommandType.STRALGO, new StringMatchResultOutput(this.codec, strAlgoArgs.isWithIdx()), args);
    }

    Command<K, V, Set<V>> sunion(K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.SUNION, new ValueSetOutput(this.codec), args);
    }

    Command<K, V, Long> sunion(ValueStreamingChannel<V> channel, K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        RedisCommandBuilder.notNull(channel);
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.SUNION, new ValueStreamingOutput(this.codec, channel), args);
    }

    Command<K, V, Long> sunionstore(K destination, K ... keys) {
        LettuceAssert.notNull(destination, "Destination must not be null");
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec).addKey(destination).addKeys(keys);
        return this.createCommand(CommandType.SUNIONSTORE, new IntegerOutput(this.codec), args);
    }

    Command<K, V, String> swapdb(int db1, int db2) {
        CommandArgs args = new CommandArgs(this.codec).add(db1).add(db2);
        return this.createCommand(CommandType.SWAPDB, new StatusOutput(this.codec), args);
    }

    Command<K, V, String> sync() {
        return this.createCommand(CommandType.SYNC, new StatusOutput(this.codec));
    }

    Command<K, V, List<V>> time() {
        CommandArgs args = new CommandArgs(this.codec);
        return this.createCommand(CommandType.TIME, new ValueListOutput(this.codec), args);
    }

    Command<K, V, Long> touch(K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.TOUCH, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> touch(Iterable<K> keys) {
        LettuceAssert.notNull(keys, "Keys must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.TOUCH, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> ttl(K key) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.TTL, new IntegerOutput(this.codec), key);
    }

    Command<K, V, String> type(K key) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.TYPE, new StatusOutput(this.codec), key);
    }

    Command<K, V, Long> unlink(K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.UNLINK, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> unlink(Iterable<K> keys) {
        LettuceAssert.notNull(keys, "Keys must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.UNLINK, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Boolean> copy(K source, K destination) {
        LettuceAssert.notNull(source, "Source must not be null");
        LettuceAssert.notNull(destination, "Destination must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(source).addKey(destination);
        return this.createCommand(CommandType.COPY, new BooleanOutput(this.codec), args);
    }

    Command<K, V, Boolean> copy(K source, K destination, CopyArgs copyArgs) {
        LettuceAssert.notNull(source, "Source must not be null");
        LettuceAssert.notNull(destination, "Destination must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(source).addKey(destination);
        copyArgs.build(args);
        return this.createCommand(CommandType.COPY, new BooleanOutput(this.codec), args);
    }

    Command<K, V, String> unwatch() {
        return this.createCommand(CommandType.UNWATCH, new StatusOutput(this.codec));
    }

    Command<K, V, Long> wait(int replicas, long timeout) {
        CommandArgs args = new CommandArgs(this.codec).add(replicas).add(timeout);
        return this.createCommand(CommandType.WAIT, new IntegerOutput(this.codec), args);
    }

    Command<K, V, String> watch(K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.WATCH, new StatusOutput(this.codec), args);
    }

    public Command<K, V, Long> xack(K key, K group, String[] messageIds) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(group, "Group must not be null");
        LettuceAssert.notEmpty((Object[])messageIds, "MessageIds must not be empty");
        LettuceAssert.noNullElements((Object[])messageIds, "MessageIds must not contain null elements");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKey(group);
        for (String messageId : messageIds) {
            args.add(messageId);
        }
        return this.createCommand(CommandType.XACK, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, ClaimedMessages<K, V>> xautoclaim(K key, XAutoClaimArgs<K> xAutoClaimArgs) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(xAutoClaimArgs, "XAutoClaimArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        xAutoClaimArgs.build(args);
        return this.createCommand(CommandType.XAUTOCLAIM, new ClaimedMessagesOutput(this.codec, key, xAutoClaimArgs.isJustid()), args);
    }

    public Command<K, V, List<StreamMessage<K, V>>> xclaim(K key, Consumer<K> consumer, XClaimArgs xClaimArgs, String[] messageIds) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(consumer, "Consumer must not be null");
        LettuceAssert.notEmpty((Object[])messageIds, "MessageIds must not be empty");
        LettuceAssert.noNullElements((Object[])messageIds, "MessageIds must not contain null elements");
        LettuceAssert.notNull((Object)xClaimArgs, "XClaimArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKey(consumer.group).addKey(consumer.name).add(xClaimArgs.minIdleTime);
        for (String messageId : messageIds) {
            args.add(messageId);
        }
        xClaimArgs.build(args);
        return this.createCommand(CommandType.XCLAIM, new StreamMessageListOutput(this.codec, key), args);
    }

    public Command<K, V, String> xadd(K key, XAddArgs xAddArgs, Map<K, V> map) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(map, "Message body must not be null");
        CommandArgs<K, V> args = new CommandArgs(this.codec).addKey(key);
        if (xAddArgs != null) {
            xAddArgs.build(args);
        } else {
            args.add("*");
        }
        args.add(map);
        return this.createCommand(CommandType.XADD, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> xadd(K key, XAddArgs xAddArgs, Object[] body) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull((Object)body, "Message body must not be null");
        LettuceAssert.notEmpty(body, "Message body must not be empty");
        LettuceAssert.noNullElements(body, "Message body must not contain null elements");
        LettuceAssert.isTrue(body.length % 2 == 0, "Message body.length must be a multiple of 2 and contain a sequence of field1, value1, field2, value2, fieldN, valueN");
        CommandArgs<Object, Object> args = new CommandArgs(this.codec).addKey(key);
        if (xAddArgs != null) {
            xAddArgs.build(args);
        } else {
            args.add("*");
        }
        for (int i = 0; i < body.length; i += 2) {
            args.addKey(body[i]);
            args.addValue(body[i + 1]);
        }
        return this.createCommand(CommandType.XADD, new StatusOutput(this.codec), args);
    }

    public Command<K, V, Long> xdel(K key, String[] messageIds) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notEmpty((Object[])messageIds, "MessageIds must not be empty");
        LettuceAssert.noNullElements((Object[])messageIds, "MessageIds must not contain null elements");
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        for (String messageId : messageIds) {
            args.add(messageId);
        }
        return this.createCommand(CommandType.XDEL, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, String> xgroupCreate(XReadArgs.StreamOffset<K> offset, K group, XGroupCreateArgs commandArgs) {
        LettuceAssert.notNull(offset, "StreamOffset must not be null");
        LettuceAssert.notNull(group, "Group must not be null");
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.CREATE).addKey(offset.getName()).addKey(group).add(offset.getOffset());
        if (commandArgs != null) {
            commandArgs.build(args);
        }
        return this.createCommand(CommandType.XGROUP, new StatusOutput(this.codec), args);
    }

    public Command<K, V, Boolean> xgroupCreateconsumer(K key, Consumer<K> consumer) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(consumer, "Consumer must not be null");
        CommandArgs args = new CommandArgs(this.codec).add("CREATECONSUMER").addKey(key).addKey(consumer.getGroup()).addKey(consumer.getName());
        return this.createCommand(CommandType.XGROUP, new BooleanOutput(this.codec), args);
    }

    public Command<K, V, Long> xgroupDelconsumer(K key, Consumer<K> consumer) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(consumer, "Consumer must not be null");
        CommandArgs args = new CommandArgs(this.codec).add("DELCONSUMER").addKey(key).addKey(consumer.getGroup()).addKey(consumer.getName());
        return this.createCommand(CommandType.XGROUP, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, Boolean> xgroupDestroy(K key, K group) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(group, "Group must not be null");
        CommandArgs args = new CommandArgs(this.codec).add("DESTROY").addKey(key).addKey(group);
        return this.createCommand(CommandType.XGROUP, new BooleanOutput(this.codec), args);
    }

    public Command<K, V, String> xgroupSetid(XReadArgs.StreamOffset<K> offset, K group) {
        LettuceAssert.notNull(offset, "StreamOffset must not be null");
        LettuceAssert.notNull(group, "Group must not be null");
        CommandArgs args = new CommandArgs(this.codec).add("SETID").addKey(offset.getName()).addKey(group).add(offset.getOffset());
        return this.createCommand(CommandType.XGROUP, new StatusOutput(this.codec), args);
    }

    public Command<K, V, List<Object>> xinfoStream(K key) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.STREAM).addKey(key);
        return this.createCommand(CommandType.XINFO, new ArrayOutput(this.codec), args);
    }

    public Command<K, V, List<Object>> xinfoGroups(K key) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.GROUPS).addKey(key);
        return this.createCommand(CommandType.XINFO, new ArrayOutput(this.codec), args);
    }

    public Command<K, V, List<Object>> xinfoConsumers(K key, K group) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.CONSUMERS).addKey(key).addKey(group);
        return this.createCommand(CommandType.XINFO, new ArrayOutput(this.codec), args);
    }

    public Command<K, V, Long> xlen(K key) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        return this.createCommand(CommandType.XLEN, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, PendingMessages> xpending(K key, K group) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(group, "Group must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKey(group);
        return this.createCommand(CommandType.XPENDING, new PendingMessagesOutput(this.codec), args);
    }

    public Command<K, V, List<PendingMessage>> xpending(K key, K group, Range<String> range, Limit limit) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(group, "Group must not be null");
        LettuceAssert.notNull(range, "Range must not be null");
        LettuceAssert.notNull((Object)limit, "Limit must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKey(group);
        args.add(RedisCommandBuilder.getLowerValue(range)).add(RedisCommandBuilder.getUpperValue(range));
        args.add(limit.isLimited() ? limit.getCount() : Long.MAX_VALUE);
        return this.createCommand(CommandType.XPENDING, new PendingMessageListOutput(this.codec), args);
    }

    public Command<K, V, List<PendingMessage>> xpending(K key, Consumer<K> consumer, Range<String> range, Limit limit) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(consumer, "Consumer must not be null");
        LettuceAssert.notNull(range, "Range must not be null");
        LettuceAssert.notNull((Object)limit, "Limit must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKey(consumer.group);
        args.add(RedisCommandBuilder.getLowerValue(range)).add(RedisCommandBuilder.getUpperValue(range));
        args.add(limit.isLimited() ? limit.getCount() : Long.MAX_VALUE);
        args.addKey(consumer.name);
        return this.createCommand(CommandType.XPENDING, new PendingMessageListOutput(this.codec), args);
    }

    public Command<K, V, List<PendingMessage>> xpending(K key, XPendingArgs<K> commandArgs) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(commandArgs, "XPendingArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        commandArgs.build(args);
        return this.createCommand(CommandType.XPENDING, new PendingMessageListOutput(this.codec), args);
    }

    public Command<K, V, List<StreamMessage<K, V>>> xrange(K key, Range<String> range, Limit limit) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(range, "Range must not be null");
        LettuceAssert.notNull((Object)limit, "Limit must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        args.add(RedisCommandBuilder.getLowerValue(range)).add(RedisCommandBuilder.getUpperValue(range));
        if (limit.isLimited()) {
            args.add(CommandKeyword.COUNT).add(limit.getCount());
        }
        return this.createCommand(CommandType.XRANGE, new StreamMessageListOutput(this.codec, key), args);
    }

    public Command<K, V, List<StreamMessage<K, V>>> xrevrange(K key, Range<String> range, Limit limit) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(range, "Range must not be null");
        LettuceAssert.notNull((Object)limit, "Limit must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        args.add(RedisCommandBuilder.getUpperValue(range)).add(RedisCommandBuilder.getLowerValue(range));
        if (limit.isLimited()) {
            args.add(CommandKeyword.COUNT).add(limit.getCount());
        }
        return this.createCommand(CommandType.XREVRANGE, new StreamMessageListOutput(this.codec, key), args);
    }

    public Command<K, V, Long> xtrim(K key, boolean approximateTrimming, long count) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(CommandKeyword.MAXLEN);
        if (approximateTrimming) {
            args.add("~");
        }
        args.add(count);
        return this.createCommand(CommandType.XTRIM, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, Long> xtrim(K key, XTrimArgs xTrimArgs) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull((Object)xTrimArgs, "XTrimArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        xTrimArgs.build(args);
        return this.createCommand(CommandType.XTRIM, new IntegerOutput(this.codec), args);
    }

    private static String getLowerValue(Range<String> range) {
        Range.Boundary<String> boundary = range.getLower();
        return boundary.equals(Range.Boundary.unbounded()) ? "-" : RedisCommandBuilder.getRange(boundary);
    }

    private static String getUpperValue(Range<String> range) {
        Range.Boundary<String> boundary = range.getUpper();
        return boundary.equals(Range.Boundary.unbounded()) ? "+" : RedisCommandBuilder.getRange(boundary);
    }

    private static String getRange(Range.Boundary<String> boundary) {
        return !boundary.isIncluding() ? "(" + boundary.getValue() : boundary.getValue();
    }

    public Command<K, V, List<StreamMessage<K, V>>> xread(XReadArgs xReadArgs, XReadArgs.StreamOffset<K>[] streams) {
        LettuceAssert.notNull(streams, "Streams must not be null");
        LettuceAssert.isTrue(streams.length > 0, "Streams must not be empty");
        CommandArgs args = new CommandArgs(this.codec);
        if (xReadArgs != null) {
            xReadArgs.build(args);
        }
        args.add("STREAMS");
        for (XReadArgs.StreamOffset<K> stream : streams) {
            args.addKey(stream.name);
        }
        for (XReadArgs.StreamOffset<K> stream : streams) {
            args.add(stream.offset);
        }
        return this.createCommand(CommandType.XREAD, new StreamReadOutput(this.codec), args);
    }

    public Command<K, V, List<StreamMessage<K, V>>> xreadgroup(Consumer<K> consumer, XReadArgs xReadArgs, XReadArgs.StreamOffset<K> ... streams) {
        LettuceAssert.notNull(streams, "Streams must not be null");
        LettuceAssert.isTrue(streams.length > 0, "Streams must not be empty");
        LettuceAssert.notNull(consumer, "Consumer must not be null");
        CommandArgs args = new CommandArgs(this.codec);
        args.add("GROUP").add(this.encode(consumer.group)).add(this.encode(consumer.name));
        if (xReadArgs != null) {
            xReadArgs.build(args);
        }
        args.add("STREAMS");
        for (XReadArgs.StreamOffset<K> stream : streams) {
            args.addKey(stream.name);
        }
        for (XReadArgs.StreamOffset<K> stream : streams) {
            args.add(stream.offset);
        }
        return this.createCommand(CommandType.XREADGROUP, new StreamReadOutput(this.codec), args);
    }

    private byte[] encode(K k) {
        ByteBuffer byteBuffer = this.codec.encodeKey(k);
        byte[] result = new byte[byteBuffer.remaining()];
        byteBuffer.get(result);
        return result;
    }

    Command<K, V, KeyValue<K, ScoredValue<V>>> bzpopmin(long timeout, K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys).add(timeout);
        return this.createCommand(CommandType.BZPOPMIN, new KeyValueScoredValueOutput(this.codec), args);
    }

    Command<K, V, KeyValue<K, ScoredValue<V>>> bzpopmin(double timeout, K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys).add(timeout);
        return this.createCommand(CommandType.BZPOPMIN, new KeyValueScoredValueOutput(this.codec), args);
    }

    Command<K, V, KeyValue<K, ScoredValue<V>>> bzpopmax(long timeout, K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys).add(timeout);
        return this.createCommand(CommandType.BZPOPMAX, new KeyValueScoredValueOutput(this.codec), args);
    }

    Command<K, V, KeyValue<K, ScoredValue<V>>> bzpopmax(double timeout, K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys).add(timeout);
        return this.createCommand(CommandType.BZPOPMAX, new KeyValueScoredValueOutput(this.codec), args);
    }

    Command<K, V, Long> zadd(K key, ZAddArgs zAddArgs, double score, V member) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        if (zAddArgs != null) {
            zAddArgs.build(args);
        }
        args.add(score).addValue(member);
        return this.createCommand(CommandType.ZADD, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> zadd(K key, ZAddArgs zAddArgs, Object ... scoresAndValues) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull((Object)scoresAndValues, "ScoresAndValues must not be null");
        LettuceAssert.notEmpty(scoresAndValues, "ScoresAndValues must not be empty");
        LettuceAssert.noNullElements(scoresAndValues, "ScoresAndValues must not contain null elements");
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        if (zAddArgs != null) {
            zAddArgs.build(args);
        }
        if (this.allElementsInstanceOf(scoresAndValues, ScoredValue.class)) {
            for (Object o : scoresAndValues) {
                ScoredValue scoredValue = (ScoredValue)o;
                args.add(scoredValue.getScore());
                args.addValue(scoredValue.getValue());
            }
        } else {
            LettuceAssert.isTrue(scoresAndValues.length % 2 == 0, "ScoresAndValues.length must be a multiple of 2 and contain a sequence of score1, value1, score2, value2, scoreN, valueN");
            for (int i = 0; i < scoresAndValues.length; i += 2) {
                args.add((Double)scoresAndValues[i]);
                args.addValue(scoresAndValues[i + 1]);
            }
        }
        return this.createCommand(CommandType.ZADD, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Double> zaddincr(K key, ZAddArgs zAddArgs, double score, V member) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        if (zAddArgs != null) {
            zAddArgs.build(args);
        }
        args.add(CommandType.INCR);
        args.add(score).addValue(member);
        return this.createCommand(CommandType.ZADD, new DoubleOutput(this.codec), args);
    }

    Command<K, V, Long> zcard(K key) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.ZCARD, new IntegerOutput(this.codec), key);
    }

    Command<K, V, Long> zcount(K key, double min, double max) {
        return this.zcount(key, LettuceStrings.string(min), LettuceStrings.string(max));
    }

    Command<K, V, Long> zcount(K key, String min, String max) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullMinMax(min, max);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(min).add(max);
        return this.createCommand(CommandType.ZCOUNT, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> zcount(K key, Range<? extends Number> range) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullRange(range);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(RedisCommandBuilder.min(range)).add(RedisCommandBuilder.max(range));
        return this.createCommand(CommandType.ZCOUNT, new IntegerOutput(this.codec), args);
    }

    Command<K, V, List<V>> zdiff(K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec);
        args.add(keys.length).addKeys(keys);
        return this.createCommand(CommandType.ZDIFF, new ValueListOutput(this.codec), args);
    }

    Command<K, V, Long> zdiffstore(K destKey, K ... srcKeys) {
        RedisCommandBuilder.notNullKey(destKey);
        RedisCommandBuilder.notEmpty(srcKeys);
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(destKey).add(srcKeys.length).addKeys(srcKeys);
        return this.createCommand(CommandType.ZDIFFSTORE, new IntegerOutput(this.codec), args);
    }

    Command<K, V, List<ScoredValue<V>>> zdiffWithScores(K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec);
        args.add(keys.length).addKeys(keys).add(CommandKeyword.WITHSCORES);
        return this.createCommand(CommandType.ZDIFF, new ScoredValueListOutput(this.codec), args);
    }

    Command<K, V, Double> zincrby(K key, double amount, V member) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(amount).addValue(member);
        return this.createCommand(CommandType.ZINCRBY, new DoubleOutput(this.codec), args);
    }

    Command<K, V, List<V>> zinter(K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        return this.zinter(new ZAggregateArgs(), keys);
    }

    Command<K, V, List<V>> zinter(ZAggregateArgs aggregateArgs, K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec);
        args.add(keys.length).addKeys(keys);
        aggregateArgs.build(args);
        return this.createCommand(CommandType.ZINTER, new ValueListOutput(this.codec), args);
    }

    Command<K, V, Long> zintercard(K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec).add(keys.length).addKeys(keys);
        return this.createCommand(CommandType.ZINTERCARD, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> zintercard(long limit, K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec).add(keys.length).addKeys(keys).add(CommandKeyword.LIMIT).add(limit);
        return this.createCommand(CommandType.ZINTERCARD, new IntegerOutput(this.codec), args);
    }

    Command<K, V, List<ScoredValue<V>>> zinterWithScores(K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        return this.zinterWithScores(new ZAggregateArgs(), keys);
    }

    Command<K, V, List<ScoredValue<V>>> zinterWithScores(ZAggregateArgs aggregateArgs, K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec);
        args.add(keys.length).addKeys(keys).add(CommandKeyword.WITHSCORES);
        aggregateArgs.build(args);
        return this.createCommand(CommandType.ZINTER, new ScoredValueListOutput(this.codec), args);
    }

    Command<K, V, Long> zinterstore(K destination, K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        return this.zinterstore(destination, new ZAggregateArgs(), keys);
    }

    Command<K, V, Long> zinterstore(K destination, ZAggregateArgs aggregateArgs, K ... keys) {
        LettuceAssert.notNull(destination, "Destination must not be null");
        LettuceAssert.notNull((Object)aggregateArgs, "ZStoreArgs must not be null");
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec).addKey(destination).add(keys.length).addKeys(keys);
        aggregateArgs.build(args);
        return this.createCommand(CommandType.ZINTERSTORE, new IntegerOutput(this.codec), args);
    }

    RedisCommand<K, V, Long> zlexcount(K key, String min, String max) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullMinMax(min, max);
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(min).add(max);
        return this.createCommand(CommandType.ZLEXCOUNT, new IntegerOutput(this.codec), args);
    }

    RedisCommand<K, V, Long> zlexcount(K key, Range<? extends V> range) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullRange(range);
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(this.minValue(range)).add(this.maxValue(range));
        return this.createCommand(CommandType.ZLEXCOUNT, new IntegerOutput(this.codec), args);
    }

    Command<K, V, List<Double>> zmscore(K key, V ... members) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notEmpty(members);
        return this.createCommand(CommandType.ZMSCORE, new DoubleListOutput(this.codec), key, members);
    }

    Command<K, V, ScoredValue<V>> zpopmin(K key) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKeys(key);
        return this.createCommand(CommandType.ZPOPMIN, new ScoredValueOutput(this.codec), args);
    }

    Command<K, V, List<ScoredValue<V>>> zpopmin(K key, long count) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKeys(key).add(count);
        return this.createCommand(CommandType.ZPOPMIN, new ScoredValueListOutput(this.codec), args);
    }

    Command<K, V, ScoredValue<V>> zpopmax(K key) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKeys(key);
        return this.createCommand(CommandType.ZPOPMAX, new ScoredValueOutput(this.codec), args);
    }

    Command<K, V, List<ScoredValue<V>>> zpopmax(K key, long count) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKeys(key).add(count);
        return this.createCommand(CommandType.ZPOPMAX, new ScoredValueListOutput(this.codec), args);
    }

    Command<K, V, V> zrandmember(K key) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKeys(key);
        return this.createCommand(CommandType.ZRANDMEMBER, new ValueOutput(this.codec), args);
    }

    Command<K, V, List<V>> zrandmember(K key, long count) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKeys(key).add(count);
        return this.createCommand(CommandType.ZRANDMEMBER, new ValueListOutput(this.codec), args);
    }

    Command<K, V, ScoredValue<V>> zrandmemberWithScores(K key) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKeys(key).add(1L).add(CommandKeyword.WITHSCORES);
        return this.createCommand(CommandType.ZRANDMEMBER, new ScoredValueOutput(this.codec), args);
    }

    Command<K, V, List<ScoredValue<V>>> zrandmemberWithScores(K key, long count) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKeys(key).add(count).add(CommandKeyword.WITHSCORES);
        return this.createCommand(CommandType.ZRANDMEMBER, new ScoredValueListOutput(this.codec), args);
    }

    Command<K, V, List<V>> zrange(K key, long start, long stop) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(start).add(stop);
        return this.createCommand(CommandType.ZRANGE, new ValueListOutput(this.codec), args);
    }

    Command<K, V, Long> zrange(ValueStreamingChannel<V> channel, K key, long start, long stop) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(start).add(stop);
        return this.createCommand(CommandType.ZRANGE, new ValueStreamingOutput(this.codec, channel), args);
    }

    Command<K, V, List<ScoredValue<V>>> zrangeWithScores(K key, long start, long stop) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(start).add(stop).add(CommandKeyword.WITHSCORES);
        return this.createCommand(CommandType.ZRANGE, new ScoredValueListOutput(this.codec), args);
    }

    Command<K, V, Long> zrangeWithScores(ScoredValueStreamingChannel<V> channel, K key, long start, long stop) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNull(channel);
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(start).add(stop).add(CommandKeyword.WITHSCORES);
        return this.createCommand(CommandType.ZRANGE, new ScoredValueStreamingOutput(this.codec, channel), args);
    }

    RedisCommand<K, V, List<V>> zrangebylex(K key, String min, String max) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullMinMax(min, max);
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(min).add(max);
        return this.createCommand(CommandType.ZRANGEBYLEX, new ValueListOutput(this.codec), args);
    }

    RedisCommand<K, V, List<V>> zrangebylex(K key, String min, String max, long offset, long count) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullMinMax(min, max);
        CommandArgs args = new CommandArgs(this.codec);
        RedisCommandBuilder.addLimit(args.addKey(key).add(min).add(max), Limit.create(offset, count));
        return this.createCommand(CommandType.ZRANGEBYLEX, new ValueListOutput(this.codec), args);
    }

    RedisCommand<K, V, List<V>> zrangebylex(K key, Range<? extends V> range, Limit limit) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullRange(range);
        RedisCommandBuilder.notNullLimit(limit);
        CommandArgs args = new CommandArgs(this.codec);
        RedisCommandBuilder.addLimit(args.addKey(key).add(this.minValue(range)).add(this.maxValue(range)), limit);
        return this.createCommand(CommandType.ZRANGEBYLEX, new ValueListOutput(this.codec), args);
    }

    Command<K, V, List<V>> zrangebyscore(K key, double min, double max) {
        return this.zrangebyscore(key, LettuceStrings.string(min), LettuceStrings.string(max));
    }

    Command<K, V, List<V>> zrangebyscore(K key, String min, String max) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullMinMax(min, max);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(min).add(max);
        return this.createCommand(CommandType.ZRANGEBYSCORE, new ValueListOutput(this.codec), args);
    }

    Command<K, V, List<V>> zrangebyscore(K key, double min, double max, long offset, long count) {
        return this.zrangebyscore(key, LettuceStrings.string(min), LettuceStrings.string(max), offset, count);
    }

    Command<K, V, List<V>> zrangebyscore(K key, String min, String max, long offset, long count) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullMinMax(min, max);
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(min).add(max).add(CommandKeyword.LIMIT).add(offset).add(count);
        return this.createCommand(CommandType.ZRANGEBYSCORE, new ValueListOutput(this.codec), args);
    }

    Command<K, V, List<V>> zrangebyscore(K key, Range<? extends Number> range, Limit limit) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullRange(range);
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(RedisCommandBuilder.min(range)).add(RedisCommandBuilder.max(range));
        if (limit.isLimited()) {
            args.add(CommandKeyword.LIMIT).add(limit.getOffset()).add(limit.getCount());
        }
        return this.createCommand(CommandType.ZRANGEBYSCORE, new ValueListOutput(this.codec), args);
    }

    Command<K, V, Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, double min, double max) {
        return this.zrangebyscore(channel, key, LettuceStrings.string(min), LettuceStrings.string(max));
    }

    Command<K, V, Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, String min, String max) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullMinMax(min, max);
        LettuceAssert.notNull(channel, "ScoredValueStreamingChannel must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(min).add(max);
        return this.createCommand(CommandType.ZRANGEBYSCORE, new ValueStreamingOutput(this.codec, channel), args);
    }

    Command<K, V, Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, double min, double max, long offset, long count) {
        return this.zrangebyscore(channel, key, LettuceStrings.string(min), LettuceStrings.string(max), offset, count);
    }

    Command<K, V, Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, String min, String max, long offset, long count) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullMinMax(min, max);
        LettuceAssert.notNull(channel, "ScoredValueStreamingChannel must not be null");
        CommandArgs args = new CommandArgs(this.codec);
        RedisCommandBuilder.addLimit(args.addKey(key).add(min).add(max), Limit.create(offset, count));
        return this.createCommand(CommandType.ZRANGEBYSCORE, new ValueStreamingOutput(this.codec, channel), args);
    }

    Command<K, V, Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, Range<? extends Number> range, Limit limit) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullRange(range);
        RedisCommandBuilder.notNullLimit(limit);
        LettuceAssert.notNull(channel, "ScoredValueStreamingChannel must not be null");
        CommandArgs args = new CommandArgs(this.codec);
        RedisCommandBuilder.addLimit(args.addKey(key).add(RedisCommandBuilder.min(range)).add(RedisCommandBuilder.max(range)), limit);
        return this.createCommand(CommandType.ZRANGEBYSCORE, new ValueStreamingOutput(this.codec, channel), args);
    }

    Command<K, V, List<ScoredValue<V>>> zrangebyscoreWithScores(K key, double min, double max) {
        return this.zrangebyscoreWithScores(key, LettuceStrings.string(min), LettuceStrings.string(max));
    }

    Command<K, V, List<ScoredValue<V>>> zrangebyscoreWithScores(K key, String min, String max) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullMinMax(min, max);
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(min).add(max).add(CommandKeyword.WITHSCORES);
        return this.createCommand(CommandType.ZRANGEBYSCORE, new ScoredValueListOutput(this.codec), args);
    }

    Command<K, V, List<ScoredValue<V>>> zrangebyscoreWithScores(K key, double min, double max, long offset, long count) {
        return this.zrangebyscoreWithScores(key, LettuceStrings.string(min), LettuceStrings.string(max), offset, count);
    }

    Command<K, V, List<ScoredValue<V>>> zrangebyscoreWithScores(K key, String min, String max, long offset, long count) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullMinMax(min, max);
        CommandArgs args = new CommandArgs(this.codec);
        RedisCommandBuilder.addLimit(args.addKey(key).add(min).add(max).add(CommandKeyword.WITHSCORES), Limit.create(offset, count));
        return this.createCommand(CommandType.ZRANGEBYSCORE, new ScoredValueListOutput(this.codec), args);
    }

    Command<K, V, List<ScoredValue<V>>> zrangebyscoreWithScores(K key, Range<? extends Number> range, Limit limit) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullRange(range);
        RedisCommandBuilder.notNullLimit(limit);
        CommandArgs args = new CommandArgs(this.codec);
        RedisCommandBuilder.addLimit(args.addKey(key).add(RedisCommandBuilder.min(range)).add(RedisCommandBuilder.max(range)).add(CommandKeyword.WITHSCORES), limit);
        return this.createCommand(CommandType.ZRANGEBYSCORE, new ScoredValueListOutput(this.codec), args);
    }

    Command<K, V, Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double min, double max) {
        return this.zrangebyscoreWithScores(channel, key, LettuceStrings.string(min), LettuceStrings.string(max));
    }

    Command<K, V, Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String min, String max) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullMinMax(min, max);
        RedisCommandBuilder.notNull(channel);
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(min).add(max).add(CommandKeyword.WITHSCORES);
        return this.createCommand(CommandType.ZRANGEBYSCORE, new ScoredValueStreamingOutput(this.codec, channel), args);
    }

    Command<K, V, Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double min, double max, long offset, long count) {
        return this.zrangebyscoreWithScores(channel, key, LettuceStrings.string(min), LettuceStrings.string(max), offset, count);
    }

    Command<K, V, Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String min, String max, long offset, long count) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullMinMax(min, max);
        RedisCommandBuilder.notNull(channel);
        CommandArgs args = new CommandArgs(this.codec);
        RedisCommandBuilder.addLimit(args.addKey(key).add(min).add(max).add(CommandKeyword.WITHSCORES), Limit.create(offset, count));
        return this.createCommand(CommandType.ZRANGEBYSCORE, new ScoredValueStreamingOutput(this.codec, channel), args);
    }

    Command<K, V, Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, Range<? extends Number> range, Limit limit) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullRange(range);
        RedisCommandBuilder.notNullLimit(limit);
        RedisCommandBuilder.notNull(channel);
        CommandArgs args = new CommandArgs(this.codec);
        RedisCommandBuilder.addLimit(args.addKey(key).add(RedisCommandBuilder.min(range)).add(RedisCommandBuilder.max(range)).add(CommandKeyword.WITHSCORES), limit);
        return this.createCommand(CommandType.ZRANGEBYSCORE, new ScoredValueStreamingOutput(this.codec, channel), args);
    }

    Command<K, V, Long> zrangestore(K dstKey, K srcKey, Range<Long> range, boolean rev) {
        RedisCommandBuilder.notNullKey(srcKey);
        RedisCommandBuilder.notNullKey(dstKey);
        RedisCommandBuilder.notNullRange(range);
        CommandArgs args = new CommandArgs(this.codec);
        args.addKeys(dstKey, srcKey);
        args.add(RedisCommandBuilder.min(range)).add(RedisCommandBuilder.max(range));
        if (rev) {
            args.add(CommandKeyword.REV);
        }
        return this.createCommand(CommandType.ZRANGESTORE, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> zrangestorebylex(K dstKey, K srcKey, Range<? extends V> range, Limit limit, boolean rev) {
        RedisCommandBuilder.notNullKey(srcKey);
        RedisCommandBuilder.notNullKey(dstKey);
        RedisCommandBuilder.notNullRange(range);
        RedisCommandBuilder.notNullLimit(limit);
        CommandArgs args = new CommandArgs(this.codec);
        args.addKeys(dstKey, srcKey);
        if (rev) {
            args.add(this.maxValue(range)).add(this.minValue(range));
        } else {
            args.add(this.minValue(range)).add(this.maxValue(range));
        }
        args.add(CommandKeyword.BYLEX);
        if (rev) {
            args.add(CommandKeyword.REV);
        }
        RedisCommandBuilder.addLimit(args, limit);
        return this.createCommand(CommandType.ZRANGESTORE, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> zrangestorebyscore(K dstKey, K srcKey, Range<? extends Number> range, Limit limit, boolean rev) {
        RedisCommandBuilder.notNullKey(srcKey);
        RedisCommandBuilder.notNullKey(dstKey);
        RedisCommandBuilder.notNullRange(range);
        RedisCommandBuilder.notNullLimit(limit);
        CommandArgs args = new CommandArgs(this.codec);
        args.addKeys(dstKey, srcKey);
        if (rev) {
            args.add(RedisCommandBuilder.max(range)).add(RedisCommandBuilder.min(range));
        } else {
            args.add(RedisCommandBuilder.min(range)).add(RedisCommandBuilder.max(range));
        }
        args.add(CommandKeyword.BYSCORE);
        if (rev) {
            args.add(CommandKeyword.REV);
        }
        RedisCommandBuilder.addLimit(args, limit);
        return this.createCommand(CommandType.ZRANGESTORE, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> zrank(K key, V member) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.ZRANK, new IntegerOutput(this.codec), key, member);
    }

    Command<K, V, Long> zrem(K key, V ... members) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(members, "Members must not be null");
        LettuceAssert.notEmpty((Object[])members, "Members must not be empty");
        return this.createCommand(CommandType.ZREM, new IntegerOutput(this.codec), key, members);
    }

    RedisCommand<K, V, Long> zremrangebylex(K key, String min, String max) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullMinMax(min, max);
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(min).add(max);
        return this.createCommand(CommandType.ZREMRANGEBYLEX, new IntegerOutput(this.codec), args);
    }

    RedisCommand<K, V, Long> zremrangebylex(K key, Range<? extends V> range) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullRange(range);
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(this.minValue(range)).add(this.maxValue(range));
        return this.createCommand(CommandType.ZREMRANGEBYLEX, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> zremrangebyrank(K key, long start, long stop) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(start).add(stop);
        return this.createCommand(CommandType.ZREMRANGEBYRANK, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> zremrangebyscore(K key, double min, double max) {
        return this.zremrangebyscore(key, LettuceStrings.string(min), LettuceStrings.string(max));
    }

    Command<K, V, Long> zremrangebyscore(K key, String min, String max) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullMinMax(min, max);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(min).add(max);
        return this.createCommand(CommandType.ZREMRANGEBYSCORE, new IntegerOutput(this.codec), args);
    }

    Command<K, V, Long> zremrangebyscore(K key, Range<? extends Number> range) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullRange(range);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(RedisCommandBuilder.min(range)).add(RedisCommandBuilder.max(range));
        return this.createCommand(CommandType.ZREMRANGEBYSCORE, new IntegerOutput(this.codec), args);
    }

    Command<K, V, List<V>> zrevrange(K key, long start, long stop) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(start).add(stop);
        return this.createCommand(CommandType.ZREVRANGE, new ValueListOutput(this.codec), args);
    }

    Command<K, V, Long> zrevrange(ValueStreamingChannel<V> channel, K key, long start, long stop) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNull(channel);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(start).add(stop);
        return this.createCommand(CommandType.ZREVRANGE, new ValueStreamingOutput(this.codec, channel), args);
    }

    Command<K, V, List<ScoredValue<V>>> zrevrangeWithScores(K key, long start, long stop) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(start).add(stop).add(CommandKeyword.WITHSCORES);
        return this.createCommand(CommandType.ZREVRANGE, new ScoredValueListOutput(this.codec), args);
    }

    Command<K, V, Long> zrevrangeWithScores(ScoredValueStreamingChannel<V> channel, K key, long start, long stop) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(channel, "ValueStreamingChannel must not be null");
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(start).add(stop).add(CommandKeyword.WITHSCORES);
        return this.createCommand(CommandType.ZREVRANGE, new ScoredValueStreamingOutput(this.codec, channel), args);
    }

    Command<K, V, List<V>> zrevrangebylex(K key, Range<? extends V> range, Limit limit) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullRange(range);
        RedisCommandBuilder.notNullLimit(limit);
        CommandArgs args = new CommandArgs(this.codec);
        RedisCommandBuilder.addLimit(args.addKey(key).add(this.maxValue(range)).add(this.minValue(range)), limit);
        return this.createCommand(CommandType.ZREVRANGEBYLEX, new ValueListOutput(this.codec), args);
    }

    Command<K, V, List<V>> zrevrangebyscore(K key, double max, double min) {
        return this.zrevrangebyscore(key, LettuceStrings.string(max), LettuceStrings.string(min));
    }

    Command<K, V, List<V>> zrevrangebyscore(K key, String max, String min) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullMinMax(min, max);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(max).add(min);
        return this.createCommand(CommandType.ZREVRANGEBYSCORE, new ValueListOutput(this.codec), args);
    }

    Command<K, V, List<V>> zrevrangebyscore(K key, double max, double min, long offset, long count) {
        return this.zrevrangebyscore(key, LettuceStrings.string(max), LettuceStrings.string(min), offset, count);
    }

    Command<K, V, List<V>> zrevrangebyscore(K key, String max, String min, long offset, long count) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullMinMax(min, max);
        CommandArgs args = new CommandArgs(this.codec);
        RedisCommandBuilder.addLimit(args.addKey(key).add(max).add(min), Limit.create(offset, count));
        return this.createCommand(CommandType.ZREVRANGEBYSCORE, new ValueListOutput(this.codec), args);
    }

    Command<K, V, List<V>> zrevrangebyscore(K key, Range<? extends Number> range, Limit limit) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullRange(range);
        RedisCommandBuilder.notNullLimit(limit);
        CommandArgs args = new CommandArgs(this.codec);
        RedisCommandBuilder.addLimit(args.addKey(key).add(RedisCommandBuilder.max(range)).add(RedisCommandBuilder.min(range)), limit);
        return this.createCommand(CommandType.ZREVRANGEBYSCORE, new ValueListOutput(this.codec), args);
    }

    Command<K, V, Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, double max, double min) {
        return this.zrevrangebyscore(channel, key, LettuceStrings.string(max), LettuceStrings.string(min));
    }

    Command<K, V, Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, String max, String min) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullMinMax(min, max);
        RedisCommandBuilder.notNull(channel);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(max).add(min);
        return this.createCommand(CommandType.ZREVRANGEBYSCORE, new ValueStreamingOutput(this.codec, channel), args);
    }

    Command<K, V, Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, double max, double min, long offset, long count) {
        return this.zrevrangebyscore(channel, key, LettuceStrings.string(max), LettuceStrings.string(min), offset, count);
    }

    Command<K, V, Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, String max, String min, long offset, long count) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullMinMax(min, max);
        RedisCommandBuilder.notNull(channel);
        CommandArgs args = new CommandArgs(this.codec);
        RedisCommandBuilder.addLimit(args.addKey(key).add(max).add(min), Limit.create(offset, count));
        return this.createCommand(CommandType.ZREVRANGEBYSCORE, new ValueStreamingOutput(this.codec, channel), args);
    }

    Command<K, V, Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, Range<? extends Number> range, Limit limit) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullRange(range);
        RedisCommandBuilder.notNullLimit(limit);
        RedisCommandBuilder.notNull(channel);
        CommandArgs args = new CommandArgs(this.codec);
        RedisCommandBuilder.addLimit(args.addKey(key).add(RedisCommandBuilder.max(range)).add(RedisCommandBuilder.min(range)), limit);
        return this.createCommand(CommandType.ZREVRANGEBYSCORE, new ValueStreamingOutput(this.codec, channel), args);
    }

    Command<K, V, List<ScoredValue<V>>> zrevrangebyscoreWithScores(K key, double max, double min) {
        return this.zrevrangebyscoreWithScores(key, LettuceStrings.string(max), LettuceStrings.string(min));
    }

    Command<K, V, List<ScoredValue<V>>> zrevrangebyscoreWithScores(K key, String max, String min) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullMinMax(min, max);
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(max).add(min).add(CommandKeyword.WITHSCORES);
        return this.createCommand(CommandType.ZREVRANGEBYSCORE, new ScoredValueListOutput(this.codec), args);
    }

    Command<K, V, List<ScoredValue<V>>> zrevrangebyscoreWithScores(K key, double max, double min, long offset, long count) {
        return this.zrevrangebyscoreWithScores(key, LettuceStrings.string(max), LettuceStrings.string(min), offset, count);
    }

    Command<K, V, List<ScoredValue<V>>> zrevrangebyscoreWithScores(K key, String max, String min, long offset, long count) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullMinMax(min, max);
        CommandArgs args = new CommandArgs(this.codec);
        RedisCommandBuilder.addLimit(args.addKey(key).add(max).add(min).add(CommandKeyword.WITHSCORES), Limit.create(offset, count));
        return this.createCommand(CommandType.ZREVRANGEBYSCORE, new ScoredValueListOutput(this.codec), args);
    }

    Command<K, V, List<ScoredValue<V>>> zrevrangebyscoreWithScores(K key, Range<? extends Number> range, Limit limit) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullRange(range);
        RedisCommandBuilder.notNullLimit(limit);
        CommandArgs args = new CommandArgs(this.codec);
        RedisCommandBuilder.addLimit(args.addKey(key).add(RedisCommandBuilder.max(range)).add(RedisCommandBuilder.min(range)).add(CommandKeyword.WITHSCORES), limit);
        return this.createCommand(CommandType.ZREVRANGEBYSCORE, new ScoredValueListOutput(this.codec), args);
    }

    Command<K, V, Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double max, double min) {
        return this.zrevrangebyscoreWithScores(channel, key, LettuceStrings.string(max), LettuceStrings.string(min));
    }

    Command<K, V, Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String max, String min) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullMinMax(min, max);
        RedisCommandBuilder.notNull(channel);
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(max).add(min).add(CommandKeyword.WITHSCORES);
        return this.createCommand(CommandType.ZREVRANGEBYSCORE, new ScoredValueStreamingOutput(this.codec, channel), args);
    }

    Command<K, V, Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double max, double min, long offset, long count) {
        RedisCommandBuilder.notNullKey(key);
        LettuceAssert.notNull((Object)min, "Min must not be null");
        LettuceAssert.notNull((Object)max, "Max must not be null");
        RedisCommandBuilder.notNull(channel);
        return this.zrevrangebyscoreWithScores(channel, key, LettuceStrings.string(max), LettuceStrings.string(min), offset, count);
    }

    Command<K, V, Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String max, String min, long offset, long count) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullMinMax(min, max);
        RedisCommandBuilder.notNull(channel);
        CommandArgs args = new CommandArgs(this.codec);
        RedisCommandBuilder.addLimit(args.addKey(key).add(max).add(min).add(CommandKeyword.WITHSCORES), Limit.create(offset, count));
        return this.createCommand(CommandType.ZREVRANGEBYSCORE, new ScoredValueStreamingOutput(this.codec, channel), args);
    }

    Command<K, V, Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, Range<? extends Number> range, Limit limit) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNullRange(range);
        RedisCommandBuilder.notNullLimit(limit);
        RedisCommandBuilder.notNull(channel);
        CommandArgs args = new CommandArgs(this.codec);
        RedisCommandBuilder.addLimit(args.addKey(key).add(RedisCommandBuilder.max(range)).add(RedisCommandBuilder.min(range)).add(CommandKeyword.WITHSCORES), limit);
        return this.createCommand(CommandType.ZREVRANGEBYSCORE, new ScoredValueStreamingOutput(this.codec, channel), args);
    }

    Command<K, V, Long> zrevrank(K key, V member) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.ZREVRANK, new IntegerOutput(this.codec), key, member);
    }

    Command<K, V, ScoredValueScanCursor<V>> zscan(K key) {
        RedisCommandBuilder.notNullKey(key);
        return this.zscan(key, ScanCursor.INITIAL, null);
    }

    Command<K, V, ScoredValueScanCursor<V>> zscan(K key, ScanCursor scanCursor) {
        RedisCommandBuilder.notNullKey(key);
        return this.zscan(key, scanCursor, null);
    }

    Command<K, V, ScoredValueScanCursor<V>> zscan(K key, ScanArgs scanArgs) {
        RedisCommandBuilder.notNullKey(key);
        return this.zscan(key, ScanCursor.INITIAL, scanArgs);
    }

    Command<K, V, ScoredValueScanCursor<V>> zscan(K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        RedisCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key);
        this.scanArgs(scanCursor, scanArgs, args);
        ScoredValueScanOutput output = new ScoredValueScanOutput(this.codec);
        return this.createCommand(CommandType.ZSCAN, output, args);
    }

    Command<K, V, StreamScanCursor> zscanStreaming(ScoredValueStreamingChannel<V> channel, K key) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNull(channel);
        return this.zscanStreaming(channel, key, ScanCursor.INITIAL, null);
    }

    Command<K, V, StreamScanCursor> zscanStreaming(ScoredValueStreamingChannel<V> channel, K key, ScanCursor scanCursor) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNull(channel);
        return this.zscanStreaming(channel, key, scanCursor, null);
    }

    Command<K, V, StreamScanCursor> zscanStreaming(ScoredValueStreamingChannel<V> channel, K key, ScanArgs scanArgs) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNull(channel);
        return this.zscanStreaming(channel, key, ScanCursor.INITIAL, scanArgs);
    }

    Command<K, V, StreamScanCursor> zscanStreaming(ScoredValueStreamingChannel<V> channel, K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        RedisCommandBuilder.notNullKey(key);
        RedisCommandBuilder.notNull(channel);
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key);
        this.scanArgs(scanCursor, scanArgs, args);
        ScoredValueScanStreamingOutput output = new ScoredValueScanStreamingOutput(this.codec, channel);
        return this.createCommand(CommandType.ZSCAN, output, args);
    }

    Command<K, V, Double> zscore(K key, V member) {
        RedisCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.ZSCORE, new DoubleOutput(this.codec), key, member);
    }

    Command<K, V, List<V>> zunion(K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        return this.zunion(new ZAggregateArgs(), keys);
    }

    Command<K, V, List<V>> zunion(ZAggregateArgs aggregateArgs, K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec);
        args.add(keys.length).addKeys(keys);
        aggregateArgs.build(args);
        return this.createCommand(CommandType.ZUNION, new ValueListOutput(this.codec), args);
    }

    Command<K, V, List<ScoredValue<V>>> zunionWithScores(K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        return this.zunionWithScores(new ZAggregateArgs(), keys);
    }

    Command<K, V, List<ScoredValue<V>>> zunionWithScores(ZAggregateArgs aggregateArgs, K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec);
        args.add(keys.length).addKeys(keys).add(CommandKeyword.WITHSCORES);
        aggregateArgs.build(args);
        return this.createCommand(CommandType.ZUNION, new ScoredValueListOutput(this.codec), args);
    }

    Command<K, V, Long> zunionstore(K destination, K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        LettuceAssert.notNull(destination, "Destination must not be null");
        return this.zunionstore(destination, new ZAggregateArgs(), keys);
    }

    Command<K, V, Long> zunionstore(K destination, ZAggregateArgs aggregateArgs, K ... keys) {
        RedisCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(destination).add(keys.length).addKeys(keys);
        aggregateArgs.build(args);
        return this.createCommand(CommandType.ZUNIONSTORE, new IntegerOutput(this.codec), args);
    }

    private boolean allElementsInstanceOf(Object[] objects, Class<?> expectedAssignableType) {
        for (Object object : objects) {
            if (expectedAssignableType.isAssignableFrom(object.getClass())) continue;
            return false;
        }
        return true;
    }

    private byte[] maxValue(Range<? extends V> range) {
        Range.Boundary<V> upper = range.getUpper();
        if (upper.getValue() == null) {
            return PLUS_BYTES;
        }
        ByteBuffer encoded = this.codec.encodeValue(upper.getValue());
        ByteBuffer allocated = ByteBuffer.allocate(encoded.remaining() + 1);
        allocated.put(upper.isIncluding() ? (byte)91 : 40).put(encoded);
        return allocated.array();
    }

    private byte[] minValue(Range<? extends V> range) {
        Range.Boundary<V> lower = range.getLower();
        if (lower.getValue() == null) {
            return MINUS_BYTES;
        }
        ByteBuffer encoded = this.codec.encodeValue(lower.getValue());
        ByteBuffer allocated = ByteBuffer.allocate(encoded.remaining() + 1);
        allocated.put(lower.isIncluding() ? (byte)91 : 40).put(encoded);
        return allocated.array();
    }

    static void notNull(ScoredValueStreamingChannel<?> channel) {
        LettuceAssert.notNull(channel, "ScoredValueStreamingChannel must not be null");
    }

    static void notNull(KeyStreamingChannel<?> channel) {
        LettuceAssert.notNull(channel, "KeyValueStreamingChannel must not be null");
    }

    static void notNull(ValueStreamingChannel<?> channel) {
        LettuceAssert.notNull(channel, "ValueStreamingChannel must not be null");
    }

    static void notNull(KeyValueStreamingChannel<?, ?> channel) {
        LettuceAssert.notNull(channel, "KeyValueStreamingChannel must not be null");
    }

    static void notNullMinMax(String min, String max) {
        LettuceAssert.notNull((Object)min, "Min must not be null");
        LettuceAssert.notNull((Object)max, "Max must not be null");
    }

    private static void addLimit(CommandArgs<?, ?> args, Limit limit) {
        if (limit.isLimited()) {
            args.add(CommandKeyword.LIMIT).add(limit.getOffset()).add(limit.getCount());
        }
    }

    private static void assertNodeId(String nodeId) {
        LettuceAssert.notNull((Object)nodeId, "NodeId must not be null");
        LettuceAssert.notEmpty((CharSequence)nodeId, "NodeId must not be empty");
    }

    private static String max(Range<? extends Number> range) {
        Range.Boundary<? extends Number> upper = range.getUpper();
        if (upper.getValue() == null || upper.getValue() instanceof Double && upper.getValue().doubleValue() == Double.POSITIVE_INFINITY) {
            return "+inf";
        }
        if (!upper.isIncluding()) {
            return "(" + upper.getValue();
        }
        return upper.getValue().toString();
    }

    private static String min(Range<? extends Number> range) {
        Range.Boundary<? extends Number> lower = range.getLower();
        if (lower.getValue() == null || lower.getValue() instanceof Double && lower.getValue().doubleValue() == Double.NEGATIVE_INFINITY) {
            return "-inf";
        }
        if (!lower.isIncluding()) {
            return "(" + lower.getValue();
        }
        return lower.getValue().toString();
    }

    private static void notEmpty(Object[] keys) {
        LettuceAssert.notNull((Object)keys, "Keys must not be null");
        LettuceAssert.notEmpty(keys, "Keys must not be empty");
    }

    private static void notEmptySlots(int[] slots) {
        LettuceAssert.notNull((Object)slots, "Slots must not be null");
        LettuceAssert.notEmpty(slots, "Slots must not be empty");
    }

    private static void notEmptyValues(Object[] values) {
        LettuceAssert.notNull((Object)values, "Values must not be null");
        LettuceAssert.notEmpty(values, "Values must not be empty");
    }

    private static void notNullKey(Object key) {
        LettuceAssert.notNull(key, "Key must not be null");
    }

    private static void notNullLimit(Limit limit) {
        LettuceAssert.notNull((Object)limit, "Limit must not be null");
    }

    private static void notNullRange(Range<?> range) {
        LettuceAssert.notNull(range, "Range must not be null");
    }

    private static void notEmptyRanges(Range<?>[] ranges) {
        LettuceAssert.notEmpty((Object[])ranges, "Ranges must not be null");
    }
}

