/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.ConnectionEvents;
import io.lettuce.core.RedisChannelHandler;
import io.lettuce.core.event.EventBus;
import io.lettuce.core.event.connection.ConnectionActivatedEvent;
import io.lettuce.core.event.connection.ConnectionDeactivatedEvent;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.local.LocalAddress;
import java.net.SocketAddress;

class ConnectionEventTrigger
extends ChannelInboundHandlerAdapter {
    private final ConnectionEvents connectionEvents;
    private final RedisChannelHandler<?, ?> connection;
    private final EventBus eventBus;

    ConnectionEventTrigger(ConnectionEvents connectionEvents, RedisChannelHandler<?, ?> connection, EventBus eventBus) {
        this.connectionEvents = connectionEvents;
        this.connection = connection;
        this.eventBus = eventBus;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.connectionEvents.fireEventRedisConnected(this.connection, ctx.channel().remoteAddress());
        this.eventBus.publish(new ConnectionActivatedEvent(ConnectionEventTrigger.local(ctx), ConnectionEventTrigger.remote(ctx)));
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.connectionEvents.fireEventRedisDisconnected(this.connection);
        this.eventBus.publish(new ConnectionDeactivatedEvent(ConnectionEventTrigger.local(ctx), ConnectionEventTrigger.remote(ctx)));
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.connectionEvents.fireEventRedisExceptionCaught(this.connection, cause);
        super.exceptionCaught(ctx, cause);
    }

    static SocketAddress remote(ChannelHandlerContext ctx) {
        if (ctx.channel() != null && ctx.channel().remoteAddress() != null) {
            return ctx.channel().remoteAddress();
        }
        return new LocalAddress("unknown");
    }

    static SocketAddress local(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        if (channel != null && channel.localAddress() != null) {
            return channel.localAddress();
        }
        return LocalAddress.ANY;
    }
}

