/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.api.coroutines;

import io.lettuce.core.ExperimentalLettuceCoroutinesApi;
import io.lettuce.core.KeyValue;
import io.lettuce.core.MapScanCursor;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.api.coroutines.RedisHashCoroutinesCommands;
import io.lettuce.core.api.reactive.RedisHashReactiveCommands;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.reactive.AwaitKt;
import kotlinx.coroutines.reactive.ReactiveFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0001\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004B\u0019\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J/\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00028\u00002\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\f\"\u00028\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ#\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00028\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J#\u0010\u0012\u001a\u0004\u0018\u00018\u00012\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00028\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J'\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00150\u00142\u0006\u0010\n\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J+\u0010\u0017\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\tH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J+\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u001bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ\u001b\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u00142\u0006\u0010\n\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\u001b\u0010\u001e\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00028\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ;\u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00150\u00142\u0006\u0010\n\u001a\u00028\u00002\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\f\"\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010!J/\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\n\u001a\u00028\u00002\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010%H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J'\u0010'\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010(2\u0006\u0010\n\u001a\u00028\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ/\u0010'\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010(2\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010)\u001a\u00020*H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J/\u0010'\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010(2\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010,\u001a\u00020-H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010.J7\u0010'\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010(2\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010,\u001a\u00020-2\u0006\u0010)\u001a\u00020*H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010/J+\u00100\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u00101\u001a\u00028\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00102J/\u00100\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00028\u00002\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010%H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J+\u00103\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u00101\u001a\u00028\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00102J#\u00104\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00028\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u001b\u00105\u001a\b\u0012\u0004\u0012\u00028\u00010\u00142\u0006\u0010\n\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00066"}, d2={"Lio/lettuce/core/api/coroutines/RedisHashCoroutinesCommandsImpl;", "K", "", "V", "Lio/lettuce/core/api/coroutines/RedisHashCoroutinesCommands;", "ops", "Lio/lettuce/core/api/reactive/RedisHashReactiveCommands;", "(Lio/lettuce/core/api/reactive/RedisHashReactiveCommands;)V", "hdel", "", "key", "fields", "", "(Ljava/lang/Object;[Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hexists", "", "field", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hget", "hgetall", "Lkotlinx/coroutines/flow/Flow;", "Lio/lettuce/core/KeyValue;", "(Ljava/lang/Object;)Lkotlinx/coroutines/flow/Flow;", "hincrby", "amount", "(Ljava/lang/Object;Ljava/lang/Object;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hincrbyfloat", "", "(Ljava/lang/Object;Ljava/lang/Object;DLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hkeys", "hlen", "(Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hmget", "(Ljava/lang/Object;[Ljava/lang/Object;)Lkotlinx/coroutines/flow/Flow;", "hmset", "", "map", "", "(Ljava/lang/Object;Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hscan", "Lio/lettuce/core/MapScanCursor;", "scanArgs", "Lio/lettuce/core/ScanArgs;", "(Ljava/lang/Object;Lio/lettuce/core/ScanArgs;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "scanCursor", "Lio/lettuce/core/ScanCursor;", "(Ljava/lang/Object;Lio/lettuce/core/ScanCursor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Ljava/lang/Object;Lio/lettuce/core/ScanCursor;Lio/lettuce/core/ScanArgs;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hset", "value", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hsetnx", "hstrlen", "hvals", "lettuce-core"})
@ExperimentalLettuceCoroutinesApi
public final class RedisHashCoroutinesCommandsImpl<K, V>
implements RedisHashCoroutinesCommands<K, V> {
    private final RedisHashReactiveCommands<K, V> ops;

    @Override
    @Nullable
    public Object hdel(@NotNull K key, @NotNull K[] fields, @NotNull Continuation<? super Long> $completion) {
        Mono<Long> mono = this.ops.hdel(key, Arrays.copyOf(fields, fields.length));
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"ops.hdel(key, *fields)");
        return AwaitKt.awaitFirstOrNull((Publisher)((Publisher)mono), $completion);
    }

    @Override
    @Nullable
    public Object hexists(@NotNull K key, @NotNull K field, @NotNull Continuation<? super Boolean> $completion) {
        Mono<Boolean> mono = this.ops.hexists(key, field);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"ops.hexists(key, field)");
        return AwaitKt.awaitFirstOrNull((Publisher)((Publisher)mono), $completion);
    }

    @Override
    @Nullable
    public Object hget(@NotNull K key, @NotNull K field, @NotNull Continuation<? super V> $completion) {
        Mono<V> mono = this.ops.hget(key, field);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"ops.hget(key, field)");
        return AwaitKt.awaitFirstOrNull((Publisher)((Publisher)mono), $completion);
    }

    @Override
    @Nullable
    public Object hincrby(@NotNull K key, @NotNull K field, long amount, @NotNull Continuation<? super Long> $completion) {
        Mono<Long> mono = this.ops.hincrby(key, field, amount);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"ops.hincrby(key, field, amount)");
        return AwaitKt.awaitFirstOrNull((Publisher)((Publisher)mono), $completion);
    }

    @Override
    @Nullable
    public Object hincrbyfloat(@NotNull K key, @NotNull K field, double amount, @NotNull Continuation<? super Double> $completion) {
        Mono<Double> mono = this.ops.hincrbyfloat(key, field, amount);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"ops.hincrbyfloat(key, field, amount)");
        return AwaitKt.awaitFirstOrNull((Publisher)((Publisher)mono), $completion);
    }

    @Override
    @NotNull
    public Flow<KeyValue<K, V>> hgetall(@NotNull K key) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        Flux<KeyValue<K, V>> flux = this.ops.hgetall(key);
        Intrinsics.checkExpressionValueIsNotNull(flux, (String)"ops.hgetall(key)");
        return ReactiveFlowKt.asFlow((Publisher)((Publisher)flux));
    }

    @Override
    @NotNull
    public Flow<K> hkeys(@NotNull K key) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        Flux<K> flux = this.ops.hkeys(key);
        Intrinsics.checkExpressionValueIsNotNull(flux, (String)"ops.hkeys(key)");
        return ReactiveFlowKt.asFlow((Publisher)((Publisher)flux));
    }

    @Override
    @Nullable
    public Object hlen(@NotNull K key, @NotNull Continuation<? super Long> $completion) {
        Mono<Long> mono = this.ops.hlen(key);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"ops.hlen(key)");
        return AwaitKt.awaitFirstOrNull((Publisher)((Publisher)mono), $completion);
    }

    @Override
    @NotNull
    public Flow<KeyValue<K, V>> hmget(@NotNull K key, K ... fields) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        Intrinsics.checkParameterIsNotNull(fields, (String)"fields");
        Flux<KeyValue<K, V>> flux = this.ops.hmget(key, Arrays.copyOf(fields, fields.length));
        Intrinsics.checkExpressionValueIsNotNull(flux, (String)"ops.hmget(key, *fields)");
        return ReactiveFlowKt.asFlow((Publisher)((Publisher)flux));
    }

    @Override
    @Nullable
    public Object hmset(@NotNull K key, @NotNull Map<K, ? extends V> map, @NotNull Continuation<? super String> $completion) {
        Mono<String> mono = this.ops.hmset(key, map);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"ops.hmset(key, map)");
        return AwaitKt.awaitFirstOrNull((Publisher)((Publisher)mono), $completion);
    }

    @Override
    @Nullable
    public Object hscan(@NotNull K key, @NotNull Continuation<? super MapScanCursor<K, V>> $completion) {
        Mono<MapScanCursor<K, V>> mono = this.ops.hscan(key);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"ops.hscan(key)");
        return AwaitKt.awaitFirstOrNull((Publisher)((Publisher)mono), $completion);
    }

    @Override
    @Nullable
    public Object hscan(@NotNull K key, @NotNull ScanArgs scanArgs, @NotNull Continuation<? super MapScanCursor<K, V>> $completion) {
        Mono<MapScanCursor<K, V>> mono = this.ops.hscan(key, scanArgs);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"ops.hscan(key, scanArgs)");
        return AwaitKt.awaitFirstOrNull((Publisher)((Publisher)mono), $completion);
    }

    @Override
    @Nullable
    public Object hscan(@NotNull K key, @NotNull ScanCursor scanCursor, @NotNull ScanArgs scanArgs, @NotNull Continuation<? super MapScanCursor<K, V>> $completion) {
        Mono<MapScanCursor<K, V>> mono = this.ops.hscan(key, scanCursor, scanArgs);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"ops.hscan(key, scanCursor, scanArgs)");
        return AwaitKt.awaitFirstOrNull((Publisher)((Publisher)mono), $completion);
    }

    @Override
    @Nullable
    public Object hscan(@NotNull K key, @NotNull ScanCursor scanCursor, @NotNull Continuation<? super MapScanCursor<K, V>> $completion) {
        Mono<MapScanCursor<K, V>> mono = this.ops.hscan(key, scanCursor);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"ops.hscan(key, scanCursor)");
        return AwaitKt.awaitFirstOrNull((Publisher)((Publisher)mono), $completion);
    }

    @Override
    @Nullable
    public Object hset(@NotNull K key, @NotNull K field, @NotNull V value, @NotNull Continuation<? super Boolean> $completion) {
        Mono<Boolean> mono = this.ops.hset(key, field, value);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"ops.hset(key, field, value)");
        return AwaitKt.awaitFirstOrNull((Publisher)((Publisher)mono), $completion);
    }

    @Override
    @Nullable
    public Object hset(@NotNull K key, @NotNull Map<K, ? extends V> map, @NotNull Continuation<? super Long> $completion) {
        Mono<Long> mono = this.ops.hset(key, map);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"ops.hset(key, map)");
        return AwaitKt.awaitFirstOrNull((Publisher)((Publisher)mono), $completion);
    }

    @Override
    @Nullable
    public Object hsetnx(@NotNull K key, @NotNull K field, @NotNull V value, @NotNull Continuation<? super Boolean> $completion) {
        Mono<Boolean> mono = this.ops.hsetnx(key, field, value);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"ops.hsetnx(key, field, value)");
        return AwaitKt.awaitFirstOrNull((Publisher)((Publisher)mono), $completion);
    }

    @Override
    @Nullable
    public Object hstrlen(@NotNull K key, @NotNull K field, @NotNull Continuation<? super Long> $completion) {
        Mono<Long> mono = this.ops.hstrlen(key, field);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"ops.hstrlen(key, field)");
        return AwaitKt.awaitFirstOrNull((Publisher)((Publisher)mono), $completion);
    }

    @Override
    @NotNull
    public Flow<V> hvals(@NotNull K key) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        Flux<V> flux = this.ops.hvals(key);
        Intrinsics.checkExpressionValueIsNotNull(flux, (String)"ops.hvals(key)");
        return ReactiveFlowKt.asFlow((Publisher)((Publisher)flux));
    }

    public RedisHashCoroutinesCommandsImpl(@NotNull RedisHashReactiveCommands<K, V> ops) {
        Intrinsics.checkParameterIsNotNull(ops, (String)"ops");
        this.ops = ops;
    }
}

