/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster.models.partitions;

import io.lettuce.core.RedisURI;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.models.role.RedisInstance;
import io.lettuce.core.models.role.RedisNodeDescription;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class RedisClusterNode
implements Serializable,
RedisNodeDescription {
    private RedisURI uri;
    private String nodeId;
    private boolean connected;
    private String slaveOf;
    private long pingSentTimestamp;
    private long pongReceivedTimestamp;
    private long configEpoch;
    private BitSet slots;
    private final Set<NodeFlag> flags = EnumSet.noneOf(NodeFlag.class);
    private final List<RedisURI> aliases = new ArrayList<RedisURI>();

    public RedisClusterNode() {
    }

    public RedisClusterNode(RedisURI uri, String nodeId, boolean connected, String slaveOf, long pingSentTimestamp, long pongReceivedTimestamp, long configEpoch, List<Integer> slots, Set<NodeFlag> flags) {
        this.uri = uri;
        this.nodeId = nodeId;
        this.connected = connected;
        this.slaveOf = slaveOf;
        this.pingSentTimestamp = pingSentTimestamp;
        this.pongReceivedTimestamp = pongReceivedTimestamp;
        this.configEpoch = configEpoch;
        this.setSlotBits(slots);
        this.setFlags(flags);
    }

    public RedisClusterNode(RedisClusterNode redisClusterNode) {
        LettuceAssert.notNull(redisClusterNode, "RedisClusterNode must not be null");
        this.uri = redisClusterNode.uri;
        this.nodeId = redisClusterNode.nodeId;
        this.connected = redisClusterNode.connected;
        this.slaveOf = redisClusterNode.slaveOf;
        this.pingSentTimestamp = redisClusterNode.pingSentTimestamp;
        this.pongReceivedTimestamp = redisClusterNode.pongReceivedTimestamp;
        this.configEpoch = redisClusterNode.configEpoch;
        this.aliases.addAll(redisClusterNode.aliases);
        if (redisClusterNode.slots != null && !redisClusterNode.slots.isEmpty()) {
            this.slots = new BitSet(16384);
            this.slots.or(redisClusterNode.slots);
        }
        this.setFlags(redisClusterNode.flags);
    }

    public static RedisClusterNode of(String nodeId) {
        LettuceAssert.notNull(nodeId, "NodeId must not be null");
        RedisClusterNode redisClusterNode = new RedisClusterNode();
        redisClusterNode.setNodeId(nodeId);
        return redisClusterNode;
    }

    public RedisClusterNode clone() {
        return new RedisClusterNode(this);
    }

    @Override
    public RedisURI getUri() {
        return this.uri;
    }

    public void setUri(RedisURI uri) {
        LettuceAssert.notNull(uri, "RedisURI must not be null");
        this.uri = uri;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        LettuceAssert.notNull(nodeId, "NodeId must not be null");
        this.nodeId = nodeId;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public String getSlaveOf() {
        return this.slaveOf;
    }

    public void setSlaveOf(String slaveOf) {
        this.slaveOf = slaveOf;
    }

    public long getPingSentTimestamp() {
        return this.pingSentTimestamp;
    }

    public void setPingSentTimestamp(long pingSentTimestamp) {
        this.pingSentTimestamp = pingSentTimestamp;
    }

    public long getPongReceivedTimestamp() {
        return this.pongReceivedTimestamp;
    }

    public void setPongReceivedTimestamp(long pongReceivedTimestamp) {
        this.pongReceivedTimestamp = pongReceivedTimestamp;
    }

    public long getConfigEpoch() {
        return this.configEpoch;
    }

    public void setConfigEpoch(long configEpoch) {
        this.configEpoch = configEpoch;
    }

    public List<Integer> getSlots() {
        if (this.slots == null || this.slots.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < 16384; ++i) {
            if (!this.slots.get(i)) continue;
            slots.add(i);
        }
        return slots;
    }

    public void setSlots(List<Integer> slots) {
        LettuceAssert.notNull(slots, "Slots must not be null");
        this.setSlotBits(slots);
    }

    private void setSlotBits(List<Integer> slots) {
        if (slots.isEmpty() && this.slots == null) {
            return;
        }
        if (this.slots == null) {
            this.slots = new BitSet(16384);
        }
        this.slots.clear();
        for (Integer slot : slots) {
            this.slots.set(slot);
        }
    }

    public boolean hasSameSlotsAs(RedisClusterNode other) {
        if (this.slots == null || other.slots == null) {
            return false;
        }
        return this.slots.equals(other.slots);
    }

    public Set<NodeFlag> getFlags() {
        return this.flags;
    }

    public void setFlags(Set<NodeFlag> flags) {
        this.flags.clear();
        this.flags.addAll(flags);
    }

    public boolean is(NodeFlag nodeFlag) {
        return this.getFlags().contains((Object)nodeFlag);
    }

    public void addAlias(RedisURI alias) {
        LettuceAssert.notNull(alias, "Alias URI must not be null");
        this.aliases.add(alias);
    }

    public List<RedisURI> getAliases() {
        return this.aliases;
    }

    public boolean hasSlot(int slot) {
        return slot <= 16384 && this.slots != null && this.slots.get(slot);
    }

    @Override
    public RedisInstance.Role getRole() {
        return this.is(NodeFlag.MASTER) ? RedisInstance.Role.MASTER : RedisInstance.Role.SLAVE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RedisClusterNode)) {
            return false;
        }
        RedisClusterNode that = (RedisClusterNode)o;
        return !(this.nodeId != null ? !this.nodeId.equals(that.nodeId) : that.nodeId != null);
    }

    public int hashCode() {
        return 31 * (this.nodeId != null ? this.nodeId.hashCode() : 0);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [uri=").append(this.uri);
        sb.append(", nodeId='").append(this.nodeId).append('\'');
        sb.append(", connected=").append(this.connected);
        sb.append(", slaveOf='").append(this.slaveOf).append('\'');
        sb.append(", pingSentTimestamp=").append(this.pingSentTimestamp);
        sb.append(", pongReceivedTimestamp=").append(this.pongReceivedTimestamp);
        sb.append(", configEpoch=").append(this.configEpoch);
        sb.append(", flags=").append(this.flags);
        sb.append(", aliases=").append(this.aliases);
        if (this.slots != null) {
            sb.append(", slot count=").append(this.slots.cardinality());
        }
        sb.append(']');
        return sb.toString();
    }

    public static enum NodeFlag {
        NOFLAGS,
        MYSELF,
        SLAVE,
        MASTER,
        EVENTUAL_FAIL,
        FAIL,
        HANDSHAKE,
        NOADDR;

    }
}

