/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.dynamic.output;

import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.dynamic.output.CommandOutputFactory;
import io.lettuce.core.dynamic.output.CommandOutputFactoryResolver;
import io.lettuce.core.dynamic.output.OutputSelector;
import io.lettuce.core.internal.LettuceAssert;

public class CodecAwareOutputFactoryResolver
implements CommandOutputFactoryResolver {
    private final CommandOutputFactoryResolver delegate;
    private final RedisCodec<?, ?> redisCodec;

    public CodecAwareOutputFactoryResolver(CommandOutputFactoryResolver delegate, RedisCodec<?, ?> redisCodec) {
        LettuceAssert.notNull(delegate, "CommandOutputFactoryResolver delegate must not be null");
        LettuceAssert.notNull(redisCodec, "RedisCodec must not be null");
        this.delegate = delegate;
        this.redisCodec = redisCodec;
    }

    @Override
    public CommandOutputFactory resolveCommandOutput(OutputSelector outputSelector) {
        return this.delegate.resolveCommandOutput(new OutputSelector(outputSelector.getOutputType(), this.redisCodec));
    }

    @Override
    public CommandOutputFactory resolveStreamingCommandOutput(OutputSelector outputSelector) {
        return this.delegate.resolveStreamingCommandOutput(new OutputSelector(outputSelector.getOutputType(), this.redisCodec));
    }
}

