/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.masterslave;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisException;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.RedisURI;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.masterslave.MasterSlaveUtils;
import io.lettuce.core.masterslave.RedisMasterSlaveNode;
import io.lettuce.core.masterslave.TopologyProvider;
import io.lettuce.core.models.role.RedisInstance;
import io.lettuce.core.models.role.RedisNodeDescription;
import io.lettuce.core.sentinel.api.StatefulRedisSentinelConnection;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

public class SentinelTopologyProvider
implements TopologyProvider {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SentinelTopologyProvider.class);
    private final String masterId;
    private final RedisClient redisClient;
    private final RedisURI sentinelUri;
    private final Duration timeout;

    public SentinelTopologyProvider(String masterId, RedisClient redisClient, RedisURI sentinelUri) {
        LettuceAssert.notEmpty(masterId, "MasterId must not be empty");
        LettuceAssert.notNull(redisClient, "RedisClient must not be null");
        LettuceAssert.notNull(sentinelUri, "Sentinel URI must not be null");
        this.masterId = masterId;
        this.redisClient = redisClient;
        this.sentinelUri = sentinelUri;
        this.timeout = sentinelUri.getTimeout();
    }

    @Override
    public List<RedisNodeDescription> getNodes() {
        logger.debug("lookup topology for masterId {}", (Object)this.masterId);
        try (StatefulRedisSentinelConnection<String, String> connection = this.redisClient.connectSentinel(MasterSlaveUtils.CODEC, this.sentinelUri);){
            RedisFuture<Map<String, String>> masterFuture = connection.async().master(this.masterId);
            RedisFuture<List<Map<String, String>>> slavesFuture = connection.async().slaves(this.masterId);
            ArrayList<RedisNodeDescription> result = new ArrayList<RedisNodeDescription>();
            try {
                Map master = (Map)masterFuture.get(this.timeout.toNanos(), TimeUnit.NANOSECONDS);
                List slaves = (List)slavesFuture.get(this.timeout.toNanos(), TimeUnit.NANOSECONDS);
                result.add(this.toNode(master, RedisInstance.Role.MASTER));
                result.addAll(slaves.stream().filter(SentinelTopologyProvider::isAvailable).map(map -> this.toNode((Map<String, String>)map, RedisInstance.Role.SLAVE)).collect(Collectors.toList()));
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new RedisException(e);
            }
            ArrayList<RedisNodeDescription> arrayList = result;
            return arrayList;
        }
    }

    private static boolean isAvailable(Map<String, String> map) {
        String flags = map.get("flags");
        return flags == null || !flags.contains("s_down") && !flags.contains("o_down") && !flags.contains("disconnected");
    }

    private RedisNodeDescription toNode(Map<String, String> map, RedisInstance.Role role) {
        String ip = map.get("ip");
        String port = map.get("port");
        return new RedisMasterSlaveNode(ip, Integer.parseInt(port), this.sentinelUri, role);
    }
}

