/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.util;

import io.leangen.graphql.metadata.strategy.type.TypeInfoGenerator;
import io.leangen.graphql.metadata.strategy.value.ValueMapperFactory;
import io.leangen.graphql.metadata.strategy.value.gson.GsonValueMapperFactory;
import io.leangen.graphql.metadata.strategy.value.jackson.JacksonValueMapperFactory;
import io.leangen.graphql.module.Module;
import io.leangen.graphql.module.common.gson.GsonModule;
import io.leangen.graphql.module.common.jackson.JacksonModule;
import io.leangen.graphql.util.ClassUtils;
import java.util.ArrayList;
import java.util.List;

public class Defaults {
    private static final IllegalStateException noJsonLib = new IllegalStateException("No JSON deserialization library found on classpath. A compatible version of either Jackson or Gson must be available or a custom ValueMapperFactory must be provided");

    private static JsonLib jsonLibrary() {
        for (JsonLib jsonLib : JsonLib.values()) {
            if (!Defaults.isAvailable(jsonLib)) continue;
            return jsonLib;
        }
        throw noJsonLib;
    }

    private static boolean isAvailable(JsonLib jsonLib) {
        try {
            ClassUtils.forName(jsonLib.requiredClass);
            return true;
        }
        catch (ClassNotFoundException ge) {
            return false;
        }
    }

    public static ValueMapperFactory<?> valueMapperFactory() {
        switch (Defaults.jsonLibrary()) {
            case GSON: {
                return GsonValueMapperFactory.builder().build();
            }
            case JACKSON: {
                return JacksonValueMapperFactory.builder().build();
            }
        }
        throw noJsonLib;
    }

    public static ValueMapperFactory<?> valueMapperFactory(TypeInfoGenerator typeInfoGenerator) {
        switch (Defaults.jsonLibrary()) {
            case GSON: {
                return GsonValueMapperFactory.builder().withTypeInfoGenerator(typeInfoGenerator).build();
            }
            case JACKSON: {
                return JacksonValueMapperFactory.builder().withTypeInfoGenerator(typeInfoGenerator).build();
            }
        }
        throw noJsonLib;
    }

    public static List<Module> modules() {
        ArrayList<Module> defaultModules = new ArrayList<Module>(2);
        if (Defaults.isAvailable(JsonLib.JACKSON)) {
            defaultModules.add(new JacksonModule());
        }
        if (Defaults.isAvailable(JsonLib.GSON)) {
            defaultModules.add(new GsonModule());
        }
        return defaultModules;
    }

    private static enum JsonLib {
        JACKSON("com.fasterxml.jackson.databind.ObjectMapper"),
        GSON("com.google.gson.Gson");

        public final String requiredClass;

        private JsonLib(String requiredClass) {
            this.requiredClass = requiredClass;
        }
    }
}

