/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata.strategy.value.jackson;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import io.leangen.graphql.annotations.GraphQLEnumValue;
import io.leangen.graphql.metadata.messages.MessageBundle;
import io.leangen.graphql.metadata.strategy.value.InputFieldInfoGenerator;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.Utils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class AnnotationIntrospector
extends JacksonAnnotationIntrospector {
    private final MessageBundle messageBundle;
    private final Map<Type, List<NamedType>> typeMap;
    private final InputFieldInfoGenerator inputInfoGen = new InputFieldInfoGenerator();
    private static final TypeResolverBuilder<?> typeResolverBuilder = new StdTypeResolverBuilder().init(JsonTypeInfo.Id.NAME, null).inclusion(JsonTypeInfo.As.PROPERTY).typeProperty("_type_");

    AnnotationIntrospector(Map<Type, List<NamedType>> typeMap, MessageBundle messageBundle) {
        this.typeMap = typeMap == null ? Collections.emptyMap() : Collections.unmodifiableMap(typeMap);
        this.messageBundle = messageBundle;
    }

    public PropertyName findNameForDeserialization(Annotated annotated) {
        return this.inputInfoGen.getName(this.getAnnotatedCandidates(annotated), this.messageBundle).map(PropertyName::construct).orElse(super.findNameForDeserialization(annotated));
    }

    public PropertyName findNameForSerialization(Annotated annotated) {
        return this.inputInfoGen.getName(this.getAnnotatedCandidates(annotated), this.messageBundle).map(PropertyName::construct).orElse(super.findNameForSerialization(annotated));
    }

    public String findPropertyDescription(Annotated annotated) {
        return this.inputInfoGen.getDescription(this.getAnnotatedCandidates(annotated), this.messageBundle).orElse(super.findPropertyDescription(annotated));
    }

    public TypeResolverBuilder<?> findTypeResolver(MapperConfig<?> config, AnnotatedClass ac, JavaType baseType) {
        TypeResolverBuilder original = super.findTypeResolver(config, ac, baseType);
        if (original != null) {
            return original;
        }
        if (this.typeMap.containsKey(ac.getRawType()) || this.typeMap.isEmpty() && Utils.isNotEmpty(super.findSubtypes((Annotated)ac))) {
            return typeResolverBuilder;
        }
        return null;
    }

    public List<NamedType> findSubtypes(Annotated a) {
        List original = super.findSubtypes(a);
        if ((original == null || original.isEmpty()) && this.typeMap.containsKey(a.getRawType())) {
            return this.typeMap.get(a.getRawType());
        }
        return null;
    }

    public String[] findEnumValues(MapperConfig<?> config, AnnotatedClass annotatedClass, Enum<?>[] enumValues, String[] names) {
        String[] jacksonNames = super.findEnumValues(config, annotatedClass, (Enum[])enumValues, names);
        for (int i = 0; i < enumValues.length; ++i) {
            GraphQLEnumValue annotation = ClassUtils.getEnumConstantField(enumValues[i]).getAnnotation(GraphQLEnumValue.class);
            if (annotation == null || !Utils.isNotEmpty(annotation.name())) continue;
            jacksonNames[i] = this.messageBundle.interpolate(annotation.name());
        }
        return jacksonNames;
    }

    private List<AnnotatedElement> getAnnotatedCandidates(Annotated annotated) {
        if (annotated instanceof AnnotatedParameter) {
            AnnotatedParameter parameter = (AnnotatedParameter)annotated;
            Executable owner = (Executable)parameter.getOwner().getAnnotated();
            return Collections.singletonList(owner.getParameters()[parameter.getIndex()]);
        }
        if (annotated instanceof AnnotatedField) {
            Field field = ((AnnotatedField)annotated).getAnnotated();
            return ClassUtils.getPropertyMembers(field);
        }
        if (annotated instanceof AnnotatedMethod) {
            Method setter = ((AnnotatedMethod)annotated).getAnnotated();
            return ClassUtils.getPropertyMembers(setter);
        }
        return Collections.emptyList();
    }
}

