/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata.strategy.type;

import graphql.schema.GraphqlTypeComparatorRegistry;
import io.leangen.graphql.metadata.messages.MessageBundle;
import java.beans.Introspector;
import java.lang.reflect.AnnotatedType;

public interface TypeInfoGenerator {
    public static final String INPUT_SUFFIX = "Input";
    public static final String SCALAR_SUFFIX = "Scalar";

    public String generateTypeName(AnnotatedType var1, MessageBundle var2);

    public String generateTypeDescription(AnnotatedType var1, MessageBundle var2);

    default public String generateInputTypeName(AnnotatedType type, MessageBundle messageBundle) {
        return this.generateTypeName(type, messageBundle) + INPUT_SUFFIX;
    }

    default public String generateInputTypeDescription(AnnotatedType type, MessageBundle messageBundle) {
        return this.generateTypeDescription(type, messageBundle);
    }

    default public String generateEnumTypeName(AnnotatedType type, MessageBundle messageBundle) {
        return this.generateTypeName(type, messageBundle);
    }

    default public String generateEnumTypeDescription(AnnotatedType type, MessageBundle messageBundle) {
        return this.generateTypeDescription(type, messageBundle);
    }

    default public String generateScalarTypeName(AnnotatedType type, MessageBundle messageBundle) {
        return this.generateTypeName(type, messageBundle) + SCALAR_SUFFIX;
    }

    default public String generateScalarTypeDescription(AnnotatedType type, MessageBundle messageBundle) {
        return this.generateTypeDescription(type, messageBundle);
    }

    default public String generateDirectiveTypeName(AnnotatedType type, MessageBundle messageBundle) {
        return Introspector.decapitalize(this.generateTypeName(type, messageBundle));
    }

    default public String generateDirectiveTypeDescription(AnnotatedType type, MessageBundle messageBundle) {
        return this.generateTypeDescription(type, messageBundle);
    }

    public GraphqlTypeComparatorRegistry generateComparatorRegistry(AnnotatedType var1, MessageBundle var2);
}

