/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata.strategy.query;

import graphql.language.OperationDefinition;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.annotations.GraphQLUnion;
import io.leangen.graphql.execution.GlobalEnvironment;
import io.leangen.graphql.generator.union.Union;
import io.leangen.graphql.metadata.DefaultValue;
import io.leangen.graphql.metadata.Operation;
import io.leangen.graphql.metadata.OperationArgument;
import io.leangen.graphql.metadata.Resolver;
import io.leangen.graphql.metadata.exceptions.TypeMappingException;
import io.leangen.graphql.metadata.messages.MessageBundle;
import io.leangen.graphql.metadata.strategy.query.OperationBuilder;
import io.leangen.graphql.util.ClassUtils;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class DefaultOperationBuilder
implements OperationBuilder {
    private final TypeInference typeInference;

    public DefaultOperationBuilder(TypeInference typeInference) {
        this.typeInference = typeInference;
    }

    @Override
    public Operation buildQuery(Type contextType, List<Resolver> resolvers, GlobalEnvironment environment) {
        return this.buildOperation(contextType, resolvers, OperationDefinition.Operation.QUERY, environment);
    }

    @Override
    public Operation buildMutation(Type context, List<Resolver> resolvers, GlobalEnvironment environment) {
        return this.buildOperation(context, resolvers, OperationDefinition.Operation.MUTATION, environment);
    }

    @Override
    public Operation buildSubscription(Type context, List<Resolver> resolvers, GlobalEnvironment environment) {
        return this.buildOperation(context, resolvers, OperationDefinition.Operation.SUBSCRIPTION, environment);
    }

    private Operation buildOperation(Type contextType, List<Resolver> resolvers, OperationDefinition.Operation operationType, GlobalEnvironment environment) {
        String name = this.resolveName(resolvers);
        AnnotatedType javaType = this.resolveJavaType(name, resolvers, environment.messageBundle);
        List<OperationArgument> arguments = this.collectArguments(name, resolvers);
        boolean batched = this.isBatched(resolvers);
        boolean async = this.isAsync(resolvers);
        return new Operation(name, javaType, contextType, arguments, resolvers, operationType, batched, async);
    }

    protected String resolveName(List<Resolver> resolvers) {
        return resolvers.get(0).getOperationName();
    }

    protected AnnotatedType resolveJavaType(String operationName, List<Resolver> resolvers, MessageBundle messageBundle) {
        List<AnnotatedType> returnTypes = resolvers.stream().map(Resolver::getReturnType).collect(Collectors.toList());
        if (resolvers.stream().anyMatch(resolver -> ClassUtils.containsTypeAnnotation(resolver.getReturnType(), GraphQLUnion.class))) {
            return this.unionize(returnTypes.toArray(new AnnotatedType[0]), messageBundle);
        }
        return this.resolveJavaType(returnTypes, "Multiple methods detected for operation \"" + operationName + "\" with different return types.");
    }

    protected List<OperationArgument> collectArguments(String operationName, List<Resolver> resolvers) {
        Map<String, List<OperationArgument>> argumentsByName = resolvers.stream().flatMap(resolver -> resolver.getArguments().stream()).collect(Collectors.groupingBy(OperationArgument::getName));
        String errorPrefixTemplate = "Argument %s of operation \"" + operationName + "\" has different types in different resolver methods.";
        return argumentsByName.keySet().stream().map(argName -> new OperationArgument(this.resolveJavaType(((List)argumentsByName.get(argName)).stream().map(OperationArgument::getJavaType).collect(Collectors.toList()), String.format(errorPrefixTemplate, argName)), (String)argName, (String)((List)argumentsByName.get(argName)).stream().map(OperationArgument::getDescription).filter(Objects::nonNull).findFirst().orElse(null), ((List)argumentsByName.get(argName)).stream().map(OperationArgument::getDefaultValue).filter(DefaultValue::isSet).findFirst().orElse(DefaultValue.EMPTY), ((List)argumentsByName.get(argName)).stream().map(OperationArgument::getParameter).filter(Objects::nonNull).collect(Collectors.toList()), ((List)argumentsByName.get(argName)).stream().anyMatch(OperationArgument::isContext), ((List)argumentsByName.get(argName)).stream().anyMatch(OperationArgument::isMappable))).collect(Collectors.toList());
    }

    protected boolean isBatched(List<Resolver> resolvers) {
        return resolvers.stream().anyMatch(Resolver::isBatched);
    }

    protected boolean isAsync(List<Resolver> resolvers) {
        return resolvers.stream().anyMatch(Resolver::isAsync);
    }

    protected AnnotatedType unionize(AnnotatedType[] types, MessageBundle messageBundle) {
        return Union.unionize(types, messageBundle);
    }

    private AnnotatedType resolveJavaType(List<AnnotatedType> types, String errorPrefix) {
        errorPrefix = (String)errorPrefix + " Types found: " + Arrays.toString(types.stream().map(type -> type.getType().getTypeName()).toArray()) + ". ";
        if (!this.typeInference.inferTypes && !types.stream().map(AnnotatedType::getType).allMatch(type -> type.equals(((AnnotatedType)types.get(0)).getType()))) {
            throw new TypeMappingException((String)errorPrefix + "If this is intentional, and you wish GraphQL SPQR to infer the most common super type automatically, see https://github.com/leangen/graphql-spqr/wiki/Errors#operation-with-multiple-resolver-methods-of-different-types");
        }
        try {
            return ClassUtils.getCommonSuperType(types, this.typeInference.allowObject ? GenericTypeReflector.annotate(Object.class) : null);
        }
        catch (TypeMappingException e) {
            throw new TypeMappingException((String)errorPrefix, e);
        }
    }

    public static enum TypeInference {
        NONE(false, false),
        LIMITED(true, false),
        UNLIMITED(true, true);

        public final boolean inferTypes;
        public final boolean allowObject;

        private TypeInference(boolean inferTypes, boolean allowObject) {
            this.inferTypes = inferTypes;
            this.allowObject = allowObject;
        }
    }
}

