/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata.messages;

import io.leangen.graphql.util.Utils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface MessageBundle {
    public static final Pattern VARIABLE_PATTERN = Pattern.compile("(\\$\\{([^}]+)\\})");

    public String getMessage(String var1);

    default public boolean containsKey(String key) {
        return this.getMessage(key) != null;
    }

    default public String interpolate(String template) {
        if (Utils.isEmpty(template)) {
            return template;
        }
        StringBuffer sb = new StringBuffer(template.length());
        Matcher matcher = VARIABLE_PATTERN.matcher(template);
        while (matcher.find()) {
            String replacement = this.getMessage(matcher.group(2));
            if (replacement == null) {
                replacement = matcher.group(1);
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

