/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator.mapping;

import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLOutputType;
import io.leangen.graphql.generator.BuildContext;
import io.leangen.graphql.generator.OperationMapper;
import io.leangen.graphql.metadata.TypedElement;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.List;

public class TypeMappingEnvironment {
    public final TypedElement rootElement;
    public final List<AnnotatedType> typeStack;
    public final OperationMapper operationMapper;
    public final BuildContext buildContext;

    public TypeMappingEnvironment(TypedElement rootElement, OperationMapper operationMapper, BuildContext buildContext) {
        this.rootElement = rootElement;
        this.typeStack = new ArrayList<AnnotatedType>();
        this.operationMapper = operationMapper;
        this.buildContext = buildContext;
    }

    public TypeMappingEnvironment forElement(TypedElement rootElement) {
        return new TypeMappingEnvironment(rootElement, this.operationMapper, this.buildContext);
    }

    public GraphQLOutputType toGraphQLType(AnnotatedType javaType) {
        return this.operationMapper.toGraphQLType(javaType, this);
    }

    public GraphQLInputType toGraphQLInputType(AnnotatedType javaType) {
        return this.operationMapper.toGraphQLInputType(javaType, this);
    }

    public final TypeMappingEnvironment addType(AnnotatedType type) {
        if (!this.typeStack.contains(type)) {
            this.typeStack.add(type);
        }
        return this;
    }
}

