/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator;

import graphql.TypeResolutionEnvironment;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import graphql.schema.TypeResolver;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.annotations.GraphQLTypeResolver;
import io.leangen.graphql.execution.GlobalEnvironment;
import io.leangen.graphql.generator.MappedType;
import io.leangen.graphql.metadata.exceptions.UnresolvableTypeException;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.Utils;
import java.lang.reflect.AnnotatedType;
import java.util.List;
import java.util.Optional;

public class DelegatingTypeResolver
implements TypeResolver {
    private final String abstractTypeName;
    private final GlobalEnvironment globalEnv;

    DelegatingTypeResolver(GlobalEnvironment environment) {
        this(null, environment);
    }

    DelegatingTypeResolver(String abstractTypeName, GlobalEnvironment environment) {
        this.abstractTypeName = abstractTypeName;
        this.globalEnv = environment;
    }

    public GraphQLObjectType getType(TypeResolutionEnvironment env) {
        AnnotatedType resolvedJavaType;
        Object result = env.getObject();
        Class<?> resultType = result.getClass();
        String resultTypeName = this.globalEnv.typeInfoGenerator.generateTypeName(GenericTypeReflector.annotate(resultType), this.globalEnv.messageBundle);
        GraphQLNamedType fieldType = (GraphQLNamedType)env.getFieldType();
        String abstractTypeName = this.abstractTypeName != null ? this.abstractTypeName : fieldType.getName();
        List<MappedType> mappedTypes = this.globalEnv.typeRegistry.getOutputTypes(abstractTypeName, resultType);
        if (mappedTypes.isEmpty()) {
            return (GraphQLObjectType)env.getSchema().getType(resultTypeName);
        }
        if (mappedTypes.size() == 1) {
            return mappedTypes.get(0).getAsObjectType();
        }
        AnnotatedType returnType = this.globalEnv.typeRegistry.getMappedType(fieldType);
        Optional<GraphQLObjectType> resolvedType = Utils.or(Optional.ofNullable(returnType != null ? returnType.getAnnotation(GraphQLTypeResolver.class) : null), Optional.ofNullable(resultType.getAnnotation(GraphQLTypeResolver.class))).map(ann -> this.resolveType(env, (GraphQLTypeResolver)ann));
        if (resolvedType.isPresent()) {
            return resolvedType.get();
        }
        if (returnType != null && (resolvedJavaType = GenericTypeReflector.getExactSubType((AnnotatedType)returnType, resultType)) != null && !ClassUtils.isMissingTypeParameters(resolvedJavaType.getType())) {
            GraphQLType resolved = env.getSchema().getType(this.globalEnv.typeInfoGenerator.generateTypeName(resolvedJavaType, this.globalEnv.messageBundle));
            if (resolved == null) {
                throw new UnresolvableTypeException(fieldType.getName(), result);
            }
            return (GraphQLObjectType)resolved;
        }
        throw new UnresolvableTypeException(fieldType.getName(), result);
    }

    private GraphQLObjectType resolveType(TypeResolutionEnvironment env, GraphQLTypeResolver descriptor) {
        try {
            return ClassUtils.instanceWithOptionalInjection(descriptor.value(), this.globalEnv).getType(env);
        }
        catch (Exception e) {
            throw new UnresolvableTypeException(env.getObject(), e);
        }
    }
}

