/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.execution.complexity;

import graphql.execution.ExecutionContext;
import graphql.normalized.ExecutableNormalizedField;
import graphql.normalized.ExecutableNormalizedOperation;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnionType;
import io.leangen.graphql.execution.complexity.ComplexityFunction;
import io.leangen.graphql.execution.complexity.ComplexityLimitExceededException;
import io.leangen.graphql.execution.complexity.ResolvedField;
import io.leangen.graphql.generator.TypeRegistry;
import io.leangen.graphql.metadata.Resolver;
import io.leangen.graphql.util.GraphQLUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ComplexityAnalyzer {
    private final int maxComplexity;
    private final ComplexityFunction complexityFunction;
    private final TypeRegistry typeRegistry;

    public ComplexityAnalyzer(int maxComplexity, ComplexityFunction complexityFunction, TypeRegistry typeRegistry) {
        this.maxComplexity = maxComplexity;
        this.complexityFunction = complexityFunction;
        this.typeRegistry = typeRegistry;
    }

    public int complexity(ExecutionContext context) {
        ComplexityAnalyzer analyzer = new ComplexityAnalyzer(this.maxComplexity, this.complexityFunction, this.typeRegistry);
        ExecutableNormalizedOperation tree = (ExecutableNormalizedOperation)context.getNormalizedQueryTree().get();
        GraphQLSchema schema = context.getGraphQLSchema();
        int totalComplexity = tree.getTopLevelFields().stream().map(root -> this.resolvedField(schema, (ExecutableNormalizedField)root)).mapToInt(field -> analyzer.complexity(schema, (ResolvedField)field)).sum();
        return this.check(totalComplexity);
    }

    private int complexity(GraphQLSchema schema, ResolvedField resolvedField) {
        List fields = resolvedField.getField().getChildren();
        if (this.isAbstract((GraphQLType)resolvedField.getFieldType())) {
            ArrayList<ExecutableNormalizedField> unconditionalFields = new ArrayList<ExecutableNormalizedField>();
            HashMap conditionalFieldsPerType = new HashMap();
            for (ExecutableNormalizedField subField : fields) {
                if (subField.isConditional(schema)) {
                    subField.getObjectTypeNames().forEach(obj -> {
                        conditionalFieldsPerType.computeIfAbsent(obj, __ -> new ArrayList());
                        ((List)conditionalFieldsPerType.get(obj)).add(subField);
                    });
                    continue;
                }
                unconditionalFields.add(subField);
            }
            int unconditionalChildScore = this.score(schema, unconditionalFields);
            int maxConditionalChildScore = conditionalFieldsPerType.entrySet().stream().mapToInt(e -> this.score(schema, (String)e.getKey(), (List)e.getValue())).max().orElse(0);
            return this.check(this.complexityFunction.getComplexity(resolvedField, unconditionalChildScore + maxConditionalChildScore));
        }
        int childScore = this.score(schema, fields);
        return this.check(this.complexityFunction.getComplexity(resolvedField, childScore));
    }

    private boolean isAbstract(GraphQLType type) {
        return type instanceof GraphQLInterfaceType || type instanceof GraphQLUnionType;
    }

    private FieldCoordinates coordinates(GraphQLSchema schema, ExecutableNormalizedField field) {
        return this.coordinates(GraphQLUtils.unwrap((GraphQLType)field.getParent().getType(schema)).getName(), field);
    }

    private FieldCoordinates coordinates(String concreteTypeName, ExecutableNormalizedField field) {
        return FieldCoordinates.coordinates((String)concreteTypeName, (String)field.getName());
    }

    private ResolvedField resolvedField(GraphQLSchema schema, ExecutableNormalizedField field) {
        FieldCoordinates coordinates = FieldCoordinates.coordinates((String)field.getSingleObjectTypeName(), (String)field.getFieldName());
        GraphQLOutputType type = ((GraphQLFieldDefinition)field.getFieldDefinitions(schema).get(0)).getType();
        Resolver resolver = this.typeRegistry.getMappedResolver(coordinates, field.getResolvedArguments().keySet());
        return new ResolvedField(coordinates, resolver, type, field.getResolvedArguments(), field);
    }

    private ResolvedField resolvedField(GraphQLSchema schema, FieldCoordinates coordinates, ExecutableNormalizedField field) {
        Resolver resolver = this.typeRegistry.getMappedResolver(coordinates, field.getResolvedArguments().keySet());
        return new ResolvedField(coordinates, resolver, field.getType(schema), field.getResolvedArguments(), field);
    }

    private int score(GraphQLSchema schema, List<ExecutableNormalizedField> fields) {
        return fields.stream().mapToInt(field -> this.complexity(schema, this.resolvedField(schema, this.coordinates(schema, (ExecutableNormalizedField)field), (ExecutableNormalizedField)field))).sum();
    }

    private int score(GraphQLSchema schema, String concreteTypeName, List<ExecutableNormalizedField> fields) {
        return fields.stream().mapToInt(field -> this.complexity(schema, this.resolvedField(schema, this.coordinates(concreteTypeName, (ExecutableNormalizedField)field), (ExecutableNormalizedField)field))).sum();
    }

    private int check(int score) {
        if (score > this.maxComplexity) {
            throw new ComplexityLimitExceededException(score, this.maxComplexity);
        }
        return score;
    }
}

