/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.execution.complexity;

import graphql.ExecutionResult;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimplePerformantInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationExecuteOperationParameters;
import graphql.language.AstPrinter;
import graphql.language.Node;
import io.leangen.graphql.execution.complexity.ComplexityAnalyzer;
import io.leangen.graphql.execution.complexity.ComplexityFunction;
import io.leangen.graphql.generator.TypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexityAnalysisInstrumentation
extends SimplePerformantInstrumentation {
    private final ComplexityAnalyzer analyzer;
    private static final Logger log = LoggerFactory.getLogger(ComplexityAnalysisInstrumentation.class);

    public ComplexityAnalysisInstrumentation(int maxComplexity, ComplexityFunction complexityFunction, TypeRegistry typeRegistry) {
        this.analyzer = new ComplexityAnalyzer(maxComplexity, complexityFunction, typeRegistry);
    }

    public InstrumentationContext<ExecutionResult> beginExecuteOperation(InstrumentationExecuteOperationParameters parameters, InstrumentationState state) {
        int totalComplexity = this.analyzer.complexity(parameters.getExecutionContext());
        if (log.isDebugEnabled()) {
            log.debug("Operation {} has total complexity of {}", (Object)AstPrinter.printAst((Node)((Node)parameters.getExecutionContext().getOperationDefinition().getSelectionSet().getSelections().get(0))), (Object)totalComplexity);
        }
        log.info("Total operation complexity: {}", (Object)totalComplexity);
        return super.beginExecuteOperation(parameters, state);
    }
}

