/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.execution;

import graphql.relay.Relay;
import io.leangen.graphql.generator.TypeRegistry;
import io.leangen.graphql.generator.mapping.ArgumentInjectorRegistry;
import io.leangen.graphql.generator.mapping.ConverterRegistry;
import io.leangen.graphql.generator.mapping.InputConverter;
import io.leangen.graphql.metadata.messages.EmptyMessageBundle;
import io.leangen.graphql.metadata.messages.MessageBundle;
import io.leangen.graphql.metadata.strategy.DefaultInclusionStrategy;
import io.leangen.graphql.metadata.strategy.InclusionStrategy;
import io.leangen.graphql.metadata.strategy.type.DefaultTypeInfoGenerator;
import io.leangen.graphql.metadata.strategy.type.DefaultTypeTransformer;
import io.leangen.graphql.metadata.strategy.type.TypeInfoGenerator;
import io.leangen.graphql.metadata.strategy.type.TypeTransformer;
import io.leangen.graphql.metadata.strategy.value.ValueMapper;
import java.lang.reflect.AnnotatedType;
import java.util.Collections;
import java.util.List;

public class GlobalEnvironment {
    public final MessageBundle messageBundle;
    public final Relay relay;
    public final TypeRegistry typeRegistry;
    public final ConverterRegistry converters;
    public final ArgumentInjectorRegistry injectors;
    public final TypeTransformer typeTransformer;
    public final InclusionStrategy inclusionStrategy;
    public final TypeInfoGenerator typeInfoGenerator;
    public static final GlobalEnvironment EMPTY = new EmptyEnvironment();

    public GlobalEnvironment(MessageBundle messageBundle, Relay relay, TypeRegistry typeRegistry, ConverterRegistry converters, ArgumentInjectorRegistry injectors, TypeTransformer typeTransformer, InclusionStrategy inclusionStrategy, TypeInfoGenerator typeInfoGenerator) {
        this.messageBundle = messageBundle;
        this.relay = relay;
        this.typeRegistry = typeRegistry;
        this.converters = converters;
        this.injectors = injectors;
        this.typeTransformer = typeTransformer;
        this.inclusionStrategy = inclusionStrategy;
        this.typeInfoGenerator = typeInfoGenerator;
    }

    public <T, S> T convertInput(S input, AnnotatedType type, ValueMapper valueMapper) {
        if (input == null) {
            return null;
        }
        InputConverter inputConverter = this.converters.getInputConverter(type);
        return (T)(inputConverter == null ? input : inputConverter.convertInput(input, type, this, valueMapper));
    }

    public AnnotatedType getMappableInputType(AnnotatedType type) {
        return this.converters.getMappableInputType(type);
    }

    public List<InputConverter> getInputConverters() {
        return this.converters.getInputConverters();
    }

    private static class EmptyEnvironment
    extends GlobalEnvironment {
        EmptyEnvironment() {
            super(EmptyMessageBundle.INSTANCE, new Relay(), new TypeRegistry(Collections.emptyMap()), new ConverterRegistry(Collections.emptyList(), Collections.emptyList()), new ArgumentInjectorRegistry(Collections.emptyList()), new DefaultTypeTransformer(false, false), new DefaultInclusionStrategy(new String[0]), new DefaultTypeInfoGenerator());
        }
    }
}

