/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util.authenticators;

import io.kubernetes.client.util.KubeConfig;
import io.kubernetes.client.util.authenticators.Authenticator;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCPAuthenticator
implements Authenticator {
    private static final Logger log;

    @Override
    public String getName() {
        return "gcp";
    }

    @Override
    public String getToken(Map<String, Object> config) {
        return (String)config.get("access-token");
    }

    @Override
    public boolean isExpired(Map<String, Object> config) {
        Object expiryObj = config.get("expiry");
        Instant expiry = null;
        if (expiryObj instanceof Date) {
            expiry = ((Date)expiryObj).toInstant();
        } else if (expiryObj instanceof Instant) {
            expiry = (Instant)expiryObj;
        } else if (expiryObj instanceof String) {
            expiry = Instant.parse((String)expiryObj);
        } else {
            throw new RuntimeException("Unexpected object type: " + expiryObj.getClass());
        }
        return expiry != null && expiry.compareTo(Instant.now()) <= 0;
    }

    @Override
    public Map<String, Object> refresh(Map<String, Object> config) {
        throw new IllegalStateException("Unimplemented");
    }

    static {
        KubeConfig.registerAuthenticator(new GCPAuthenticator());
        log = LoggerFactory.getLogger(GCPAuthenticator.class);
    }
}

