/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.informer.cache;

import io.kubernetes.client.informer.EventType;
import io.kubernetes.client.informer.ListerWatcher;
import io.kubernetes.client.informer.cache.Store;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.util.CallGeneratorParams;
import io.kubernetes.client.util.Reflect;
import io.kubernetes.client.util.Watch;
import io.kubernetes.client.util.Watchable;
import io.kubernetes.client.util.exception.ObjectMetaReflectException;
import java.net.ConnectException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectorRunnable<ApiType, ApiListType>
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ReflectorRunnable.class);
    private String lastSyncResourceVersion;
    private Watchable<ApiType> watch;
    private ListerWatcher<ApiType, ApiListType> listerWatcher;
    private Store<ApiType> store;
    private Class<ApiType> apiTypeClass;
    private AtomicBoolean isActive = new AtomicBoolean(true);

    public ReflectorRunnable(Class<ApiType> apiTypeClass, ListerWatcher listerWatcher, Store store) {
        this.listerWatcher = listerWatcher;
        this.store = store;
        this.apiTypeClass = apiTypeClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        try {
            ReflectorRunnable.log.info("{}#Start listing and watching...", this.apiTypeClass);
            list = this.listerWatcher.list(new CallGeneratorParams(Boolean.FALSE, null, null));
            listMeta = Reflect.listMetadata(list);
            resourceVersion = listMeta.getResourceVersion();
            items = Reflect.getItems(list);
            if (ReflectorRunnable.log.isDebugEnabled()) {
                ReflectorRunnable.log.debug("{}#Extract resourceVersion {} list meta", this.apiTypeClass, (Object)resourceVersion);
            }
            this.syncWith(items, resourceVersion);
            this.lastSyncResourceVersion = resourceVersion;
            if (ReflectorRunnable.log.isDebugEnabled()) {
                ReflectorRunnable.log.debug("{}#Start watching with {}...", this.apiTypeClass, (Object)this.lastSyncResourceVersion);
            }
            while (true) lbl-1000:
            // 4 sources

            {
                if (!this.isActive.get() && this.watch != null) {
                    this.watch.close();
                    return;
                }
                try {
                    if (ReflectorRunnable.log.isDebugEnabled()) {
                        ReflectorRunnable.log.debug("{}#Start watch with resource version {}", this.apiTypeClass, (Object)this.lastSyncResourceVersion);
                    }
                    this.watch = this.listerWatcher.watch(new CallGeneratorParams(Boolean.TRUE, this.lastSyncResourceVersion, Long.valueOf(Duration.ofMinutes(5L).toMillis()).intValue()));
                    this.watchHandler(this.watch);
                }
                catch (Throwable t) {
                    ReflectorRunnable.log.info("{}#Watch connection get exception {}", this.apiTypeClass, (Object)t.getMessage());
                    cause = t.getCause();
                    if (cause != null && cause instanceof ConnectException) {
                        ReflectorRunnable.log.info("{}#Watch get connect exception, retry watch", this.apiTypeClass);
                        Thread.sleep(1000L);
                    }
                    if (t instanceof RuntimeException && t.getMessage().contains("IO Exception during hasNext")) {
                        ReflectorRunnable.log.info("{}#Read timeout retry list and watch", this.apiTypeClass);
                        return;
                    }
                    ReflectorRunnable.log.error("{}#Watch failed as {} unexpected", new Object[]{this.apiTypeClass, t.getMessage(), t});
                    return;
                }
                finally {
                    if (this.watch == null) continue;
                    this.watch.close();
                    this.watch = null;
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            ReflectorRunnable.log.error("{}#Failed to list-watch: {}", this.apiTypeClass, (Object)t);
            return;
        }
        ** GOTO lbl-1000
    }

    public void stop() {
        this.isActive.set(false);
    }

    private void syncWith(List<ApiType> items, String resourceVersion) {
        this.store.replace(items, resourceVersion);
    }

    public String getLastSyncResourceVersion() {
        return this.lastSyncResourceVersion;
    }

    private void watchHandler(Watchable<ApiType> watch) {
        while (watch.hasNext()) {
            V1ObjectMeta meta;
            Watch.Response item = (Watch.Response)watch.next();
            EventType eventType = EventType.getByType(item.type);
            if (eventType == null) {
                log.error("unrecognized event {}", (Object)item);
                continue;
            }
            if (eventType == EventType.ERROR) {
                String errorMessage = String.format("got ERROR event and its status: %s", item.status.toString());
                log.error(errorMessage);
                throw new RuntimeException(errorMessage);
            }
            Object obj = item.object;
            try {
                meta = Reflect.objectMetadata(obj);
            }
            catch (ObjectMetaReflectException e) {
                log.error("malformed watch event {}", (Object)item);
                continue;
            }
            String newResourceVersion = meta.getResourceVersion();
            switch (eventType) {
                case ADDED: {
                    this.store.add(obj);
                    break;
                }
                case MODIFIED: {
                    this.store.update(obj);
                    break;
                }
                case DELETED: {
                    this.store.delete(obj);
                }
            }
            this.lastSyncResourceVersion = newResourceVersion;
            if (!log.isDebugEnabled()) continue;
            log.debug("{}#Receiving resourceVersion {}", this.apiTypeClass, (Object)this.lastSyncResourceVersion);
        }
    }
}

