/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client;

import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Message;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.proto.Meta;
import io.kubernetes.client.proto.Runtime;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSource;
import okio.ByteString;

public class ProtoClient {
    private ApiClient apiClient;
    private static final byte[] MAGIC = new byte[]{107, 56, 115, 0};
    private static final ByteString MAGIC_BYTESTRING = ByteString.of((byte[])MAGIC);
    private static final String MEDIA_TYPE = "application/vnd.kubernetes.protobuf";

    public ProtoClient() {
        this(Configuration.getDefaultApiClient());
    }

    public ProtoClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public <T extends Message> ObjectOrStatus<T> get(Message.Builder builder, String path) throws ApiException, IOException {
        return this.request(builder, path, "GET", null, null, null);
    }

    public <T extends Message> ObjectOrStatus<T> list(Message.Builder builder, String path) throws ApiException, IOException {
        return this.get(builder, path);
    }

    public <T extends Message> ObjectOrStatus<T> create(T obj, String path, String apiVersion, String kind) throws ApiException, IOException {
        return this.request(obj.newBuilderForType(), path, "POST", obj, apiVersion, kind);
    }

    public <T extends Message> ObjectOrStatus<T> update(T obj, String path, String apiVersion, String kind) throws ApiException, IOException {
        return this.request(obj.newBuilderForType(), path, "PUT", obj, apiVersion, kind);
    }

    public <T extends Message> ObjectOrStatus<T> merge(T obj, String path, String apiVersion, String kind) throws ApiException, IOException {
        return this.request(obj.newBuilderForType(), path, "PATCH", obj, apiVersion, kind);
    }

    public <T extends Message> ObjectOrStatus<T> delete(Message.Builder builder, String path) throws ApiException, IOException {
        return this.request(builder, path, "DELETE", null, null, null);
    }

    public <T extends Message> ObjectOrStatus<T> delete(Message.Builder builder, String path, Meta.DeleteOptions deleteOptions) throws ApiException, IOException {
        if (deleteOptions == null) {
            return this.delete(builder, path);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", MEDIA_TYPE);
        headers.put("Accept", MEDIA_TYPE);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        Request request = this.apiClient.buildRequest(this.apiClient.getBasePath(), path, "DELETE", new ArrayList(), new ArrayList(), null, headers, new HashMap(), new HashMap(), localVarAuthNames, null);
        byte[] bytes = ProtoClient.encode((Message)deleteOptions, "v1", "DeleteOptions");
        request = request.newBuilder().delete(RequestBody.create((MediaType)MediaType.parse((String)MEDIA_TYPE), (byte[])bytes)).build();
        return this.getObjectOrStatusFromServer(builder, request);
    }

    public <T extends Message> ObjectOrStatus<T> request(Message.Builder builder, String path, String method, T body, String apiVersion, String kind) throws ApiException, IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", MEDIA_TYPE);
        headers.put("Accept", MEDIA_TYPE);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        Request request = this.apiClient.buildRequest(this.apiClient.getBasePath(), path, method, new ArrayList(), new ArrayList(), null, headers, new HashMap(), new HashMap(), localVarAuthNames, null);
        if (body != null) {
            byte[] bytes = ProtoClient.encode(body, apiVersion, kind);
            switch (method) {
                case "POST": {
                    request = request.newBuilder().post(RequestBody.create((MediaType)MediaType.parse((String)MEDIA_TYPE), (byte[])bytes)).build();
                    break;
                }
                case "PUT": {
                    request = request.newBuilder().put(RequestBody.create((MediaType)MediaType.parse((String)MEDIA_TYPE), (byte[])bytes)).build();
                    break;
                }
                case "PATCH": {
                    request = request.newBuilder().patch(RequestBody.create((MediaType)MediaType.parse((String)MEDIA_TYPE), (byte[])bytes)).build();
                    break;
                }
                default: {
                    throw new ApiException("Unknown proto client API method: " + method);
                }
            }
        }
        return this.getObjectOrStatusFromServer(builder, request);
    }

    private <T extends Message> ObjectOrStatus<T> getObjectOrStatusFromServer(Message.Builder builder, Request request) throws IOException, ApiException {
        Runtime.Unknown u;
        try (Response resp = this.apiClient.getHttpClient().newCall(request).execute();){
            u = ProtoClient.parse(resp.body().source());
        }
        if (u.getTypeMeta().getApiVersion().equals("v1") && u.getTypeMeta().getKind().equals("Status")) {
            Meta.Status status = ((Meta.Status.Builder)Meta.Status.newBuilder().mergeFrom(u.getRaw())).build();
            return new ObjectOrStatus<Object>(null, status);
        }
        return new ObjectOrStatus<Message>(builder.mergeFrom(u.getRaw()).build(), null);
    }

    private static byte[] encode(Message msg, String apiVersion, String kind) throws IOException {
        Runtime.Unknown u = Runtime.Unknown.newBuilder().setTypeMeta(Runtime.TypeMeta.newBuilder().setApiVersion(apiVersion).setKind(kind)).setRaw(msg.toByteString()).build();
        int serializedSize = u.getSerializedSize();
        byte[] result = new byte[MAGIC.length + u.getSerializedSize()];
        System.arraycopy(MAGIC, 0, result, 0, MAGIC.length);
        u.writeTo(CodedOutputStream.newInstance((byte[])result, (int)MAGIC.length, (int)serializedSize));
        return result;
    }

    private static Runtime.Unknown parse(BufferedSource responseBody) throws ApiException, IOException {
        if (!responseBody.request((long)MAGIC.length)) {
            throw new ApiException("Truncated reading magic number");
        }
        if (!responseBody.rangeEquals(0L, MAGIC_BYTESTRING)) {
            ByteString badMagic = responseBody.readByteString((long)MAGIC.length);
            throw new ApiException("Unexpected magic number: " + badMagic.hex());
        }
        responseBody.skip((long)MAGIC.length);
        return Runtime.Unknown.parseFrom((InputStream)responseBody.inputStream());
    }

    public static class ObjectOrStatus<T extends Message> {
        public T object;
        public Meta.Status status;

        public ObjectOrStatus(T obj, Meta.Status status) {
            this.object = obj;
            this.status = status;
        }

        public String toString() {
            if (this.object != null) {
                return this.object.toString();
            }
            return this.status.toString();
        }
    }
}

