/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.informer;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum EventType {
    ADDED,
    MODIFIED,
    DELETED,
    BOOKMARK,
    ERROR;

    private static final Map<String, EventType> TYPES;

    @Deprecated
    public static EventType getByType(String type) {
        if (type != null && type.length() > 0) {
            for (EventType eventType : EventType.values()) {
                if (!eventType.name().equalsIgnoreCase(type)) continue;
                return eventType;
            }
        }
        return null;
    }

    public static Optional<EventType> findByType(String type) {
        return Optional.ofNullable(TYPES.get(String.valueOf(type).toUpperCase()));
    }

    static {
        TYPES = Arrays.stream(EventType.values()).collect(Collectors.toMap(Enum::name, Function.identity()));
    }
}

