/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.informer.cache;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.informer.cache.Indexer;
import io.kubernetes.client.util.Strings;
import java.util.List;

public class Lister<ApiType extends KubernetesObject> {
    private String namespace;
    private String indexName;
    private Indexer<ApiType> indexer;

    public Lister(Indexer<ApiType> indexer) {
        this(indexer, null, "namespace");
    }

    public Lister(Indexer<ApiType> indexer, String namespace) {
        this(indexer, namespace, "namespace");
    }

    public Lister(Indexer<ApiType> indexer, String namespace, String indexName) {
        this.indexer = indexer;
        this.namespace = namespace;
        this.indexName = indexName;
    }

    public List<ApiType> list() {
        if (Strings.isNullOrEmpty(this.namespace)) {
            return this.indexer.list();
        }
        return this.indexer.byIndex(this.indexName, this.namespace);
    }

    public ApiType get(String name) {
        String key = name;
        if (!Strings.isNullOrEmpty(this.namespace)) {
            key = this.namespace + "/" + name;
        }
        return (ApiType)((KubernetesObject)this.indexer.getByKey(key));
    }

    public Lister<ApiType> namespace(String namespace) {
        return new Lister<ApiType>(this.indexer, namespace, "namespace");
    }
}

