/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.controller;

import io.kubernetes.client.extended.controller.Controller;
import io.kubernetes.client.extended.controller.reconciler.Reconciler;
import io.kubernetes.client.extended.controller.reconciler.Request;
import io.kubernetes.client.extended.controller.reconciler.Result;
import io.kubernetes.client.extended.wait.Wait;
import io.kubernetes.client.extended.workqueue.RateLimitingQueue;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultController
implements Controller {
    private static final Logger log = LoggerFactory.getLogger(DefaultController.class);
    private static Gauge gaugeWorkQueueLength = (Gauge)((Gauge.Builder)Gauge.build((String)"controller_work_queue_length", (String)"Current length of the controller's work-queue").labelNames(new String[]{"name"})).register();
    private static Counter counterControllerReconcile = (Counter)((Counter.Builder)Counter.build((String)"controller_reconcile_count_total", (String)"Total count of controller reconciliation").labelNames(new String[]{"name", "requeue"})).register();
    private final Reconciler reconciler;
    private final String name;
    private final RateLimitingQueue<Request> workQueue;
    private final Supplier<Boolean>[] readyFuncs;
    private int workerCount;
    private ScheduledExecutorService workerThreadPool;
    private Duration readyTimeout;
    private Duration readyCheckInternal;

    public DefaultController(String name, Reconciler reconciler, RateLimitingQueue<Request> workQueue, Supplier<Boolean> ... readyFuncs) {
        this(name, reconciler, workQueue, (CollectorRegistry)null, readyFuncs);
    }

    public DefaultController(String name, Reconciler reconciler, RateLimitingQueue<Request> workQueue, CollectorRegistry collectorRegistry, Supplier<Boolean> ... readyFuncs) {
        this.name = name;
        this.reconciler = reconciler;
        this.workQueue = workQueue;
        this.readyFuncs = readyFuncs;
        this.readyTimeout = Duration.ofSeconds(30L);
        this.readyCheckInternal = Duration.ofSeconds(1L);
    }

    private boolean preFlightCheck() {
        if (this.workerCount <= 0) {
            log.error("Fail to start controller {}: worker count must be positive.", (Object)this.name);
            return false;
        }
        if (this.workerThreadPool == null) {
            log.error("Fail to start controller {}: missing worker thread-pool.", (Object)this.name);
            return false;
        }
        if (!this.isReady()) {
            log.error("Fail to start controller {}: Timed out waiting for cache to be synced.", (Object)this.name);
            return false;
        }
        return true;
    }

    private boolean isReady() {
        boolean synced = true;
        if (this.readyFuncs.length > 0) {
            synced = Wait.poll((Duration)Duration.ZERO, (Duration)this.readyCheckInternal, (Duration)this.readyTimeout, () -> {
                boolean ready = true;
                for (Supplier<Boolean> cacheHasSyncedFunc : this.readyFuncs) {
                    ready = ready && cacheHasSyncedFunc.get() != false;
                }
                return ready;
            });
        }
        return synced;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.preFlightCheck()) {
            log.error("Controller {} failed pre-run check, exiting..", (Object)this.name);
            return;
        }
        CountDownLatch latch = new CountDownLatch(this.workerCount);
        int i = 0;
        while (i < this.workerCount) {
            int workerIndex = i++;
            this.workerThreadPool.scheduleWithFixedDelay(() -> {
                log.debug("Starting controller {} worker {}..", (Object)this.name, (Object)workerIndex);
                try {
                    this.worker();
                }
                catch (Throwable t) {
                    log.error("Unexpected controller loop abortion", t);
                }
                latch.countDown();
                log.debug("Exiting controller {} worker {}..", (Object)this.name, (Object)workerIndex);
            }, 0L, 1L, TimeUnit.SECONDS);
        }
        try {
            log.debug("Controller {} bootstrapping..", (Object)this.name);
            latch.await();
        }
        catch (InterruptedException e) {
            log.error("Aborting controller.", (Throwable)e);
        }
        finally {
            log.info("Controller {} exited", (Object)this.name);
        }
    }

    @Override
    public void shutdown() {
        this.workQueue.shutDown();
        this.workerThreadPool.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void worker() {
        while (!this.workQueue.isShuttingDown()) {
            Request request;
            block14: {
                block13: {
                    ((Gauge.Child)gaugeWorkQueueLength.labels(new String[]{this.name})).set((double)this.workQueue.length());
                    request = null;
                    try {
                        request = (Request)this.workQueue.get();
                    }
                    catch (InterruptedException e) {
                        log.error("Controller worker interrupted.. keeps working until work-queue shutdown", (Throwable)e);
                        if (request == null) break block13;
                        this.workQueue.addRateLimited(request);
                    }
                }
                if (request == null) {
                    log.info("Controller {} worker exiting because work-queue has shutdown..", (Object)this.name);
                    return;
                }
                log.debug("Controller {} start reconciling {}..", (Object)this.name, (Object)request);
                Result result = null;
                try {
                    result = this.reconciler.reconcile(request);
                }
                catch (Throwable t) {
                    try {
                        log.error("Reconciler aborted unexpectedly", t);
                        result = new Result(true);
                    }
                    catch (Throwable throwable) {
                        ((Counter.Child)counterControllerReconcile.labels(new String[]{this.name, Boolean.toString(result.isRequeue())})).inc();
                        throw throwable;
                    }
                    ((Counter.Child)counterControllerReconcile.labels(new String[]{this.name, Boolean.toString(result.isRequeue())})).inc();
                }
                ((Counter.Child)counterControllerReconcile.labels(new String[]{this.name, Boolean.toString(result.isRequeue())})).inc();
                try {
                    if (result.isRequeue()) {
                        if (result.getRequeueAfter() == null) {
                            log.debug("Controller {} reconciling {} failed, requeuing {}..", (Object)this.name, (Object)request);
                            this.workQueue.addRateLimited(request);
                        } else {
                            log.debug("Controller {} reconciling {} failed, requeuing after {}..", new Object[]{this.name, request, result.getRequeueAfter()});
                            this.workQueue.addAfter(request, result.getRequeueAfter());
                        }
                        break block14;
                    }
                    this.workQueue.forget(request);
                }
                catch (Throwable throwable) {
                    this.workQueue.done(request);
                    ((Gauge.Child)gaugeWorkQueueLength.labels(new String[]{this.name})).set((double)this.workQueue.length());
                    log.debug("Controller {} finished reconciling {}..", (Object)this.name, (Object)request);
                    throw throwable;
                }
            }
            this.workQueue.done(request);
            ((Gauge.Child)gaugeWorkQueueLength.labels(new String[]{this.name})).set((double)this.workQueue.length());
            log.debug("Controller {} finished reconciling {}..", (Object)this.name, (Object)request);
        }
    }

    public RateLimitingQueue<Request> getWorkQueue() {
        return this.workQueue;
    }

    public String getName() {
        return this.name;
    }

    public int getWorkerCount() {
        return this.workerCount;
    }

    public void setWorkerCount(int workerCount) {
        this.workerCount = workerCount;
    }

    public ExecutorService getWorkerThreadPool() {
        return this.workerThreadPool;
    }

    public void setWorkerThreadPool(ScheduledExecutorService workerThreadPool) {
        this.workerThreadPool = workerThreadPool;
    }

    public Reconciler getReconciler() {
        return this.reconciler;
    }

    public Duration getReadyTimeout() {
        return this.readyTimeout;
    }

    public void setReadyTimeout(Duration readyTimeout) {
        this.readyTimeout = readyTimeout;
    }

    public Duration getReadyCheckInternal() {
        return this.readyCheckInternal;
    }

    public void setReadyCheckInternal(Duration readyCheckInternal) {
        this.readyCheckInternal = readyCheckInternal;
    }
}

