/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1LabelSelectorBuilder;
import io.kubernetes.client.openapi.models.V1LabelSelectorFluentImpl;
import io.kubernetes.client.openapi.models.V2beta1CrossVersionObjectReference;
import io.kubernetes.client.openapi.models.V2beta1CrossVersionObjectReferenceBuilder;
import io.kubernetes.client.openapi.models.V2beta1CrossVersionObjectReferenceFluentImpl;
import io.kubernetes.client.openapi.models.V2beta1ObjectMetricSource;
import io.kubernetes.client.openapi.models.V2beta1ObjectMetricSourceFluent;

public class V2beta1ObjectMetricSourceFluentImpl<A extends V2beta1ObjectMetricSourceFluent<A>>
extends BaseFluent<A>
implements V2beta1ObjectMetricSourceFluent<A> {
    private Quantity averageValue;
    private String metricName;
    private V1LabelSelectorBuilder selector;
    private V2beta1CrossVersionObjectReferenceBuilder target;
    private Quantity targetValue;

    public V2beta1ObjectMetricSourceFluentImpl() {
    }

    public V2beta1ObjectMetricSourceFluentImpl(V2beta1ObjectMetricSource instance) {
        this.withAverageValue(instance.getAverageValue());
        this.withMetricName(instance.getMetricName());
        this.withSelector(instance.getSelector());
        this.withTarget(instance.getTarget());
        this.withTargetValue(instance.getTargetValue());
    }

    @Override
    public Quantity getAverageValue() {
        return this.averageValue;
    }

    @Override
    public A withAverageValue(Quantity averageValue) {
        this.averageValue = averageValue;
        return (A)this;
    }

    @Override
    public Boolean hasAverageValue() {
        return this.averageValue != null;
    }

    @Override
    public A withNewAverageValue(String value) {
        return this.withAverageValue(new Quantity(value));
    }

    @Override
    public String getMetricName() {
        return this.metricName;
    }

    @Override
    public A withMetricName(String metricName) {
        this.metricName = metricName;
        return (A)this;
    }

    @Override
    public Boolean hasMetricName() {
        return this.metricName != null;
    }

    @Override
    public A withNewMetricName(String arg1) {
        return this.withMetricName(new String(arg1));
    }

    @Override
    public A withNewMetricName(StringBuilder arg1) {
        return this.withMetricName(new String(arg1));
    }

    @Override
    public A withNewMetricName(StringBuffer arg1) {
        return this.withMetricName(new String(arg1));
    }

    @Override
    @Deprecated
    public V1LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public V1LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(V1LabelSelector selector) {
        this._visitables.get("selector").remove(this.selector);
        if (selector != null) {
            this.selector = new V1LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public V2beta1ObjectMetricSourceFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public V2beta1ObjectMetricSourceFluent.SelectorNested<A> withNewSelectorLike(V1LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public V2beta1ObjectMetricSourceFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public V2beta1ObjectMetricSourceFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new V1LabelSelectorBuilder().build());
    }

    @Override
    public V2beta1ObjectMetricSourceFluent.SelectorNested<A> editOrNewSelectorLike(V1LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    @Deprecated
    public V2beta1CrossVersionObjectReference getTarget() {
        return this.target != null ? this.target.build() : null;
    }

    @Override
    public V2beta1CrossVersionObjectReference buildTarget() {
        return this.target != null ? this.target.build() : null;
    }

    @Override
    public A withTarget(V2beta1CrossVersionObjectReference target) {
        this._visitables.get("target").remove(this.target);
        if (target != null) {
            this.target = new V2beta1CrossVersionObjectReferenceBuilder(target);
            this._visitables.get("target").add(this.target);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTarget() {
        return this.target != null;
    }

    @Override
    public V2beta1ObjectMetricSourceFluent.TargetNested<A> withNewTarget() {
        return new TargetNestedImpl();
    }

    @Override
    public V2beta1ObjectMetricSourceFluent.TargetNested<A> withNewTargetLike(V2beta1CrossVersionObjectReference item) {
        return new TargetNestedImpl(item);
    }

    @Override
    public V2beta1ObjectMetricSourceFluent.TargetNested<A> editTarget() {
        return this.withNewTargetLike(this.getTarget());
    }

    @Override
    public V2beta1ObjectMetricSourceFluent.TargetNested<A> editOrNewTarget() {
        return this.withNewTargetLike(this.getTarget() != null ? this.getTarget() : new V2beta1CrossVersionObjectReferenceBuilder().build());
    }

    @Override
    public V2beta1ObjectMetricSourceFluent.TargetNested<A> editOrNewTargetLike(V2beta1CrossVersionObjectReference item) {
        return this.withNewTargetLike(this.getTarget() != null ? this.getTarget() : item);
    }

    @Override
    public Quantity getTargetValue() {
        return this.targetValue;
    }

    @Override
    public A withTargetValue(Quantity targetValue) {
        this.targetValue = targetValue;
        return (A)this;
    }

    @Override
    public Boolean hasTargetValue() {
        return this.targetValue != null;
    }

    @Override
    public A withNewTargetValue(String value) {
        return this.withTargetValue(new Quantity(value));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2beta1ObjectMetricSourceFluentImpl that = (V2beta1ObjectMetricSourceFluentImpl)o;
        if (this.averageValue != null ? !this.averageValue.equals(that.averageValue) : that.averageValue != null) {
            return false;
        }
        if (this.metricName != null ? !this.metricName.equals(that.metricName) : that.metricName != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        if (this.target != null ? !this.target.equals(that.target) : that.target != null) {
            return false;
        }
        return !(this.targetValue != null ? !this.targetValue.equals(that.targetValue) : that.targetValue != null);
    }

    public class TargetNestedImpl<N>
    extends V2beta1CrossVersionObjectReferenceFluentImpl<V2beta1ObjectMetricSourceFluent.TargetNested<N>>
    implements V2beta1ObjectMetricSourceFluent.TargetNested<N>,
    Nested<N> {
        private final V2beta1CrossVersionObjectReferenceBuilder builder;

        TargetNestedImpl(V2beta1CrossVersionObjectReference item) {
            this.builder = new V2beta1CrossVersionObjectReferenceBuilder(this, item);
        }

        TargetNestedImpl() {
            this.builder = new V2beta1CrossVersionObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V2beta1ObjectMetricSourceFluentImpl.this.withTarget(this.builder.build());
        }

        @Override
        public N endTarget() {
            return this.and();
        }
    }

    public class SelectorNestedImpl<N>
    extends V1LabelSelectorFluentImpl<V2beta1ObjectMetricSourceFluent.SelectorNested<N>>
    implements V2beta1ObjectMetricSourceFluent.SelectorNested<N>,
    Nested<N> {
        private final V1LabelSelectorBuilder builder;

        SelectorNestedImpl(V1LabelSelector item) {
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new V1LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)V2beta1ObjectMetricSourceFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }
}

