/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.openapi.models.V1StatusCause;
import io.kubernetes.client.openapi.models.V1StatusCauseBuilder;
import io.kubernetes.client.openapi.models.V1StatusCauseFluentImpl;
import io.kubernetes.client.openapi.models.V1StatusDetails;
import io.kubernetes.client.openapi.models.V1StatusDetailsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class V1StatusDetailsFluentImpl<A extends V1StatusDetailsFluent<A>>
extends BaseFluent<A>
implements V1StatusDetailsFluent<A> {
    private List<V1StatusCauseBuilder> causes;
    private String group;
    private String kind;
    private String name;
    private Integer retryAfterSeconds;
    private String uid;

    public V1StatusDetailsFluentImpl() {
    }

    public V1StatusDetailsFluentImpl(V1StatusDetails instance) {
        this.withCauses(instance.getCauses());
        this.withGroup(instance.getGroup());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withRetryAfterSeconds(instance.getRetryAfterSeconds());
        this.withUid(instance.getUid());
    }

    @Override
    public A addToCauses(int index, V1StatusCause item) {
        if (this.causes == null) {
            this.causes = new ArrayList<V1StatusCauseBuilder>();
        }
        V1StatusCauseBuilder builder = new V1StatusCauseBuilder(item);
        this._visitables.get("causes").add(index >= 0 ? index : this._visitables.get("causes").size(), builder);
        this.causes.add(index >= 0 ? index : this.causes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToCauses(int index, V1StatusCause item) {
        if (this.causes == null) {
            this.causes = new ArrayList<V1StatusCauseBuilder>();
        }
        V1StatusCauseBuilder builder = new V1StatusCauseBuilder(item);
        if (index < 0 || index >= this._visitables.get("causes").size()) {
            this._visitables.get("causes").add(builder);
        } else {
            this._visitables.get("causes").set(index, builder);
        }
        if (index < 0 || index >= this.causes.size()) {
            this.causes.add(builder);
        } else {
            this.causes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToCauses(V1StatusCause ... items) {
        if (this.causes == null) {
            this.causes = new ArrayList<V1StatusCauseBuilder>();
        }
        for (V1StatusCause item : items) {
            V1StatusCauseBuilder builder = new V1StatusCauseBuilder(item);
            this._visitables.get("causes").add(builder);
            this.causes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToCauses(Collection<V1StatusCause> items) {
        if (this.causes == null) {
            this.causes = new ArrayList<V1StatusCauseBuilder>();
        }
        for (V1StatusCause item : items) {
            V1StatusCauseBuilder builder = new V1StatusCauseBuilder(item);
            this._visitables.get("causes").add(builder);
            this.causes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromCauses(V1StatusCause ... items) {
        for (V1StatusCause item : items) {
            V1StatusCauseBuilder builder = new V1StatusCauseBuilder(item);
            this._visitables.get("causes").remove(builder);
            if (this.causes == null) continue;
            this.causes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCauses(Collection<V1StatusCause> items) {
        for (V1StatusCause item : items) {
            V1StatusCauseBuilder builder = new V1StatusCauseBuilder(item);
            this._visitables.get("causes").remove(builder);
            if (this.causes == null) continue;
            this.causes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromCauses(Predicate<V1StatusCauseBuilder> predicate) {
        if (this.causes == null) {
            return (A)this;
        }
        Iterator<V1StatusCauseBuilder> each = this.causes.iterator();
        Object visitables = this._visitables.get("causes");
        while (each.hasNext()) {
            V1StatusCauseBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1StatusCause> getCauses() {
        return V1StatusDetailsFluentImpl.build(this.causes);
    }

    @Override
    public List<V1StatusCause> buildCauses() {
        return V1StatusDetailsFluentImpl.build(this.causes);
    }

    @Override
    public V1StatusCause buildCause(int index) {
        return this.causes.get(index).build();
    }

    @Override
    public V1StatusCause buildFirstCause() {
        return this.causes.get(0).build();
    }

    @Override
    public V1StatusCause buildLastCause() {
        return this.causes.get(this.causes.size() - 1).build();
    }

    @Override
    public V1StatusCause buildMatchingCause(Predicate<V1StatusCauseBuilder> predicate) {
        for (V1StatusCauseBuilder item : this.causes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCause(Predicate<V1StatusCauseBuilder> predicate) {
        for (V1StatusCauseBuilder item : this.causes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCauses(List<V1StatusCause> causes) {
        if (this.causes != null) {
            this._visitables.get("causes").removeAll(this.causes);
        }
        if (causes != null) {
            this.causes = new ArrayList<V1StatusCauseBuilder>();
            for (V1StatusCause item : causes) {
                this.addToCauses(item);
            }
        } else {
            this.causes = null;
        }
        return (A)this;
    }

    @Override
    public A withCauses(V1StatusCause ... causes) {
        if (this.causes != null) {
            this.causes.clear();
        }
        if (causes != null) {
            for (V1StatusCause item : causes) {
                this.addToCauses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCauses() {
        return this.causes != null && !this.causes.isEmpty();
    }

    @Override
    public V1StatusDetailsFluent.CausesNested<A> addNewCause() {
        return new CausesNestedImpl();
    }

    @Override
    public V1StatusDetailsFluent.CausesNested<A> addNewCauseLike(V1StatusCause item) {
        return new CausesNestedImpl(-1, item);
    }

    @Override
    public V1StatusDetailsFluent.CausesNested<A> setNewCauseLike(int index, V1StatusCause item) {
        return new CausesNestedImpl(index, item);
    }

    @Override
    public V1StatusDetailsFluent.CausesNested<A> editCause(int index) {
        if (this.causes.size() <= index) {
            throw new RuntimeException("Can't edit causes. Index exceeds size.");
        }
        return this.setNewCauseLike(index, this.buildCause(index));
    }

    @Override
    public V1StatusDetailsFluent.CausesNested<A> editFirstCause() {
        if (this.causes.size() == 0) {
            throw new RuntimeException("Can't edit first causes. The list is empty.");
        }
        return this.setNewCauseLike(0, this.buildCause(0));
    }

    @Override
    public V1StatusDetailsFluent.CausesNested<A> editLastCause() {
        int index = this.causes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last causes. The list is empty.");
        }
        return this.setNewCauseLike(index, this.buildCause(index));
    }

    @Override
    public V1StatusDetailsFluent.CausesNested<A> editMatchingCause(Predicate<V1StatusCauseBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.causes.size(); ++i) {
            if (!predicate.apply(this.causes.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching causes. No match found.");
        }
        return this.setNewCauseLike(index, this.buildCause(index));
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public A withGroup(String group) {
        this.group = group;
        return (A)this;
    }

    @Override
    public Boolean hasGroup() {
        return this.group != null;
    }

    @Override
    public A withNewGroup(String arg1) {
        return this.withGroup(new String(arg1));
    }

    @Override
    public A withNewGroup(StringBuilder arg1) {
        return this.withGroup(new String(arg1));
    }

    @Override
    public A withNewGroup(StringBuffer arg1) {
        return this.withGroup(new String(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A withNewName(String arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuilder arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuffer arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public Integer getRetryAfterSeconds() {
        return this.retryAfterSeconds;
    }

    @Override
    public A withRetryAfterSeconds(Integer retryAfterSeconds) {
        this.retryAfterSeconds = retryAfterSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasRetryAfterSeconds() {
        return this.retryAfterSeconds != null;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public A withUid(String uid) {
        this.uid = uid;
        return (A)this;
    }

    @Override
    public Boolean hasUid() {
        return this.uid != null;
    }

    @Override
    public A withNewUid(String arg1) {
        return this.withUid(new String(arg1));
    }

    @Override
    public A withNewUid(StringBuilder arg1) {
        return this.withUid(new String(arg1));
    }

    @Override
    public A withNewUid(StringBuffer arg1) {
        return this.withUid(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1StatusDetailsFluentImpl that = (V1StatusDetailsFluentImpl)o;
        if (this.causes != null ? !this.causes.equals(that.causes) : that.causes != null) {
            return false;
        }
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.retryAfterSeconds != null ? !this.retryAfterSeconds.equals(that.retryAfterSeconds) : that.retryAfterSeconds != null) {
            return false;
        }
        return !(this.uid != null ? !this.uid.equals(that.uid) : that.uid != null);
    }

    public class CausesNestedImpl<N>
    extends V1StatusCauseFluentImpl<V1StatusDetailsFluent.CausesNested<N>>
    implements V1StatusDetailsFluent.CausesNested<N>,
    Nested<N> {
        private final V1StatusCauseBuilder builder;
        private final int index;

        CausesNestedImpl(int index, V1StatusCause item) {
            this.index = index;
            this.builder = new V1StatusCauseBuilder(this, item);
        }

        CausesNestedImpl() {
            this.index = -1;
            this.builder = new V1StatusCauseBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1StatusDetailsFluentImpl.this.setToCauses(this.index, this.builder.build());
        }

        @Override
        public N endCause() {
            return this.and();
        }
    }
}

