/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.openapi.models.AdmissionregistrationV1WebhookClientConfig;
import io.kubernetes.client.openapi.models.AdmissionregistrationV1WebhookClientConfigBuilder;
import io.kubernetes.client.openapi.models.AdmissionregistrationV1WebhookClientConfigFluentImpl;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1LabelSelectorBuilder;
import io.kubernetes.client.openapi.models.V1LabelSelectorFluentImpl;
import io.kubernetes.client.openapi.models.V1MutatingWebhook;
import io.kubernetes.client.openapi.models.V1MutatingWebhookFluent;
import io.kubernetes.client.openapi.models.V1RuleWithOperations;
import io.kubernetes.client.openapi.models.V1RuleWithOperationsBuilder;
import io.kubernetes.client.openapi.models.V1RuleWithOperationsFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class V1MutatingWebhookFluentImpl<A extends V1MutatingWebhookFluent<A>>
extends BaseFluent<A>
implements V1MutatingWebhookFluent<A> {
    private List<String> admissionReviewVersions;
    private AdmissionregistrationV1WebhookClientConfigBuilder clientConfig;
    private String failurePolicy;
    private String matchPolicy;
    private String name;
    private V1LabelSelectorBuilder namespaceSelector;
    private V1LabelSelectorBuilder objectSelector;
    private String reinvocationPolicy;
    private List<V1RuleWithOperationsBuilder> rules;
    private String sideEffects;
    private Integer timeoutSeconds;

    public V1MutatingWebhookFluentImpl() {
    }

    public V1MutatingWebhookFluentImpl(V1MutatingWebhook instance) {
        this.withAdmissionReviewVersions(instance.getAdmissionReviewVersions());
        this.withClientConfig(instance.getClientConfig());
        this.withFailurePolicy(instance.getFailurePolicy());
        this.withMatchPolicy(instance.getMatchPolicy());
        this.withName(instance.getName());
        this.withNamespaceSelector(instance.getNamespaceSelector());
        this.withObjectSelector(instance.getObjectSelector());
        this.withReinvocationPolicy(instance.getReinvocationPolicy());
        this.withRules(instance.getRules());
        this.withSideEffects(instance.getSideEffects());
        this.withTimeoutSeconds(instance.getTimeoutSeconds());
    }

    @Override
    public A addToAdmissionReviewVersions(int index, String item) {
        if (this.admissionReviewVersions == null) {
            this.admissionReviewVersions = new ArrayList<String>();
        }
        this.admissionReviewVersions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAdmissionReviewVersions(int index, String item) {
        if (this.admissionReviewVersions == null) {
            this.admissionReviewVersions = new ArrayList<String>();
        }
        this.admissionReviewVersions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAdmissionReviewVersions(String ... items) {
        if (this.admissionReviewVersions == null) {
            this.admissionReviewVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.admissionReviewVersions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAdmissionReviewVersions(Collection<String> items) {
        if (this.admissionReviewVersions == null) {
            this.admissionReviewVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.admissionReviewVersions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdmissionReviewVersions(String ... items) {
        for (String item : items) {
            if (this.admissionReviewVersions == null) continue;
            this.admissionReviewVersions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAdmissionReviewVersions(Collection<String> items) {
        for (String item : items) {
            if (this.admissionReviewVersions == null) continue;
            this.admissionReviewVersions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAdmissionReviewVersions() {
        return this.admissionReviewVersions;
    }

    @Override
    public String getAdmissionReviewVersion(int index) {
        return this.admissionReviewVersions.get(index);
    }

    @Override
    public String getFirstAdmissionReviewVersion() {
        return this.admissionReviewVersions.get(0);
    }

    @Override
    public String getLastAdmissionReviewVersion() {
        return this.admissionReviewVersions.get(this.admissionReviewVersions.size() - 1);
    }

    @Override
    public String getMatchingAdmissionReviewVersion(Predicate<String> predicate) {
        for (String item : this.admissionReviewVersions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAdmissionReviewVersion(Predicate<String> predicate) {
        for (String item : this.admissionReviewVersions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAdmissionReviewVersions(List<String> admissionReviewVersions) {
        if (this.admissionReviewVersions != null) {
            this._visitables.get("admissionReviewVersions").removeAll(this.admissionReviewVersions);
        }
        if (admissionReviewVersions != null) {
            this.admissionReviewVersions = new ArrayList<String>();
            for (String item : admissionReviewVersions) {
                this.addToAdmissionReviewVersions(item);
            }
        } else {
            this.admissionReviewVersions = null;
        }
        return (A)this;
    }

    @Override
    public A withAdmissionReviewVersions(String ... admissionReviewVersions) {
        if (this.admissionReviewVersions != null) {
            this.admissionReviewVersions.clear();
        }
        if (admissionReviewVersions != null) {
            for (String item : admissionReviewVersions) {
                this.addToAdmissionReviewVersions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAdmissionReviewVersions() {
        return this.admissionReviewVersions != null && !this.admissionReviewVersions.isEmpty();
    }

    @Override
    public A addNewAdmissionReviewVersion(String arg1) {
        return this.addToAdmissionReviewVersions(new String(arg1));
    }

    @Override
    public A addNewAdmissionReviewVersion(StringBuilder arg1) {
        return this.addToAdmissionReviewVersions(new String(arg1));
    }

    @Override
    public A addNewAdmissionReviewVersion(StringBuffer arg1) {
        return this.addToAdmissionReviewVersions(new String(arg1));
    }

    @Override
    @Deprecated
    public AdmissionregistrationV1WebhookClientConfig getClientConfig() {
        return this.clientConfig != null ? this.clientConfig.build() : null;
    }

    @Override
    public AdmissionregistrationV1WebhookClientConfig buildClientConfig() {
        return this.clientConfig != null ? this.clientConfig.build() : null;
    }

    @Override
    public A withClientConfig(AdmissionregistrationV1WebhookClientConfig clientConfig) {
        this._visitables.get("clientConfig").remove(this.clientConfig);
        if (clientConfig != null) {
            this.clientConfig = new AdmissionregistrationV1WebhookClientConfigBuilder(clientConfig);
            this._visitables.get("clientConfig").add(this.clientConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasClientConfig() {
        return this.clientConfig != null;
    }

    @Override
    public V1MutatingWebhookFluent.ClientConfigNested<A> withNewClientConfig() {
        return new ClientConfigNestedImpl();
    }

    @Override
    public V1MutatingWebhookFluent.ClientConfigNested<A> withNewClientConfigLike(AdmissionregistrationV1WebhookClientConfig item) {
        return new ClientConfigNestedImpl(item);
    }

    @Override
    public V1MutatingWebhookFluent.ClientConfigNested<A> editClientConfig() {
        return this.withNewClientConfigLike(this.getClientConfig());
    }

    @Override
    public V1MutatingWebhookFluent.ClientConfigNested<A> editOrNewClientConfig() {
        return this.withNewClientConfigLike(this.getClientConfig() != null ? this.getClientConfig() : new AdmissionregistrationV1WebhookClientConfigBuilder().build());
    }

    @Override
    public V1MutatingWebhookFluent.ClientConfigNested<A> editOrNewClientConfigLike(AdmissionregistrationV1WebhookClientConfig item) {
        return this.withNewClientConfigLike(this.getClientConfig() != null ? this.getClientConfig() : item);
    }

    @Override
    public String getFailurePolicy() {
        return this.failurePolicy;
    }

    @Override
    public A withFailurePolicy(String failurePolicy) {
        this.failurePolicy = failurePolicy;
        return (A)this;
    }

    @Override
    public Boolean hasFailurePolicy() {
        return this.failurePolicy != null;
    }

    @Override
    public A withNewFailurePolicy(String arg1) {
        return this.withFailurePolicy(new String(arg1));
    }

    @Override
    public A withNewFailurePolicy(StringBuilder arg1) {
        return this.withFailurePolicy(new String(arg1));
    }

    @Override
    public A withNewFailurePolicy(StringBuffer arg1) {
        return this.withFailurePolicy(new String(arg1));
    }

    @Override
    public String getMatchPolicy() {
        return this.matchPolicy;
    }

    @Override
    public A withMatchPolicy(String matchPolicy) {
        this.matchPolicy = matchPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasMatchPolicy() {
        return this.matchPolicy != null;
    }

    @Override
    public A withNewMatchPolicy(String arg1) {
        return this.withMatchPolicy(new String(arg1));
    }

    @Override
    public A withNewMatchPolicy(StringBuilder arg1) {
        return this.withMatchPolicy(new String(arg1));
    }

    @Override
    public A withNewMatchPolicy(StringBuffer arg1) {
        return this.withMatchPolicy(new String(arg1));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A withNewName(String arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuilder arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuffer arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    @Deprecated
    public V1LabelSelector getNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    @Override
    public V1LabelSelector buildNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    @Override
    public A withNamespaceSelector(V1LabelSelector namespaceSelector) {
        this._visitables.get("namespaceSelector").remove(this.namespaceSelector);
        if (namespaceSelector != null) {
            this.namespaceSelector = new V1LabelSelectorBuilder(namespaceSelector);
            this._visitables.get("namespaceSelector").add(this.namespaceSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    @Override
    public V1MutatingWebhookFluent.NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new NamespaceSelectorNestedImpl();
    }

    @Override
    public V1MutatingWebhookFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(V1LabelSelector item) {
        return new NamespaceSelectorNestedImpl(item);
    }

    @Override
    public V1MutatingWebhookFluent.NamespaceSelectorNested<A> editNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(this.getNamespaceSelector());
    }

    @Override
    public V1MutatingWebhookFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(this.getNamespaceSelector() != null ? this.getNamespaceSelector() : new V1LabelSelectorBuilder().build());
    }

    @Override
    public V1MutatingWebhookFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(V1LabelSelector item) {
        return this.withNewNamespaceSelectorLike(this.getNamespaceSelector() != null ? this.getNamespaceSelector() : item);
    }

    @Override
    @Deprecated
    public V1LabelSelector getObjectSelector() {
        return this.objectSelector != null ? this.objectSelector.build() : null;
    }

    @Override
    public V1LabelSelector buildObjectSelector() {
        return this.objectSelector != null ? this.objectSelector.build() : null;
    }

    @Override
    public A withObjectSelector(V1LabelSelector objectSelector) {
        this._visitables.get("objectSelector").remove(this.objectSelector);
        if (objectSelector != null) {
            this.objectSelector = new V1LabelSelectorBuilder(objectSelector);
            this._visitables.get("objectSelector").add(this.objectSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasObjectSelector() {
        return this.objectSelector != null;
    }

    @Override
    public V1MutatingWebhookFluent.ObjectSelectorNested<A> withNewObjectSelector() {
        return new ObjectSelectorNestedImpl();
    }

    @Override
    public V1MutatingWebhookFluent.ObjectSelectorNested<A> withNewObjectSelectorLike(V1LabelSelector item) {
        return new ObjectSelectorNestedImpl(item);
    }

    @Override
    public V1MutatingWebhookFluent.ObjectSelectorNested<A> editObjectSelector() {
        return this.withNewObjectSelectorLike(this.getObjectSelector());
    }

    @Override
    public V1MutatingWebhookFluent.ObjectSelectorNested<A> editOrNewObjectSelector() {
        return this.withNewObjectSelectorLike(this.getObjectSelector() != null ? this.getObjectSelector() : new V1LabelSelectorBuilder().build());
    }

    @Override
    public V1MutatingWebhookFluent.ObjectSelectorNested<A> editOrNewObjectSelectorLike(V1LabelSelector item) {
        return this.withNewObjectSelectorLike(this.getObjectSelector() != null ? this.getObjectSelector() : item);
    }

    @Override
    public String getReinvocationPolicy() {
        return this.reinvocationPolicy;
    }

    @Override
    public A withReinvocationPolicy(String reinvocationPolicy) {
        this.reinvocationPolicy = reinvocationPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasReinvocationPolicy() {
        return this.reinvocationPolicy != null;
    }

    @Override
    public A withNewReinvocationPolicy(String arg1) {
        return this.withReinvocationPolicy(new String(arg1));
    }

    @Override
    public A withNewReinvocationPolicy(StringBuilder arg1) {
        return this.withReinvocationPolicy(new String(arg1));
    }

    @Override
    public A withNewReinvocationPolicy(StringBuffer arg1) {
        return this.withReinvocationPolicy(new String(arg1));
    }

    @Override
    public A addToRules(int index, V1RuleWithOperations item) {
        if (this.rules == null) {
            this.rules = new ArrayList<V1RuleWithOperationsBuilder>();
        }
        V1RuleWithOperationsBuilder builder = new V1RuleWithOperationsBuilder(item);
        this._visitables.get("rules").add(index >= 0 ? index : this._visitables.get("rules").size(), builder);
        this.rules.add(index >= 0 ? index : this.rules.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRules(int index, V1RuleWithOperations item) {
        if (this.rules == null) {
            this.rules = new ArrayList<V1RuleWithOperationsBuilder>();
        }
        V1RuleWithOperationsBuilder builder = new V1RuleWithOperationsBuilder(item);
        if (index < 0 || index >= this._visitables.get("rules").size()) {
            this._visitables.get("rules").add(builder);
        } else {
            this._visitables.get("rules").set(index, builder);
        }
        if (index < 0 || index >= this.rules.size()) {
            this.rules.add(builder);
        } else {
            this.rules.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRules(V1RuleWithOperations ... items) {
        if (this.rules == null) {
            this.rules = new ArrayList<V1RuleWithOperationsBuilder>();
        }
        for (V1RuleWithOperations item : items) {
            V1RuleWithOperationsBuilder builder = new V1RuleWithOperationsBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRules(Collection<V1RuleWithOperations> items) {
        if (this.rules == null) {
            this.rules = new ArrayList<V1RuleWithOperationsBuilder>();
        }
        for (V1RuleWithOperations item : items) {
            V1RuleWithOperationsBuilder builder = new V1RuleWithOperationsBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRules(V1RuleWithOperations ... items) {
        for (V1RuleWithOperations item : items) {
            V1RuleWithOperationsBuilder builder = new V1RuleWithOperationsBuilder(item);
            this._visitables.get("rules").remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRules(Collection<V1RuleWithOperations> items) {
        for (V1RuleWithOperations item : items) {
            V1RuleWithOperationsBuilder builder = new V1RuleWithOperationsBuilder(item);
            this._visitables.get("rules").remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromRules(Predicate<V1RuleWithOperationsBuilder> predicate) {
        if (this.rules == null) {
            return (A)this;
        }
        Iterator<V1RuleWithOperationsBuilder> each = this.rules.iterator();
        Object visitables = this._visitables.get("rules");
        while (each.hasNext()) {
            V1RuleWithOperationsBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1RuleWithOperations> getRules() {
        return V1MutatingWebhookFluentImpl.build(this.rules);
    }

    @Override
    public List<V1RuleWithOperations> buildRules() {
        return V1MutatingWebhookFluentImpl.build(this.rules);
    }

    @Override
    public V1RuleWithOperations buildRule(int index) {
        return this.rules.get(index).build();
    }

    @Override
    public V1RuleWithOperations buildFirstRule() {
        return this.rules.get(0).build();
    }

    @Override
    public V1RuleWithOperations buildLastRule() {
        return this.rules.get(this.rules.size() - 1).build();
    }

    @Override
    public V1RuleWithOperations buildMatchingRule(Predicate<V1RuleWithOperationsBuilder> predicate) {
        for (V1RuleWithOperationsBuilder item : this.rules) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRule(Predicate<V1RuleWithOperationsBuilder> predicate) {
        for (V1RuleWithOperationsBuilder item : this.rules) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRules(List<V1RuleWithOperations> rules) {
        if (this.rules != null) {
            this._visitables.get("rules").removeAll(this.rules);
        }
        if (rules != null) {
            this.rules = new ArrayList<V1RuleWithOperationsBuilder>();
            for (V1RuleWithOperations item : rules) {
                this.addToRules(item);
            }
        } else {
            this.rules = null;
        }
        return (A)this;
    }

    @Override
    public A withRules(V1RuleWithOperations ... rules) {
        if (this.rules != null) {
            this.rules.clear();
        }
        if (rules != null) {
            for (V1RuleWithOperations item : rules) {
                this.addToRules(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    @Override
    public V1MutatingWebhookFluent.RulesNested<A> addNewRule() {
        return new RulesNestedImpl();
    }

    @Override
    public V1MutatingWebhookFluent.RulesNested<A> addNewRuleLike(V1RuleWithOperations item) {
        return new RulesNestedImpl(-1, item);
    }

    @Override
    public V1MutatingWebhookFluent.RulesNested<A> setNewRuleLike(int index, V1RuleWithOperations item) {
        return new RulesNestedImpl(index, item);
    }

    @Override
    public V1MutatingWebhookFluent.RulesNested<A> editRule(int index) {
        if (this.rules.size() <= index) {
            throw new RuntimeException("Can't edit rules. Index exceeds size.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public V1MutatingWebhookFluent.RulesNested<A> editFirstRule() {
        if (this.rules.size() == 0) {
            throw new RuntimeException("Can't edit first rules. The list is empty.");
        }
        return this.setNewRuleLike(0, this.buildRule(0));
    }

    @Override
    public V1MutatingWebhookFluent.RulesNested<A> editLastRule() {
        int index = this.rules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last rules. The list is empty.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public V1MutatingWebhookFluent.RulesNested<A> editMatchingRule(Predicate<V1RuleWithOperationsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!predicate.apply(this.rules.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching rules. No match found.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public String getSideEffects() {
        return this.sideEffects;
    }

    @Override
    public A withSideEffects(String sideEffects) {
        this.sideEffects = sideEffects;
        return (A)this;
    }

    @Override
    public Boolean hasSideEffects() {
        return this.sideEffects != null;
    }

    @Override
    public A withNewSideEffects(String arg1) {
        return this.withSideEffects(new String(arg1));
    }

    @Override
    public A withNewSideEffects(StringBuilder arg1) {
        return this.withSideEffects(new String(arg1));
    }

    @Override
    public A withNewSideEffects(StringBuffer arg1) {
        return this.withSideEffects(new String(arg1));
    }

    @Override
    public Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    @Override
    public A withTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasTimeoutSeconds() {
        return this.timeoutSeconds != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1MutatingWebhookFluentImpl that = (V1MutatingWebhookFluentImpl)o;
        if (this.admissionReviewVersions != null ? !this.admissionReviewVersions.equals(that.admissionReviewVersions) : that.admissionReviewVersions != null) {
            return false;
        }
        if (this.clientConfig != null ? !this.clientConfig.equals(that.clientConfig) : that.clientConfig != null) {
            return false;
        }
        if (this.failurePolicy != null ? !this.failurePolicy.equals(that.failurePolicy) : that.failurePolicy != null) {
            return false;
        }
        if (this.matchPolicy != null ? !this.matchPolicy.equals(that.matchPolicy) : that.matchPolicy != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.namespaceSelector != null ? !this.namespaceSelector.equals(that.namespaceSelector) : that.namespaceSelector != null) {
            return false;
        }
        if (this.objectSelector != null ? !this.objectSelector.equals(that.objectSelector) : that.objectSelector != null) {
            return false;
        }
        if (this.reinvocationPolicy != null ? !this.reinvocationPolicy.equals(that.reinvocationPolicy) : that.reinvocationPolicy != null) {
            return false;
        }
        if (this.rules != null ? !this.rules.equals(that.rules) : that.rules != null) {
            return false;
        }
        if (this.sideEffects != null ? !this.sideEffects.equals(that.sideEffects) : that.sideEffects != null) {
            return false;
        }
        return !(this.timeoutSeconds != null ? !this.timeoutSeconds.equals(that.timeoutSeconds) : that.timeoutSeconds != null);
    }

    public class RulesNestedImpl<N>
    extends V1RuleWithOperationsFluentImpl<V1MutatingWebhookFluent.RulesNested<N>>
    implements V1MutatingWebhookFluent.RulesNested<N>,
    Nested<N> {
        private final V1RuleWithOperationsBuilder builder;
        private final int index;

        RulesNestedImpl(int index, V1RuleWithOperations item) {
            this.index = index;
            this.builder = new V1RuleWithOperationsBuilder(this, item);
        }

        RulesNestedImpl() {
            this.index = -1;
            this.builder = new V1RuleWithOperationsBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1MutatingWebhookFluentImpl.this.setToRules(this.index, this.builder.build());
        }

        @Override
        public N endRule() {
            return this.and();
        }
    }

    public class ObjectSelectorNestedImpl<N>
    extends V1LabelSelectorFluentImpl<V1MutatingWebhookFluent.ObjectSelectorNested<N>>
    implements V1MutatingWebhookFluent.ObjectSelectorNested<N>,
    Nested<N> {
        private final V1LabelSelectorBuilder builder;

        ObjectSelectorNestedImpl(V1LabelSelector item) {
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        ObjectSelectorNestedImpl() {
            this.builder = new V1LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1MutatingWebhookFluentImpl.this.withObjectSelector(this.builder.build());
        }

        @Override
        public N endObjectSelector() {
            return this.and();
        }
    }

    public class NamespaceSelectorNestedImpl<N>
    extends V1LabelSelectorFluentImpl<V1MutatingWebhookFluent.NamespaceSelectorNested<N>>
    implements V1MutatingWebhookFluent.NamespaceSelectorNested<N>,
    Nested<N> {
        private final V1LabelSelectorBuilder builder;

        NamespaceSelectorNestedImpl(V1LabelSelector item) {
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        NamespaceSelectorNestedImpl() {
            this.builder = new V1LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1MutatingWebhookFluentImpl.this.withNamespaceSelector(this.builder.build());
        }

        @Override
        public N endNamespaceSelector() {
            return this.and();
        }
    }

    public class ClientConfigNestedImpl<N>
    extends AdmissionregistrationV1WebhookClientConfigFluentImpl<V1MutatingWebhookFluent.ClientConfigNested<N>>
    implements V1MutatingWebhookFluent.ClientConfigNested<N>,
    Nested<N> {
        private final AdmissionregistrationV1WebhookClientConfigBuilder builder;

        ClientConfigNestedImpl(AdmissionregistrationV1WebhookClientConfig item) {
            this.builder = new AdmissionregistrationV1WebhookClientConfigBuilder(this, item);
        }

        ClientConfigNestedImpl() {
            this.builder = new AdmissionregistrationV1WebhookClientConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1MutatingWebhookFluentImpl.this.withClientConfig(this.builder.build());
        }

        @Override
        public N endClientConfig() {
            return this.and();
        }
    }
}

